/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.execution.remoteissue;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.csp.core.bugtracker.core.BugTrackerForwardAttachmentException;
import org.squashtest.tm.bugtracker.definition.Attachment;
import org.squashtest.tm.bugtracker.definition.RemoteIssue;
import org.squashtest.tm.bugtracker.definition.context.RemoteIssueContext;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.bugtracker.Issue;
import org.squashtest.tm.domain.bugtracker.IssueDetector;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.domain.execution.SessionNote;
import org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender;
import org.squashtest.tm.domain.testautomation.FailureDetail;
import org.squashtest.tm.service.attachment.UploadedData;
import org.squashtest.tm.service.bugtracker.BugTrackersLocalService;
import org.squashtest.tm.service.execution.ExecutionFinder;
import org.squashtest.tm.service.execution.ExecutionModificationService;
import org.squashtest.tm.service.execution.ExecutionStepFinder;
import org.squashtest.tm.service.execution.IssueHolder;
import org.squashtest.tm.service.execution.SessionNoteService;
import org.squashtest.tm.service.execution.automatedexecution.AutomatedExecutionFailureDetailService;
import org.squashtest.tm.service.execution.automatedexecution.AutomatedExecutionFlagService;
import org.squashtest.tm.service.internal.bugtracker.RemoteIssueContextHelper;
import org.squashtest.tm.service.internal.bugtracker.knownissues.remote.IssueHolderEntityType;
import org.squashtest.tm.service.remoteissue.RemoteIssueReportService;
import oslcdomain.OslcIssue;

@Service
@Transactional
public class RemoteIssueReportServiceImpl
implements RemoteIssueReportService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteIssueReportServiceImpl.class);
    private static final String ISSUE_ID = "issueId";
    private static final String URL = "url";
    private static final String POSTING_NEW_ISSUE_FOR_FAILURE_DETAIL = "Posting new issue for failure detail %d";
    private final BugTrackersLocalService bugTrackersLocalService;
    private final AutomatedExecutionFailureDetailService failureDetailService;
    private final ExecutionFinder executionFinder;
    private final AutomatedExecutionFlagService automatedExecutionFlagService;
    Map<IssueHolderEntityType, IssueHolder> entityFinderByEntityType;
    Map<IssueHolderEntityType, IssueDetector> issueDetectorByEntityType;

    public RemoteIssueReportServiceImpl(ExecutionModificationService executionFinder, SessionNoteService sessionNoteService, ExecutionStepFinder executionStepFinder, BugTrackersLocalService bugTrackersLocalService, AutomatedExecutionFailureDetailService failureDetailService, AutomatedExecutionFlagService automatedExecutionFlagService) {
        this.bugTrackersLocalService = bugTrackersLocalService;
        this.failureDetailService = failureDetailService;
        this.executionFinder = executionFinder;
        this.automatedExecutionFlagService = automatedExecutionFlagService;
        this.entityFinderByEntityType = Map.of(IssueHolderEntityType.EXECUTION_STEP, (IssueHolder)((Object)executionStepFinder), IssueHolderEntityType.EXECUTION, (IssueHolder)((Object)executionFinder), IssueHolderEntityType.SESSION_NOTE, (IssueHolder)((Object)sessionNoteService));
        this.issueDetectorByEntityType = Map.of(IssueHolderEntityType.EXECUTION_STEP, new ExecutionStep(), IssueHolderEntityType.EXECUTION, new Execution(), IssueHolderEntityType.SESSION_NOTE, new SessionNote());
    }

    @Override
    public RemoteIssue makeManualIssueHolderReportIssueModel(String entityType, long entityId, String projectName, String squashPublicUrl, MessageSource messageSource) {
        RemoteIssueContext context = this.entityFinderByEntityType.get((Object)IssueHolderEntityType.fromValue(entityType)).getRemoteIssueContext(entityId, squashPublicUrl, messageSource);
        BugTracker bugTracker = this.entityFinderByEntityType.get((Object)IssueHolderEntityType.fromValue(entityType)).findBugTrackerByEntityId(entityId);
        RemoteIssue reportModel = this.bugTrackersLocalService.createReportIssueTemplate(projectName, bugTracker, context);
        this.setDefaultDescriptionIfNeeded(reportModel, context);
        return reportModel;
    }

    @Override
    public RemoteIssue makeFailureDetailReportIssueModel(long failureDetailId, long extenderId, String projectName, String squashPublicUrl, MessageSource messageSource) {
        FailureDetail failureDetail = this.failureDetailService.findFailureDetailById(failureDetailId);
        Execution execution = this.executionFinder.findExecutionExtenderByExtenderId(extenderId).getExecution();
        RemoteIssueContext context = RemoteIssueContextHelper.getRemoteIssueContext(squashPublicUrl, failureDetail, execution, messageSource);
        BugTracker bugTracker = execution.getBugTracker();
        RemoteIssue reportModel = this.bugTrackersLocalService.createReportIssueTemplate(projectName, bugTracker, context);
        this.setDefaultDescriptionIfNeeded(reportModel, context);
        return reportModel;
    }

    @Override
    public Map<String, String> postManualIssueHolderIssueReport(String entityType, long entityId, RemoteIssue jsonIssue) {
        this.entityFinderByEntityType.get((Object)IssueHolderEntityType.fromValue(entityType)).checkCanAddIssue(entityId);
        IssueDetector issueDetector = this.entityFinderByEntityType.get((Object)IssueHolderEntityType.fromValue(entityType)).fetchIssueDetector(entityId);
        if (jsonIssue instanceof OslcIssue || !jsonIssue.hasBlankId()) {
            return this.attachIssue(jsonIssue, issueDetector);
        }
        return this.processIssue(jsonIssue, issueDetector);
    }

    @Override
    public Map<String, String> postFailureDetailIssueReport(long failureDetailId, long extenderId, RemoteIssue jsonIssue) {
        LOGGER.trace(POSTING_NEW_ISSUE_FOR_FAILURE_DETAIL.formatted(failureDetailId), new Object[0]);
        FailureDetail entity = this.failureDetailService.findFailureDetailById(failureDetailId);
        AutomatedExecutionExtender extender = this.executionFinder.findExecutionExtenderByExtenderId(extenderId);
        List<Execution> filteredExecutions = this.failureDetailService.findExecutionsByFailureDetailAndDateAfter(failureDetailId, extender.getExecution().getCreatedOn());
        if (jsonIssue.hasBlankId()) {
            return this.handleNewFailureDetailIssue(jsonIssue, filteredExecutions, entity);
        }
        return this.handleAttachFailureDetailIssue(jsonIssue, filteredExecutions, entity);
    }

    @Override
    public void postFailureDetailOslcIssue(long failureDetailId, long extenderId, OslcIssue oslcIssue) {
        LOGGER.trace(POSTING_NEW_ISSUE_FOR_FAILURE_DETAIL.formatted(failureDetailId), new Object[0]);
        FailureDetail entity = this.failureDetailService.findFailureDetailById(failureDetailId);
        AutomatedExecutionExtender extender = this.executionFinder.findExecutionExtenderByExtenderId(extenderId);
        List<Execution> executions = this.failureDetailService.findExecutionsByFailureDetailAndDateAfter(failureDetailId, extender.getExecution().getCreatedOn());
        OslcIssue issue = new OslcIssue();
        issue.setId(oslcIssue.getId());
        this.attachIssue((RemoteIssue)issue, (IssueDetector)entity);
        executions.forEach(execution -> {
            Map<String, String> map = this.attachIssue((RemoteIssue)issue, (IssueDetector)execution);
        });
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void forwardAttachmentsToIssue(String btName, String remoteIssueId, List<UploadedData> uploads) {
        issueAttachments = new ArrayList<Attachment>(uploads.size());
        for (UploadedData upload : uploads) {
            newAttachment = new Attachment(upload.getName(), upload.getSizeInBytes(), upload.getStream());
            issueAttachments.add(newAttachment);
        }
        try {
            try {
                this.bugTrackersLocalService.forwardAttachments(remoteIssueId, btName, issueAttachments);
            }
            catch (RuntimeException ex) {
                throw new BugTrackerForwardAttachmentException((Throwable)ex);
            }
        }
        finally {
            ** for (attachment : issueAttachments)
        }
lbl-1000:
        // 1 sources

        {
            try {
                attachment.getStreamContent().close();
            }
            catch (IOException ex) {
                RemoteIssueReportServiceImpl.LOGGER.warn("issue attachments: could not close stream for {}, this is non fatal anyway", new Object[]{attachment.getName(), ex});
            }
            continue;
        }
lbl21:
        // 1 sources

    }

    private void setDefaultDescriptionIfNeeded(RemoteIssue issue, RemoteIssueContext context) {
        if (issue.getDescription() == null || issue.getDescription().isEmpty()) {
            issue.setDescription(context.getDefaultDescription());
        }
    }

    private Map<String, String> processIssue(RemoteIssue issue, IssueDetector entity) {
        RemoteIssue postedIssue = this.bugTrackersLocalService.createIssue(entity, issue);
        URL issueUrl = this.bugTrackersLocalService.getIssueUrl(postedIssue.getId(), entity.getBugTracker());
        this.linkIssueToRemoteRequirements(entity, postedIssue);
        return Map.of(URL, issueUrl.toString(), ISSUE_ID, postedIssue.getId());
    }

    private void linkIssueToRemoteRequirements(IssueDetector entity, RemoteIssue postedIssue) {
        List<String> remoteReqIds = this.bugTrackersLocalService.findAllRemoteReqIdByServerUrlVerifiedByATestCase(entity.getBugTracker().getUrl(), entity.getReferencedTestCase().getId());
        if (!remoteReqIds.isEmpty()) {
            this.bugTrackersLocalService.linkIssueToRemoteRequirements(postedIssue.getId(), remoteReqIds, entity.getBugTracker());
        }
    }

    private Map<String, String> attachIssue(RemoteIssue issue, IssueDetector entity) {
        this.bugTrackersLocalService.attachIssue(issue, entity, issue.getId());
        URL issueUrl = this.bugTrackersLocalService.getIssueUrl(issue.getId(), entity.getBugTracker());
        this.linkIssueToRemoteRequirements(entity, issue);
        return Map.of(URL, issueUrl.toString(), ISSUE_ID, issue.getId());
    }

    private Map<String, String> handleNewFailureDetailIssue(RemoteIssue issue, List<Execution> executions, FailureDetail failureDetail) {
        Map<String, String> newIssue = this.processIssue(issue, (IssueDetector)failureDetail);
        issue.setId(newIssue.get(ISSUE_ID));
        executions.forEach(execution -> {
            this.attachIssue(issue, (IssueDetector)execution);
            this.automatedExecutionFlagService.handleFlagReset(execution.getAutomatedExecutionExtender().getId());
        });
        return newIssue;
    }

    private Map<String, String> handleAttachFailureDetailIssue(RemoteIssue issue, List<Execution> executions, FailureDetail failureDetail) {
        Map<String, String> result = this.attachIssue(issue, (IssueDetector)failureDetail);
        executions.forEach(execution -> {
            List<String> executionIssueIds = execution.getIssues().stream().map(Issue::getRemoteIssueId).toList();
            if (!executionIssueIds.contains(issue.getId())) {
                this.attachIssue(issue, (IssueDetector)execution);
            }
            this.automatedExecutionFlagService.handleFlagReset(execution.getAutomatedExecutionExtender().getId());
        });
        return result;
    }
}

