/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.attachment.AttachmentList;
import org.squashtest.tm.domain.attachment.ExternalContentCoordinates;
import org.squashtest.tm.domain.library.Folder;
import org.squashtest.tm.domain.library.LibraryNode;
import org.squashtest.tm.service.attachment.AttachmentManagerService;
import org.squashtest.tm.service.deletion.OperationReport;
import org.squashtest.tm.service.deletion.SuppressionPreviewReport;
import org.squashtest.tm.service.internal.deletion.LockedFolderInferenceTree;
import org.squashtest.tm.service.internal.library.NodeDeletionHandler;
import org.squashtest.tm.service.internal.repository.FolderDao;

public abstract class AbstractNodeDeletionHandler<NODE extends LibraryNode, FOLDER extends Folder<NODE>>
implements NodeDeletionHandler<NODE, FOLDER> {
    protected final AttachmentManagerService attachmentManager;

    protected AbstractNodeDeletionHandler(AttachmentManagerService attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    protected abstract FolderDao<FOLDER, NODE> getFolderDao();

    @Override
    public List<SuppressionPreviewReport> simulateDeletion(List<Long> targetIds) {
        List<Long> nodeIds = this.findNodeHierarchy(targetIds);
        return this.diagnoseSuppression(nodeIds);
    }

    @Override
    public OperationReport deleteNodes(List<Long> targetIds) {
        if (!targetIds.isEmpty()) {
            LockedFolderInferenceTree tree = this.createLockedFileInferenceTree(targetIds);
            List<Long> deletableNodeIds = tree.collectDeletableIds();
            OperationReport deleteReport = !deletableNodeIds.isEmpty() ? this.batchDeleteNodes(deletableNodeIds) : new OperationReport();
            if (this.isMilestoneMode()) {
                List candidateNodeIds = tree.collectKeys();
                OperationReport unbindReport = this.batchUnbindFromMilestone(candidateNodeIds);
                deleteReport.mergeWith(unbindReport);
            }
            return deleteReport;
        }
        return new OperationReport();
    }

    protected abstract boolean isMilestoneMode();

    protected LockedFolderInferenceTree createLockedFileInferenceTree(List<Long> targetIds) {
        List<Long[]> hierarchy = this.findPairedNodeHierarchy(targetIds);
        LockedFolderInferenceTree tree = new LockedFolderInferenceTree();
        tree.build(hierarchy);
        List<Long> lockedNodeIds = this.detectLockedNodes(tree.collectKeys());
        tree.markLockedNodes(lockedNodeIds);
        tree.resolveLockedFolders();
        return tree;
    }

    protected List<Long[]> findPairedNodeHierarchy(List<Long> rootNodeIds) {
        if (rootNodeIds.isEmpty()) {
            return new ArrayList<Long[]>();
        }
        ArrayList<Long[]> nodeHierarchy = new ArrayList<Long[]>();
        for (Long id : rootNodeIds) {
            Long[] longArray = new Long[2];
            longArray[1] = id;
            nodeHierarchy.add(longArray);
        }
        List<Long> currentLayer = rootNodeIds;
        while (!currentLayer.isEmpty()) {
            List<Long[]> nextPairedLayer = this.getFolderDao().findPairedContentForList(currentLayer);
            nodeHierarchy.addAll(nextPairedLayer);
            currentLayer = new LinkedList<Long>(CollectionUtils.collect(nextPairedLayer, (Transformer)new Transformer(){

                public Object transform(Object input) {
                    return ((Object[])input)[1];
                }
            }));
        }
        return nodeHierarchy;
    }

    protected List<Long> findNodeHierarchy(List<Long> rootNodeIds) {
        if (rootNodeIds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Long> nodeHierarchy = new ArrayList<Long>();
        nodeHierarchy.addAll(rootNodeIds);
        List<Long> currentLayer = rootNodeIds;
        while (!currentLayer.isEmpty()) {
            List<Long> nextPairedLayer = this.getFolderDao().findContentForList(currentLayer);
            nodeHierarchy.addAll(nextPairedLayer);
            currentLayer = nextPairedLayer;
        }
        return nodeHierarchy;
    }

    protected abstract List<Long> detectLockedNodes(List<Long> var1);

    protected abstract List<SuppressionPreviewReport> diagnoseSuppression(List<Long> var1);

    protected abstract OperationReport batchDeleteNodes(List<Long> var1);

    protected abstract OperationReport batchUnbindFromMilestone(List<Long> var1);

    protected List<ExternalContentCoordinates> getExternalAttachmentContentCoordinatesOfObject(AttachmentHolder attachmentHolder) {
        AttachmentList attachmentList = attachmentHolder.getAttachmentList();
        List<Long> listOfAttachmentListId = this.makeListAttachmentListIdFordAttachmentList(attachmentList);
        return this.attachmentManager.getListIDbyContentIdForAttachmentLists(listOfAttachmentListId);
    }

    protected List<Long> makeListAttachmentListIdFordAttachmentList(AttachmentList attachmentList) {
        Long attachmentListId = attachmentList.getId();
        return Collections.singletonList(attachmentListId);
    }
}

