/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport.testcase;

import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.tm.core.foundation.lang.PathUtils;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.CallTestStep;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.DatasetParamValue;
import org.squashtest.tm.domain.testcase.IsScriptedTestCaseVisitor;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.domain.testcase.ParameterAssignationMode;
import org.squashtest.tm.domain.testcase.ScriptedTestCase;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.domain.testcase.TestCaseStatus;
import org.squashtest.tm.domain.testcase.TestCaseVisitor;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.service.clipboard.model.ClipboardPayload;
import org.squashtest.tm.service.importer.ImportStatus;
import org.squashtest.tm.service.importer.LogEntry;
import org.squashtest.tm.service.importer.Target;
import org.squashtest.tm.service.infolist.InfoListItemFinderService;
import org.squashtest.tm.service.internal.batchimport.AbstractEntityFacilitySupport;
import org.squashtest.tm.service.internal.batchimport.Batch;
import org.squashtest.tm.service.internal.batchimport.Batches;
import org.squashtest.tm.service.internal.batchimport.CallStepParamsInfo;
import org.squashtest.tm.service.internal.batchimport.DatasetParametersValueImportData;
import org.squashtest.tm.service.internal.batchimport.Existence;
import org.squashtest.tm.service.internal.batchimport.FacilityImpl;
import org.squashtest.tm.service.internal.batchimport.FacilityImplHelper;
import org.squashtest.tm.service.internal.batchimport.FacilityUtils;
import org.squashtest.tm.service.internal.batchimport.LogTrain;
import org.squashtest.tm.service.internal.batchimport.ProjectTargetStatus;
import org.squashtest.tm.service.internal.batchimport.TargetStatus;
import org.squashtest.tm.service.internal.batchimport.instruction.ActionStepInstruction;
import org.squashtest.tm.service.internal.batchimport.instruction.CallStepInstruction;
import org.squashtest.tm.service.internal.batchimport.instruction.DatasetInstruction;
import org.squashtest.tm.service.internal.batchimport.instruction.DatasetParamValueInstruction;
import org.squashtest.tm.service.internal.batchimport.instruction.Instruction;
import org.squashtest.tm.service.internal.batchimport.instruction.ParameterInstruction;
import org.squashtest.tm.service.internal.batchimport.instruction.TestCaseInstruction;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.DatasetTarget;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.ParameterTarget;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.TestCaseTarget;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.TestStepTarget;
import org.squashtest.tm.service.internal.batchimport.testcase.TestCaseImportService;
import org.squashtest.tm.service.internal.batchimport.testcase.dto.ActionStepImportData;
import org.squashtest.tm.service.internal.batchimport.testcase.dto.CallStepImportData;
import org.squashtest.tm.service.internal.batchimport.testcase.dto.TestCaseFolderImportData;
import org.squashtest.tm.service.internal.batchimport.testcase.dto.TestCaseImportData;
import org.squashtest.tm.service.internal.batchimport.testcase.tree.FolderNode;
import org.squashtest.tm.service.internal.batchimport.testcase.tree.FolderTree;
import org.squashtest.tm.service.internal.batchimport.testcase.tree.MissingNode;
import org.squashtest.tm.service.internal.importer.ExcelRowReaderUtils;
import org.squashtest.tm.service.internal.library.LibraryUtils;
import org.squashtest.tm.service.internal.repository.DatasetDao;
import org.squashtest.tm.service.internal.repository.DatasetParamValueDao;
import org.squashtest.tm.service.internal.repository.ParameterDao;
import org.squashtest.tm.service.internal.repository.ProjectDao;
import org.squashtest.tm.service.testcase.CallStepManagerService;
import org.squashtest.tm.service.testcase.DatasetModificationService;
import org.squashtest.tm.service.testcase.ParameterModificationService;
import org.squashtest.tm.service.testcase.TestCaseLibraryNavigationService;
import org.squashtest.tm.service.testcase.TestCaseModificationService;

@Component
@Scope(value="prototype")
public class TestCaseFacility
extends AbstractEntityFacilitySupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(FacilityImpl.class);
    private final FacilityImplHelper helper = new FacilityImplHelper(this);
    @Inject
    private InfoListItemFinderService listItemFinderService;
    @Inject
    private TestCaseLibraryNavigationService navigationService;
    @Inject
    private TestCaseModificationService testcaseModificationService;
    @Inject
    private ProjectDao projectDao;
    @Inject
    private CallStepManagerService callstepService;
    @Inject
    private ParameterModificationService parameterService;
    @Inject
    private DatasetModificationService datasetService;
    @Inject
    private DatasetDao datasetDao;
    @Inject
    private DatasetParamValueDao paramvalueDao;
    @Inject
    private ParameterDao paramDao;
    @Inject
    private TestCaseImportService testCaseImportService;
    @PersistenceContext
    private EntityManager entityManager;

    public void createTestCases(List<TestCaseInstruction> instructions, Project project) {
        ArrayList<TestCaseImportData> testCaseInFolders = new ArrayList<TestCaseImportData>();
        Batch<TestCaseImportData> libraryTestCases = new Batch<TestCaseImportData>(project.getTestCaseLibrary().getId());
        for (TestCaseInstruction instr : instructions) {
            TestCaseImportData importTestCase = this.initTestCaseImportData(instr);
            TestCaseTarget target = (TestCaseTarget)instr.getTarget();
            if (target.isRootTestCase()) {
                libraryTestCases.addEntity(importTestCase);
                continue;
            }
            testCaseInFolders.add(importTestCase);
        }
        this.createTestCasesLinkToLibrary(project, libraryTestCases);
        this.createTestCasesLinkToFolders(project, testCaseInFolders);
    }

    private TestCaseImportData initTestCaseImportData(TestCaseInstruction instr) {
        TestCase testCase = instr.getTestCase();
        TestCaseTarget target = (TestCaseTarget)instr.getTarget();
        testCase.setName(PathUtils.unescapePathPartSlashes((String)target.getName()));
        Map<String, String> cufValues = instr.getCustomFields();
        this.helper.fillNullWithDefaults(testCase);
        this.helper.truncate(testCase, cufValues);
        Map<Long, RawValue> acceptableCufs = this.toAcceptableCufs(cufValues);
        List<Long> milestoneIds = this.boundMilestonesIds(instr);
        TestCaseImportData importTestCase = new TestCaseImportData(testCase, target);
        if (!acceptableCufs.isEmpty()) {
            importTestCase.setCustomFields(acceptableCufs);
        }
        if (!milestoneIds.isEmpty()) {
            importTestCase.setMilestoneIds(milestoneIds);
        }
        return importTestCase;
    }

    private void createTestCasesLinkToLibrary(Project project, Batch<TestCaseImportData> batch) {
        List<TestCaseImportData> importedTestCases = batch.getEntities();
        if (importedTestCases.isEmpty()) {
            return;
        }
        Long libraryId = batch.getTargetId();
        List<String> contentNames = this.navigationService.findContentNamesByLibraryId(libraryId);
        TestCaseFacility.fixConflictNames(contentNames, importedTestCases);
        this.testCaseImportService.addTestCasesToLibrary(libraryId, batch, project);
        importedTestCases.forEach(this::validatingTestCaseCreation);
    }

    private static void fixConflictNames(List<String> contentNames, List<TestCaseImportData> importData) {
        if (importData != null && !importData.isEmpty()) {
            importData.stream().map(TestCaseImportData::getTestCase).forEach(testCase -> {
                String newName = LibraryUtils.generateNonClashingName(testCase.getName(), contentNames, 255);
                if (!newName.equals(testCase.getName())) {
                    testCase.setName(newName);
                }
                contentNames.add(newName);
            });
        }
    }

    private void createTestCasesLinkToFolders(Project project, List<TestCaseImportData> folderTestCases) {
        Batches<TestCaseImportData> batches = this.collectExistingNodesAndCreateMissing(project.getName(), folderTestCases);
        if (batches == null) {
            return;
        }
        this.fixConflictNamesInFolders(batches);
        for (List<Batch<TestCaseImportData>> batchList : batches.partition(30)) {
            List<Long> currentFolderIds = batchList.stream().map(Batch::getTargetId).toList();
            this.testCaseImportService.addTestCasesToFolders(currentFolderIds, project, batchList);
            batchList.stream().flatMap(b -> b.getEntities().stream()).forEach(this::validatingTestCaseCreation);
        }
    }

    private void validatingTestCaseCreation(TestCaseImportData testCaseData) {
        this.validator.getModel().setExists(testCaseData.getTarget(), testCaseData.getTestCase().getId());
    }

    private void fixConflictNamesInFolders(Batches<TestCaseImportData> batches) {
        Map<Long, List<String>> folderContentNames = this.navigationService.findContentNamesByFolderIds(batches.getTargetIds());
        for (Map.Entry<Long, List<String>> entry : folderContentNames.entrySet()) {
            List<TestCaseImportData> importData = batches.getEntitiesByTargetId(entry.getKey());
            TestCaseFacility.fixConflictNames(entry.getValue(), importData);
        }
    }

    private Batches<TestCaseImportData> collectExistingNodesAndCreateMissing(String projectName, List<TestCaseImportData> folderTestCases) {
        Map<String, List<TestCaseImportData>> importDataByFolderPath = folderTestCases.stream().collect(Collectors.groupingBy(instruction -> instruction.getTarget().getFolder()));
        if (importDataByFolderPath.isEmpty()) {
            return null;
        }
        FolderTree tree = new FolderTree(projectName, importDataByFolderPath);
        TreeMap<String, Long> projectPathIdTree = this.navigationService.buildTestCasePathsTree(projectName);
        Long testCaseLibraryId = this.projectDao.findTestCaseLibraryIdByName(projectName);
        List<MissingNode> missingNodes = tree.collectMissingNodes(projectPathIdTree, testCaseLibraryId);
        this.createMissingNodes(testCaseLibraryId, missingNodes);
        return tree.collectExistingNodes(projectPathIdTree);
    }

    private void createMissingNodes(Long testCaseLibraryId, List<MissingNode> missingNodes) {
        if (missingNodes.isEmpty()) {
            return;
        }
        Batch<TestCaseFolderImportData> libraryFolders = new Batch<TestCaseFolderImportData>(testCaseLibraryId);
        Batches<TestCaseFolderImportData> folderBatch = new Batches<TestCaseFolderImportData>();
        for (MissingNode missingNode : missingNodes) {
            FolderNode node = missingNode.node();
            TestCaseFolderImportData folderImportData = new TestCaseFolderImportData(node.convertToSquashFolder(), node.collectAllTestCaseImportData());
            if (missingNode.isLibraryContent()) {
                libraryFolders.addEntity(folderImportData);
                continue;
            }
            folderBatch.addBatch(missingNode.parentId(), folderImportData);
        }
        if (!libraryFolders.getEntities().isEmpty()) {
            this.testCaseImportService.addFoldersToLibrary(testCaseLibraryId, libraryFolders);
            libraryFolders.getEntities().stream().flatMap(b -> b.testCaseDataInNodes().stream()).forEach(this::validatingTestCaseCreation);
        }
        for (List<Batch<TestCaseFolderImportData>> list : folderBatch.partition(20)) {
            List<Long> targetIds = list.stream().map(Batch::getTargetId).toList();
            this.testCaseImportService.addFoldersToFolders(targetIds, list);
            list.stream().flatMap(b -> b.getEntities().stream()).flatMap(b -> b.testCaseDataInNodes().stream()).forEach(this::validatingTestCaseCreation);
        }
    }

    private void createTCRoutine(LogTrain train, TestCaseInstruction instruction) {
        TestCase testCase = instruction.getTestCase();
        TestCaseTarget target = (TestCaseTarget)instruction.getTarget();
        try {
            Project project = this.projectDao.findByName(target.getProject());
            this.createTestCases(Collections.singletonList(instruction), project);
            this.validator.getModel().setExists(target, testCase.getId());
            LOGGER.debug("Excel import : Created Test Case \t'" + String.valueOf(target) + "'", new Object[0]);
        }
        catch (Exception ex) {
            train.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.unexpectederror", ex.getClass().getName()).build());
            this.validator.getModel().setNotExists(target);
            LOGGER.error("Excel import : unexpected error while importing " + String.valueOf(target) + " : ", (Throwable)ex);
        }
    }

    private void fixNatureAndType(TestCaseTarget target, TestCase testCase) {
        InfoListItem type;
        ProjectTargetStatus projectStatus = this.validator.getModel().getProjectStatus(target.getProject());
        InfoListItem nature = testCase.getNature();
        if (nature != null && !this.listItemFinderService.isNatureConsistent(projectStatus.getId(), nature.getCode())) {
            testCase.setNature(this.listItemFinderService.findDefaultTestCaseNature(projectStatus.getId()));
        }
        if ((type = testCase.getType()) != null && !this.listItemFinderService.isTypeConsistent(projectStatus.getId(), type.getCode())) {
            testCase.setType(this.listItemFinderService.findDefaultTestCaseType(projectStatus.getId()));
        }
    }

    private void rebindMilestones(TestCaseInstruction instr, TestCase persistentSource) {
        if (!instr.getMilestones().isEmpty()) {
            List<Milestone> ms = this.milestoneHelper.findBindable(instr.getMilestones());
            persistentSource.getMilestones().clear();
            persistentSource.bindAllMilsetones(ms);
        } else {
            persistentSource.getMilestones().clear();
        }
    }

    public LogTrain updateTestCase(TestCaseInstruction instr) {
        TestCaseTarget target = (TestCaseTarget)instr.getTarget();
        TestCase testCase = instr.getTestCase();
        Map<String, String> cufValues = instr.getCustomFields();
        TargetStatus status = this.validator.getModel().getStatus(target);
        LogTrain train = this.validator.updateTestCase(instr);
        if (train.hasCriticalErrors()) {
            return train;
        }
        if (status.getStatus() == Existence.NOT_EXISTS) {
            this.createTCRoutine(train, instr);
        } else {
            try {
                this.helper.truncate(testCase, cufValues);
                this.fixNatureAndType(target, testCase);
                this.doUpdateTestcase(instr);
                LOGGER.debug("Excel import : Updated Test Case \t'" + String.valueOf(target) + "'", new Object[0]);
            }
            catch (Exception ex) {
                train.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.unexpectederror", ex.getClass().getName()).build());
                LOGGER.error("Excel import : unexpected error while updating " + String.valueOf(target) + " : ", (Throwable)ex);
            }
        }
        return train;
    }

    private void doUpdateTestcase(TestCaseInstruction instr) {
        TestCaseTarget target = (TestCaseTarget)instr.getTarget();
        TestCase testCase = instr.getTestCase();
        Map<String, String> cufValues = instr.getCustomFields();
        TestCase orig = this.validator.getModel().get(target);
        Long origId = orig.getId();
        this.doUpdateCustomFields(cufValues, (BoundEntity)orig);
        if (this.validator.areMilestoneValid(instr)) {
            this.rebindMilestones(instr, orig);
        }
        this.doUpdateTestCaseCoreAttributes(testCase, orig);
        this.doUpdateTestCaseScriptIfScripted(testCase, orig);
        Integer order = target.getOrder();
        if (order != null && order > -1 && order < this.navigationService.countSiblingsOfNode(origId)) {
            Long[] origIds = new Long[]{origId};
            ClipboardPayload clipboardPayload = ClipboardPayload.withWhiteListIgnored(Collections.singletonList(origId));
            if (target.isRootTestCase()) {
                Long libraryId = this.validator.getModel().getProjectStatus(target.getProject()).getTestCaseLibraryId();
                this.navigationService.moveNodesToLibrary(libraryId, origIds, order, clipboardPayload);
            } else {
                Long folderId = this.navigationService.findNodeIdByPath(target.getFolder());
                this.navigationService.moveNodesToFolder(folderId, origIds, order, clipboardPayload);
            }
        }
    }

    private void doUpdateTestCaseScriptIfScripted(TestCase testCase, TestCase orig) {
        String newScript;
        boolean isTestCaseScripted = this.isTestCaseScripted(testCase);
        boolean isOrigScripted = this.isTestCaseScripted(orig);
        if (isTestCaseScripted && isOrigScripted && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{newScript = ((ScriptedTestCase)testCase).getScript()})) {
            ((ScriptedTestCase)orig).setScript(newScript);
        }
    }

    private boolean isTestCaseScripted(TestCase testCase) {
        IsScriptedTestCaseVisitor testCaseVisitor = new IsScriptedTestCaseVisitor();
        testCase.accept((TestCaseVisitor)testCaseVisitor);
        return testCaseVisitor.isScripted();
    }

    private void doUpdateTestCaseCoreAttributes(TestCase testCase, TestCase orig) {
        boolean importanceChanged;
        Long origId = orig.getId();
        boolean newImportanceAuto = testCase.isImportanceAuto() != null && testCase.isImportanceAuto() != false;
        this.updateName(orig, testCase.getName(), origId);
        this.updateReference(orig, testCase.getReference(), origId);
        this.updateDescription(orig, testCase.getDescription(), origId);
        this.updatePrerequisite(orig, testCase.getPrerequisite(), origId);
        this.updateImportance(testCase, orig, newImportanceAuto, origId);
        this.updateInfoListNature(orig, testCase.getNature(), origId);
        this.updateInfoListType(orig, testCase.getType(), origId);
        this.updateStatus(orig, testCase.getStatus(), origId);
        boolean bl = importanceChanged = orig.isImportanceAuto() != null && orig.isImportanceAuto().equals(newImportanceAuto);
        if (importanceChanged || newImportanceAuto) {
            this.testcaseModificationService.changeImportanceAuto(origId, newImportanceAuto);
        }
    }

    private void updateStatus(TestCase orig, TestCaseStatus newStatus, Long origId) {
        if (newStatus != null && orig.getStatus() != newStatus) {
            this.testcaseModificationService.changeStatus(origId, newStatus);
        }
    }

    private void updateName(TestCase orig, String newName, Long origId) {
        if (!StringUtils.isBlank((CharSequence)newName) && !newName.equals(orig.getName())) {
            this.testcaseModificationService.rename(origId, newName);
        }
    }

    private void updateReference(TestCase orig, String newRef, Long origId) {
        if (!StringUtils.isBlank((CharSequence)newRef) && !newRef.equals(orig.getReference())) {
            this.testcaseModificationService.changeReference(origId, newRef);
        }
    }

    private void updateDescription(TestCase orig, String newDesc, Long origId) {
        if (!StringUtils.isBlank((CharSequence)newDesc) && !newDesc.equals(orig.getDescription())) {
            this.testcaseModificationService.changeDescription(origId, ExcelRowReaderUtils.escapeHTMLInsideTags(newDesc));
        }
    }

    private void updatePrerequisite(TestCase orig, String newPrereq, Long origId) {
        if (!StringUtils.isBlank((CharSequence)newPrereq) && !newPrereq.equals(orig.getPrerequisite())) {
            this.testcaseModificationService.changePrerequisite(origId, ExcelRowReaderUtils.escapeHTMLInsideTags(newPrereq));
        }
    }

    private void updateImportance(TestCase testCase, TestCase orig, boolean newImportanceAuto, Long origId) {
        TestCaseImportance newImp = testCase.getImportance();
        if (!newImportanceAuto && newImp != null && orig.getImportance() != newImp) {
            this.testcaseModificationService.changeImportance(origId, newImp);
        }
    }

    private void updateInfoListNature(TestCase orig, InfoListItem newNat, Long origId) {
        if (newNat != null && !newNat.references((Object)orig.getNature())) {
            this.testcaseModificationService.changeNature((long)origId, newNat.getCode());
        }
    }

    private void updateInfoListType(TestCase orig, InfoListItem newType, Long origId) {
        if (newType != null && !newType.references((Object)orig.getType())) {
            this.testcaseModificationService.changeType((long)origId, newType.getCode());
        }
    }

    public LogTrain deleteTestCase(TestCaseTarget target) {
        LogTrain train = this.validator.deleteTestCase(target);
        if (train.hasCriticalErrors()) {
            return train;
        }
        try {
            this.doDeleteTestCase(target);
            this.validator.getModel().setDeleted(target);
            LOGGER.debug("Excel import : Deleted Test Case \t'" + String.valueOf(target) + "'", new Object[0]);
        }
        catch (Exception ex) {
            train.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.unexpectederror", ex.getClass().getName()).build());
            LOGGER.error("Excel import : unexpected error while deleting " + String.valueOf(target) + " : ", (Throwable)ex);
        }
        return train;
    }

    private void doDeleteTestCase(TestCaseTarget target) {
        TestCase tc = this.validator.getModel().get(target);
        this.navigationService.deleteNodes(Collections.singletonList(tc.getId()));
    }

    public LogTrain updateActionStep(TestStepTarget target, ActionTestStep testStep, Map<String, String> cufValues) {
        LogTrain train = this.validator.updateActionStep(target, testStep, cufValues);
        if (train.hasCriticalErrors()) {
            return train;
        }
        try {
            this.helper.truncate(cufValues);
            this.doUpdateActionStep(target, testStep, cufValues);
            LOGGER.debug("Excel import : Updated Action Step \t'" + String.valueOf(target) + "'", new Object[0]);
        }
        catch (Exception ex) {
            train.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.unexpectederror", ex.getClass().getName()).build());
            LOGGER.error("Excel import : unexpected error while updating step " + String.valueOf(target) + " : ", (Throwable)ex);
        }
        return train;
    }

    private void doUpdateActionStep(TestStepTarget target, ActionTestStep testStep, Map<String, String> cufValues) {
        String newResult;
        ActionTestStep orig = (ActionTestStep)this.validator.getModel().getStep(target);
        String newAction = testStep.getAction();
        if (!StringUtils.isBlank((CharSequence)newAction) && !newAction.equals(orig.getAction())) {
            orig.setAction(ExcelRowReaderUtils.escapeHTMLInsideTags(newAction));
        }
        if (!StringUtils.isBlank((CharSequence)(newResult = testStep.getExpectedResult())) && !newResult.equals(orig.getExpectedResult())) {
            orig.setExpectedResult(ExcelRowReaderUtils.escapeHTMLInsideTags(newResult));
        }
        this.doUpdateCustomFields(cufValues, (BoundEntity)orig);
    }

    public LogTrain updateCallStep(TestStepTarget target, CallTestStep testStep, TestCaseTarget calledTestCase, CallStepParamsInfo paramInfo, ActionTestStep actionStepBackup) {
        LogTrain train = this.validator.updateCallStep(target, testStep, calledTestCase, paramInfo, actionStepBackup);
        if (train.hasCriticalErrors()) {
            return train;
        }
        try {
            this.doUpdateCallStep(target, calledTestCase, paramInfo);
            this.validator.getModel().updateCallStepTarget(target, calledTestCase, paramInfo);
            LOGGER.debug("Excel import : Created Call Step \t'" + String.valueOf(target) + "' -> '" + String.valueOf(calledTestCase) + "'", new Object[0]);
        }
        catch (Exception ex) {
            train.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.unexpectederror", ex.getClass().getName()).build());
            LOGGER.error("Excel import : unexpected error while updating step " + String.valueOf(target) + " : ", (Throwable)ex);
        }
        return train;
    }

    private void doUpdateCallStep(TestStepTarget target, TestCaseTarget calledTestCase, CallStepParamsInfo paramInfo) {
        TestStep actualStep = this.validator.getModel().getStep(target);
        TestCase newCalled = this.validator.getModel().get(calledTestCase);
        this.callstepService.checkForCyclicStepCallBeforePaste(actualStep.getTestCase().getId(), newCalled.getId());
        ((CallTestStep)actualStep).setCalledTestCase(newCalled);
        this.changeParameterAssignation(actualStep.getId(), calledTestCase, paramInfo);
    }

    private void changeParameterAssignation(Long stepId, TestCaseTarget tc, CallStepParamsInfo paramInfo) {
        Long dsId = null;
        ParameterAssignationMode mode = paramInfo.getParamMode();
        if (paramInfo.getParamMode() == ParameterAssignationMode.CALLED_DATASET) {
            String dsname;
            Long tcid = this.validator.getModel().getId(tc);
            Dataset ds = this.datasetDao.findByTestCaseIdAndName(tcid, dsname = this.helper.truncate(paramInfo.getCalledDatasetName()));
            if (ds != null) {
                dsId = ds.getId();
            } else {
                mode = ParameterAssignationMode.NOTHING;
            }
        }
        this.callstepService.setParameterAssignationMode(stepId, mode, dsId);
    }

    public LogTrain deleteTestStep(TestStepTarget target) {
        LogTrain train = this.validator.deleteTestStep(target);
        if (train.hasCriticalErrors()) {
            return train;
        }
        try {
            this.doDeleteTestStep(target);
            this.validator.getModel().remove(target);
            LOGGER.debug("Excel import : Deleted Step \t'" + String.valueOf(target) + "'", new Object[0]);
        }
        catch (Exception ex) {
            train.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.unexpectederror", ex.getClass().getName()).build());
            LOGGER.error("Excel import : unexpected error while deleting step " + String.valueOf(target) + " : ", (Throwable)ex);
        }
        return train;
    }

    private void doDeleteTestStep(TestStepTarget target) {
        TestCase tc = this.validator.getModel().get(target.getTestCase());
        this.testcaseModificationService.removeStepFromTestCaseByIndex(tc.getId(), target.getIndex());
    }

    public LogTrain updateParameter(ParameterTarget target, Parameter param) {
        LogTrain train = this.validator.updateParameter(target, param);
        if (train.hasCriticalErrors()) {
            return train;
        }
        try {
            this.doUpdateParameter(target, param);
            this.validator.getModel().addParameter(target);
            LOGGER.debug("Excel import : Updated Parameter \t'" + String.valueOf(target) + "'", new Object[0]);
        }
        catch (Exception ex) {
            train.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.unexpectederror", ex.getClass().getName()).build());
            LOGGER.error("Excel import : unexpected error while updating parameter " + String.valueOf(target) + " : ", (Throwable)ex);
        }
        return train;
    }

    private void doUpdateParameter(ParameterTarget target, Parameter param) {
        if (!this.validator.getModel().doesParameterExists(target)) {
            Long testcaseId = this.validator.getModel().getId(target.getOwner());
            this.helper.fillNullWithDefaults(param);
            this.helper.truncate(param);
            this.parameterService.addNewParameterToTestCase(param, testcaseId);
        } else {
            String description = param.getDescription();
            if (description != null) {
                this.findParameter(target).setDescription(description);
            }
        }
    }

    public LogTrain deleteParameter(ParameterTarget target) {
        LogTrain train = this.validator.deleteParameter(target);
        if (train.hasCriticalErrors()) {
            return train;
        }
        try {
            this.doDeleteParameter(target);
            this.validator.getModel().removeParameter(target);
            LOGGER.debug("Excel import : Deleted Parameter \t'" + String.valueOf(target) + "'", new Object[0]);
        }
        catch (Exception ex) {
            train.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.unexpectederror", ex.getClass().getName()).build());
            LOGGER.error("Excel import : unexpected error while deleting parameter " + String.valueOf(target) + " : ", (Throwable)ex);
        }
        return train;
    }

    private void doDeleteParameter(ParameterTarget target) {
        Long testcaseId = this.validator.getModel().getId(target.getOwner());
        List<Parameter> allparams = this.parameterService.findAllParameters(testcaseId);
        Parameter param = null;
        for (Parameter p : allparams) {
            if (!p.getName().equals(target.getName())) continue;
            param = p;
            break;
        }
        this.parameterService.remove(param);
    }

    public LogTrain failsafeUpdateParameterValue(DatasetTarget dataset, ParameterTarget param, String value, boolean isUpdate) {
        LogTrain train = this.validator.failsafeUpdateParameterValue(dataset, param, value, isUpdate);
        if (train.hasCriticalErrors()) {
            return train;
        }
        try {
            this.doFailsafeUpdateParameterValue(dataset, param, value);
            this.validator.getModel().addDataset(dataset);
            LOGGER.debug("Excel import : Updated Param Value for param \t'" + String.valueOf(param) + "' in dataset '" + String.valueOf(dataset) + "'", new Object[0]);
        }
        catch (Exception ex) {
            train.addEntry(LogEntry.failure().forTarget(dataset).withMessage("message.import.log.error.unexpectederror", ex.getClass().getName()).build());
            LOGGER.error("Excel import : unexpected error while setting parameter " + String.valueOf(param) + " in dataset " + String.valueOf(dataset) + " : ", (Throwable)ex);
        }
        return train;
    }

    private void doFailsafeUpdateParameterValue(DatasetTarget dataset, ParameterTarget param, String value) {
        DatasetParamValue dpv = this.findParamValue(dataset, param);
        String trValue = this.helper.truncate(value);
        dpv.setParamValue(trValue);
    }

    private DatasetParamValue findParamValue(DatasetTarget dataset, ParameterTarget param) {
        DatasetParamValue dpv2;
        Dataset dbDs = this.findOrCreateDataset(dataset);
        Parameter dsParam = this.findParameter(param);
        for (DatasetParamValue dpv2 : dbDs.getParameterValues()) {
            if (!dpv2.getParameter().equals(dsParam)) continue;
            return dpv2;
        }
        dpv2 = new DatasetParamValue(dsParam, dbDs);
        this.paramvalueDao.save(dpv2);
        dbDs.addParameterValue(dpv2);
        return dpv2;
    }

    private Parameter findParameter(ParameterTarget param) {
        Long testcaseId = this.validator.getModel().getId(param.getOwner());
        Parameter found = this.paramDao.findOwnParameterByNameAndTestCase(param.getName(), testcaseId);
        if (found != null) {
            return found;
        }
        throw new NoSuchElementException("parameter " + String.valueOf(param) + " could not be found");
    }

    public LogTrain deleteDataset(DatasetTarget dataset) {
        LogTrain train = this.validator.deleteDataset(dataset);
        if (train.hasCriticalErrors()) {
            return train;
        }
        try {
            this.doDeleteDataset(dataset);
            this.validator.getModel().removeDataset(dataset);
            LOGGER.debug("Excel import : Deleted Dataset '" + String.valueOf(dataset) + "'", new Object[0]);
        }
        catch (Exception ex) {
            train.addEntry(LogEntry.failure().forTarget(dataset).withMessage("message.import.log.error.unexpectederror", ex.getClass().getName()).build());
            LOGGER.error("Excel import : unexpected error while deleting dataset " + String.valueOf(dataset) + " : ", (Throwable)ex);
        }
        return train;
    }

    private void doDeleteDataset(DatasetTarget dataset) {
        Dataset ds = this.findOrCreateDataset(dataset);
        TestCase tc = ds.getTestCase();
        tc.removeDataset(ds);
        this.datasetService.remove(ds);
    }

    private Dataset findOrCreateDataset(DatasetTarget dataset) {
        String truncated;
        Long tcid = this.validator.getModel().getId(dataset.getTestCase());
        Dataset found = this.datasetDao.findByTestCaseIdAndName(tcid, truncated = this.helper.truncate(dataset.getName()));
        if (found != null) {
            return found;
        }
        Dataset newds = new Dataset();
        newds.setName(dataset.getName());
        this.helper.fillNullWithDefaults(newds);
        this.helper.truncate(newds);
        this.datasetService.persist(newds, tcid);
        LOGGER.debug("Excel import : Created Dataset \t'" + String.valueOf(dataset) + "'", new Object[0]);
        return newds;
    }

    public void createParameters(List<ParameterInstruction> instructions) {
        Batches<Parameter> batchToCreate = new Batches<Parameter>();
        Batches<ParameterInstruction> batchToUpdate = new Batches<ParameterInstruction>();
        instructions.forEach(instr -> {
            Parameter parameter = instr.getParameter();
            ParameterTarget target = (ParameterTarget)instr.getTarget();
            Long testcaseId = this.validator.getModel().getId(target.getOwner());
            if (this.validator.getModel().doesParameterExists(target)) {
                batchToUpdate.addBatch(testcaseId, (ParameterInstruction)instr);
            } else {
                this.helper.fillNullWithDefaults(parameter);
                this.helper.truncate(parameter);
                batchToCreate.addBatch(testcaseId, parameter);
            }
        });
        this.addMissingParameters(batchToCreate);
        this.updateExistingParameters(batchToUpdate);
        instructions.forEach(instruction -> {
            this.validator.getModel().addParameter((ParameterTarget)instruction.getTarget());
            LOGGER.debug("Excel import : Created Parameter \t'" + String.valueOf(instruction.getTarget()) + "'", new Object[0]);
        });
    }

    private void addMissingParameters(Batches<Parameter> batch) {
        if (batch.isEmpty()) {
            return;
        }
        for (List<Batch<Parameter>> batchList : batch.partition(30)) {
            this.parameterService.batchParameterAddition(batchList);
        }
    }

    private void updateExistingParameters(Batches<ParameterInstruction> batch) {
        if (batch.isEmpty()) {
            return;
        }
        for (List<Batch<ParameterInstruction>> batchList : batch.partition(20)) {
            this.parameterService.updateImportParameters(batchList);
        }
    }

    public void createDatasets(List<DatasetInstruction> instructions) {
        Map<Long, List<DatasetTarget>> targetsByTestCaseIds = instructions.stream().map(Instruction::getTarget).collect(Collectors.groupingBy(target -> this.validator.getModel().getId(target.getTestCase()), Collectors.toList()));
        Map datasetsNamesByTestCaseId = this.datasetDao.findOwnDatasetNamesByTestCaseIds(targetsByTestCaseIds.keySet());
        Batches<Dataset> batch = this.collectMissingDatasets(targetsByTestCaseIds, datasetsNamesByTestCaseId);
        for (List<Batch<Dataset>> batchList : batch.partition(20)) {
            List<Long> testCaseIds = batchList.stream().map(Batch::getTargetId).toList();
            this.datasetService.persistBatch(testCaseIds, batchList);
        }
    }

    protected void addUnexpectedError(LogTrain train, Target target, Throwable ex) {
        train.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.unexpectederror", ex.getClass().getName()).build());
    }

    private Batches<Dataset> collectMissingDatasets(Map<Long, List<DatasetTarget>> targetsByTestCaseIds, Map<Long, List<String>> datasetsNamesByTestCaseId) {
        Batches<Dataset> batch = new Batches<Dataset>();
        for (Map.Entry<Long, List<DatasetTarget>> entry : targetsByTestCaseIds.entrySet()) {
            List<DatasetTarget> targets = entry.getValue();
            Long testCaseId = entry.getKey();
            ArrayList<String> collectDatasetNames = new ArrayList<String>();
            List existingDatasets = datasetsNamesByTestCaseId.getOrDefault(testCaseId, Collections.emptyList());
            for (DatasetTarget datasetTarget : targets) {
                String truncatedName = this.helper.truncate(datasetTarget.getName());
                if (existingDatasets.contains(truncatedName) || collectDatasetNames.contains(truncatedName)) continue;
                Dataset dataset = new Dataset();
                dataset.setName(datasetTarget.getName());
                this.helper.fillNullWithDefaults(dataset);
                this.helper.truncate(dataset);
                batch.addBatch(testCaseId, dataset);
                collectDatasetNames.add(truncatedName);
            }
        }
        return batch;
    }

    public void addActionSteps(List<ActionStepInstruction> instructions, Project project) {
        Batches<ActionStepImportData> batches = this.batchGroupingActionSteps(instructions);
        this.createBatchActionTestSteps(project, batches);
    }

    private void createBatchActionTestSteps(Project project, Batches<ActionStepImportData> batches) {
        if (batches.isEmpty()) {
            return;
        }
        for (List<Batch<ActionStepImportData>> batchList : batches.partition(30)) {
            List<Long> testCaseIds = batchList.stream().map(Batch::getTargetId).toList();
            this.testcaseModificationService.addImportActionSteps(project, testCaseIds, batchList);
            batchList.stream().flatMap(b -> b.getEntities().stream()).map(ActionStepImportData::getTarget).forEach(target -> this.validator.getModel().addActionStep((TestStepTarget)target));
        }
    }

    private Batches<ActionStepImportData> batchGroupingActionSteps(List<ActionStepInstruction> instructions) {
        Batches<ActionStepImportData> batches = new Batches<ActionStepImportData>();
        for (ActionStepInstruction instruction : instructions) {
            ActionTestStep testStep = instruction.getTestStep();
            this.helper.fillNullWithDefaults(testStep);
            Map<String, String> customFields = instruction.getCustomFields();
            this.helper.truncate(customFields);
            Map<Long, RawValue> acceptableCustomFields = this.toAcceptableCufs(customFields);
            TestStepTarget target = (TestStepTarget)instruction.getTarget();
            Long testCaseId = this.validator.getModel().getId(target.getTestCase());
            ActionStepImportData testStepImportData = new ActionStepImportData(testStep, target, target.getIndex());
            testStepImportData.addCustomFields(acceptableCustomFields);
            batches.addBatch(testCaseId, testStepImportData);
        }
        return batches;
    }

    public void addCallSteps(List<CallStepInstruction> instructions, Project project) {
        this.validator.addCallSteps(instructions, project);
        Batches<ActionStepImportData> batchesActionStep = new Batches<ActionStepImportData>();
        Batches<CallStepImportData> batchesCallStep = new Batches<CallStepImportData>();
        instructions.stream().filter(i -> !i.hasCriticalErrors()).forEach(i -> this.callStepInstructionDistribution((CallStepInstruction)i, batchesActionStep, batchesCallStep));
        try {
            this.createBatchActionTestSteps(project, batchesActionStep);
            this.createBatchCallTestSteps(project, batchesCallStep);
        }
        catch (Exception ex) {
            instructions.stream().filter(i -> !i.hasCriticalErrors()).forEach(i -> i.addLogEntry(ImportStatus.FAILURE, "message.import.log.error.unexpectederror", null, ex.getClass().getName()));
            LOGGER.error("Excel import : unexpected error occurred when creating {} in project : {}", new Object[]{"call steps", project.getName(), ex});
        }
    }

    private void createBatchCallTestSteps(Project project, Batches<CallStepImportData> batches) {
        if (batches.isEmpty()) {
            return;
        }
        for (List<Batch<CallStepImportData>> batchList : batches.partition(30)) {
            List<Long> testCaseIds = batchList.stream().map(Batch::getTargetId).toList();
            this.callstepService.addImportCallSteps(project, testCaseIds, batchList);
            batchList.stream().flatMap(b -> b.getEntities().stream()).forEach(data -> {
                Integer n = this.validator.getModel().addCallStep(data.getTarget(), data.getCalledTestCaseTarget(), data.getParameterMode());
            });
        }
    }

    private void callStepInstructionDistribution(CallStepInstruction instruction, Batches<ActionStepImportData> actionStepBatches, Batches<CallStepImportData> callBatches) {
        TestStepTarget target = (TestStepTarget)instruction.getTarget();
        Long testCaseId = this.validator.getModel().getId(target.getTestCase());
        String mustImportCallAsActionStepErrorI18n = FacilityUtils.mustImportCallAsActionStep(instruction.getLogTrain());
        if (mustImportCallAsActionStepErrorI18n != null) {
            ActionTestStep testStep = instruction.getActionStepBackup();
            this.helper.fillNullWithDefaults(testStep);
            ActionStepImportData testStepImportData = new ActionStepImportData(testStep, target, target.getIndex());
            actionStepBatches.addBatch(testCaseId, testStepImportData);
        } else {
            Long calledTestCaseId = this.validator.getModel().getId(instruction.getCalledTC());
            CallStepParamsInfo paramsInfo = instruction.getDatasetInfo();
            CallStepImportData callStepImportData = new CallStepImportData(calledTestCaseId, instruction.getCalledTC(), paramsInfo.getParamMode(), this.helper.truncate(paramsInfo.getCalledDatasetName()), target);
            callBatches.addBatch(testCaseId, callStepImportData);
        }
    }

    public void addDatasetParametersValues(List<DatasetParamValueInstruction> instructions) {
        Map<DatasetTarget, List<DatasetParamValueInstruction>> instructionsByDataset = instructions.stream().collect(Collectors.groupingBy(Instruction::getTarget, Collectors.toList()));
        Batches<DatasetParametersValueImportData> batches = this.collectBatchDatasetParameterValues(instructionsByDataset);
        for (List<Batch<DatasetParametersValueImportData>> batchList : batches.partition(30)) {
            List<Long> testCaseIds = batchList.stream().map(Batch::getTargetId).toList();
            Batches<Dataset> datasetsToCreate = this.batchDatasetParametersValuesAddition(batchList, testCaseIds);
            for (List<Batch<Dataset>> datasetBatchList : datasetsToCreate.partition(30)) {
                List<Long> testCaseDatasetIds = batchList.stream().map(Batch::getTargetId).toList();
                this.datasetService.persistBatch(testCaseDatasetIds, datasetBatchList);
            }
            this.entityManager.flush();
            this.entityManager.clear();
        }
    }

    private Batches<DatasetParametersValueImportData> collectBatchDatasetParameterValues(Map<DatasetTarget, List<DatasetParamValueInstruction>> instructionsByDataset) {
        Batches<DatasetParametersValueImportData> batches = new Batches<DatasetParametersValueImportData>();
        for (Map.Entry<DatasetTarget, List<DatasetParamValueInstruction>> entry : instructionsByDataset.entrySet()) {
            DatasetTarget target = entry.getKey();
            Long testCaseId = this.validator.getModel().getId(target.getTestCase());
            DatasetParametersValueImportData data = new DatasetParametersValueImportData(target.getName());
            for (DatasetParamValueInstruction instruction : entry.getValue()) {
                data.addParameterTargetValue(instruction.getParameterTarget().getName(), this.helper.truncate(instruction.getDatasetValue().getValue()));
            }
            batches.addBatch(testCaseId, data);
        }
        return batches;
    }

    private Batches<Dataset> batchDatasetParametersValuesAddition(List<Batch<DatasetParametersValueImportData>> batchList, List<Long> testCaseIds) {
        Map parametersByTestCaseId = this.paramDao.findParametersByTestCaseIds(testCaseIds);
        Map datasetsByTestCaseId = this.datasetDao.findOwnDatasetsByTestCaseIds(testCaseIds);
        Batches<Dataset> datasetsToCreate = new Batches<Dataset>();
        for (Batch<DatasetParametersValueImportData> batch : batchList) {
            Map datasetNames = datasetsByTestCaseId.getOrDefault(batch.getTargetId(), Collections.emptyList()).stream().collect(Collectors.toMap(Dataset::getName, Function.identity()));
            Map<String, Parameter> parameterByName = parametersByTestCaseId.getOrDefault(batch.getTargetId(), Collections.emptyList()).stream().collect(Collectors.toMap(Parameter::getName, Function.identity()));
            for (DatasetParametersValueImportData parameterData : batch.getEntities()) {
                String datasetName = parameterData.getDataset();
                Dataset dataset = (Dataset)datasetNames.get(parameterData.getDataset());
                if (dataset == null) {
                    dataset = this.createNewDataset(datasetName, parameterData, parameterByName);
                    datasetsToCreate.addBatch(batch.getTargetId(), dataset);
                    continue;
                }
                this.updateExistingDataset(dataset, parameterData, parameterByName);
            }
        }
        return datasetsToCreate;
    }

    private void updateExistingDataset(Dataset dataset, DatasetParametersValueImportData parameterData, Map<String, Parameter> parameterByName) {
        parameterData.getValuesParameters().forEach((parameterName, value) -> {
            Parameter parameter = (Parameter)parameterByName.get(parameterName);
            TestCaseFacility.checkNotNullParameter(parameterName, parameter);
            DatasetParamValue dpv = this.retrieveParameter(dataset, parameter);
            if (dpv == null) {
                dpv = new DatasetParamValue(parameter, dataset);
                this.paramvalueDao.save(dpv);
                dataset.addParameterValue(dpv);
            }
            dpv.setParamValue(value);
        });
    }

    private static void checkNotNullParameter(String parameterName, Parameter parameter) {
        if (parameter == null) {
            throw new NoSuchElementException("Parameter " + parameterName + " could not be found");
        }
    }

    private Dataset createNewDataset(String datasetName, DatasetParametersValueImportData parameterData, Map<String, Parameter> parameterByName) {
        Dataset dataset = new Dataset();
        dataset.setName(datasetName);
        this.helper.fillNullWithDefaults(dataset);
        this.helper.truncate(dataset);
        parameterData.getValuesParameters().forEach((parameterName, value) -> {
            Parameter parameter = (Parameter)parameterByName.get(parameterName);
            TestCaseFacility.checkNotNullParameter(parameterName, parameter);
            DatasetParamValue dpv = new DatasetParamValue(parameter, dataset);
            dataset.addParameterValue(dpv);
            dpv.setParamValue(value);
        });
        return dataset;
    }

    private DatasetParamValue retrieveParameter(Dataset dataset, Parameter parameter) {
        for (DatasetParamValue dpv : dataset.getParameterValues()) {
            if (!dpv.getParameter().equals(parameter)) continue;
            return dpv;
        }
        return null;
    }
}

