/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testautomation;

import jakarta.validation.constraints.NotNull;
import java.net.URL;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.api.testautomation.execution.dto.TestExecutionStatus;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.core.foundation.exception.InvalidUrlException;
import org.squashtest.tm.core.foundation.lang.UrlUtils;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender;
import org.squashtest.tm.service.campaign.AutomatedSuiteModificationService;
import org.squashtest.tm.service.campaign.CustomTestSuiteModificationService;
import org.squashtest.tm.service.execution.ExecutionProcessingService;
import org.squashtest.tm.service.internal.repository.AutomatedExecutionExtenderDao;
import org.squashtest.tm.service.internal.repository.CustomAutomatedExecExtenderDao;
import org.squashtest.tm.service.testautomation.AutomatedExecutionManagerService;

@Service(value="squashtest.tm.service.testautomation.AutomatedExecutionManagerService")
@Transactional
public class AutomatedExecutionManagerServiceImpl
implements AutomatedExecutionManagerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutomatedExecutionManagerServiceImpl.class);
    private final AutomatedExecutionExtenderDao automatedExecutionDao;
    private final ExecutionProcessingService execProcService;
    private final CustomTestSuiteModificationService customTestSuiteModificationService;
    private final AutomatedSuiteModificationService automatedSuiteModificationService;
    private final CustomAutomatedExecExtenderDao customAutomatedExecExtenderDao;

    public AutomatedExecutionManagerServiceImpl(AutomatedExecutionExtenderDao automatedExecutionDao, ExecutionProcessingService execProcService, CustomTestSuiteModificationService customTestSuiteModificationService, AutomatedSuiteModificationService automatedSuiteModificationService, CustomAutomatedExecExtenderDao customAutomatedExecExtenderDao) {
        this.automatedExecutionDao = automatedExecutionDao;
        this.execProcService = execProcService;
        this.customTestSuiteModificationService = customTestSuiteModificationService;
        this.automatedSuiteModificationService = automatedSuiteModificationService;
        this.customAutomatedExecExtenderDao = customAutomatedExecExtenderDao;
    }

    private void changeState(AutomatedExecutionExtender exec, TestExecutionStatus stateChange) {
        exec.setDuration(stateChange.getDuration());
        exec.setResultSummary(HtmlUtils.htmlEscape((String)stateChange.getStatusMessage()));
        exec.setExecutionStatus(this.coerce(stateChange.getStatus()));
        this.automatedSuiteModificationService.updateExecutionStatus(exec.getAutomatedSuite());
        this.customTestSuiteModificationService.updateExecutionStatus(exec.getExecution().getTestPlanItem().getTestSuites());
        try {
            URL result = UrlUtils.toUrlOrNull((String)stateChange.getResultUrl());
            exec.setResultURL(result);
        }
        catch (InvalidUrlException ex) {
            LOGGER.warn("Received a result url which does not math any valid url pattern: {}", new Object[]{stateChange.getResultUrl(), ex});
        }
        this.execProcService.updateExecutionMetadata(exec);
    }

    private ExecutionStatus coerce(org.squashtest.tm.api.testautomation.execution.dto.ExecutionStatus status) {
        return ExecutionStatus.valueOf((String)status.name());
    }

    @Override
    public void changeExecutionState(long id, @NotNull TestExecutionStatus stateChange) {
        TestExecutionStatus testExecutionStatus = stateChange;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)testExecutionStatus);
        this.changeState(this.automatedExecutionDao.findById(id), stateChange);
    }

    @Override
    public String getExecutionStatus(long automExecExtenderId) {
        return this.customAutomatedExecExtenderDao.findExecutionStatusByExtenderId(automExecExtenderId);
    }
}

