/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import jakarta.persistence.Query;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.squashtest.tm.core.foundation.collection.ColumnFiltering;
import org.squashtest.tm.core.foundation.collection.Filtering;
import org.squashtest.tm.core.foundation.lang.DateUtils;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.testcase.TestCaseImportance;

final class TestPlanFilteringHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestPlanFilteringHelper.class);
    public static final String PROJECT_FILTER = "projectFilter";
    public static final String REFERENCE_FILTER = "referenceFilter";
    public static final String TESTCASE_FILTER = "testcaseFilter";
    public static final String WEIGHT_FILTER = "weightFilter";
    public static final String DATASET_FILTER = "datasetFilter";
    public static final String STATUS_FILTER = "statusFilter";
    public static final String USER_FILTER = "userFilter";
    public static final String START_DATE = "startDate";
    public static final String END_DATE = "endDate";
    public static final String TESTSUITE_FILTER = "testsuiteFilter";
    public static final String PROJECT_DATA = "project-name";
    public static final String REFERENCE_DATA = "reference";
    public static final String TESTCASE_DATA = "tc-name";
    public static final String WEIGHT_DATA = "importance";
    public static final String DATASET_DATA = "dataset.selected.name";
    public static final String TESTSUITE_DATA = "suite";
    public static final String STATUS_DATA = "status";
    public static final String USER_DATA = "assignee-login";
    public static final String MODE_DATA = "exec-mode";
    public static final String LASTEXEC_DATA = "last-exec-on";
    private static final String HQL_INDEXED_TEST_PLAN_PROJECT_FILTER = "and lower(Project.name) like :projectFilter ";
    private static final String HQL_INDEXED_TEST_PLAN_REFERENCE_FILTER = "and lower(TestCase.reference) like :referenceFilter ";
    private static final String HQL_INDEXED_TEST_PLAN_TESTCASE_FILTER = "and lower(TestCase.name) like :testcaseFilter ";
    private static final String HQL_INDEXED_TEST_PLAN_WEIGHT_FILTER = "and TestCase.importance = :weightFilter ";
    private static final String HQL_INDEXED_TEST_PLAN_DATASET_FILTER = "and lower(Dataset.name) like :datasetFilter ";
    private static final String HQL_INDEXED_TEST_PLAN_STATUS_FILTER = "and TestPlanItem.executionStatus = :statusFilter ";
    public static final String HQL_INDEXED_TEST_PLAN_MODEAUTO_FILTER = "and TestCase.automatedTest is not null ";
    public static final String HQL_INDEXED_TEST_PLAN_MODEMANUAL_FILTER = "and TestCase.automatedTest is null ";
    public static final String HQL_INDEXED_TEST_PLAN_USER_FILTER = "and TestPlanItem.assignee.id = :userFilter ";
    public static final String HQL_INDEXED_TEST_PLAN_NULL_USER_FILTER = "and TestPlanItem.assignee is null ";
    public static final String HQL_INDEXED_TEST_PLAN_EXECUTIONDATE_FILTER = "and TestPlanItem.lastExecutedOn between :startDate and :endDate ";
    private static final Map<String, String> SIMPLE_FILTER_CLAUSES;

    static {
        HashMap<String, String> clauses = new HashMap<String, String>();
        clauses.put(PROJECT_DATA, HQL_INDEXED_TEST_PLAN_PROJECT_FILTER);
        clauses.put(REFERENCE_DATA, HQL_INDEXED_TEST_PLAN_REFERENCE_FILTER);
        clauses.put(TESTCASE_DATA, HQL_INDEXED_TEST_PLAN_TESTCASE_FILTER);
        clauses.put(WEIGHT_DATA, HQL_INDEXED_TEST_PLAN_WEIGHT_FILTER);
        clauses.put(DATASET_DATA, HQL_INDEXED_TEST_PLAN_DATASET_FILTER);
        clauses.put(STATUS_DATA, HQL_INDEXED_TEST_PLAN_STATUS_FILTER);
        clauses.put(LASTEXEC_DATA, HQL_INDEXED_TEST_PLAN_EXECUTIONDATE_FILTER);
        SIMPLE_FILTER_CLAUSES = Collections.unmodifiableMap(clauses);
    }

    private TestPlanFilteringHelper() {
    }

    private static String anywhereToken(String token) {
        return "%" + token + "%";
    }

    public static void setFilters(Query query, Filtering filtering, ColumnFiltering columnFiltering) {
        String filter;
        if (filtering.isDefined()) {
            query.setParameter("userLogin", (Object)filtering.getFilter());
        }
        if (columnFiltering.hasFilter(PROJECT_DATA)) {
            query.setParameter(PROJECT_FILTER, (Object)TestPlanFilteringHelper.anywhereToken(columnFiltering.getFilter(PROJECT_DATA).toLowerCase()));
        }
        if (columnFiltering.hasFilter(REFERENCE_DATA)) {
            query.setParameter(REFERENCE_FILTER, (Object)TestPlanFilteringHelper.anywhereToken(columnFiltering.getFilter(REFERENCE_DATA).toLowerCase()));
        }
        if (columnFiltering.hasFilter(TESTCASE_DATA)) {
            query.setParameter(TESTCASE_FILTER, (Object)TestPlanFilteringHelper.anywhereToken(columnFiltering.getFilter(TESTCASE_DATA).toLowerCase()));
        }
        if (columnFiltering.hasFilter(WEIGHT_DATA)) {
            filter = columnFiltering.getFilter(WEIGHT_DATA);
            TestCaseImportance tci = TestCaseImportance.valueOf((String)filter);
            query.setParameter(WEIGHT_FILTER, (Object)tci);
        }
        if (columnFiltering.hasFilter(DATASET_DATA)) {
            query.setParameter(DATASET_FILTER, (Object)TestPlanFilteringHelper.anywhereToken(columnFiltering.getFilter(DATASET_DATA).toLowerCase()));
        }
        if (columnFiltering.hasFilter(TESTSUITE_DATA)) {
            query.setParameter(TESTSUITE_FILTER, (Object)TestPlanFilteringHelper.anywhereToken(columnFiltering.getFilter(TESTSUITE_DATA)));
        }
        if (columnFiltering.hasFilter(STATUS_DATA)) {
            filter = columnFiltering.getFilter(STATUS_DATA);
            ExecutionStatus executionStatus = ExecutionStatus.valueOf((String)filter);
            query.setParameter(STATUS_FILTER, (Object)executionStatus);
        }
        if (columnFiltering.hasFilter(USER_DATA) && !"0".equals(columnFiltering.getFilter(USER_DATA))) {
            query.setParameter(USER_FILTER, (Object)Long.parseLong(columnFiltering.getFilter(USER_DATA)));
        }
        if (columnFiltering.hasFilter(LASTEXEC_DATA)) {
            TestPlanFilteringHelper.setQueryStartAndEndDateParameters(columnFiltering, query);
        }
    }

    private static void setQueryStartAndEndDateParameters(ColumnFiltering columnFiltering, Query query) {
        String dates = columnFiltering.getFilter(LASTEXEC_DATA);
        Date startDate = null;
        Date endDate = null;
        if (dates.contains("-")) {
            String[] dateArray = dates.split("-");
            try {
                startDate = DateUtils.parseDdMmYyyyDate((String)dateArray[0].trim());
                endDate = DateUtils.parseDdMmYyyyDate((String)dateArray[1].trim());
            }
            catch (ParseException e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
        } else {
            try {
                startDate = DateUtils.parseDdMmYyyyDate((String)dates.trim());
                endDate = DateUtils.nextDay((Date)startDate);
            }
            catch (ParseException e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
        }
        query.setParameter(START_DATE, (Object)startDate);
        query.setParameter(END_DATE, (Object)endDate);
    }

    public static void appendFilteringRestrictions(StringBuilder hqlbuilder, ColumnFiltering columnFiltering) {
        for (Map.Entry<String, String> simpleFilterClause : SIMPLE_FILTER_CLAUSES.entrySet()) {
            String filterName = simpleFilterClause.getKey();
            String filterClause = simpleFilterClause.getValue();
            if (!columnFiltering.hasFilter(filterName)) continue;
            hqlbuilder.append(filterClause);
        }
    }
}

