/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.converters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jooq.Field;
import org.jooq.Record;
import org.springframework.stereotype.Service;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.InputType;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.infolist.InfoList;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.infolist.InfoListProjectBindingType;
import org.squashtest.tm.domain.infolist.UserListItem;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.dto.CustomFieldFormModel;
import org.squashtest.tm.service.internal.dto.pivotdefinition.CustomFieldPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.CustomFieldValuePivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.InfoListItemPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.InfoListPivot;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotImportMetadata;
import org.squashtest.tm.service.internal.dto.projectimporter.SquashCustomFieldInfo;
import org.squashtest.tm.service.pivot.converters.AdminPivotConverterService;
import org.squashtest.tm.service.pivot.projectexporter.dao.CustomFieldPivotDao;
import org.squashtest.tm.service.pivot.projectexporter.dao.InfoListPivotDao;

@Service(value="AdminPivotConverterService")
public class AdminPivotConverterServiceImpl
implements AdminPivotConverterService {
    @Override
    public CustomField pivotToCustomField(CustomFieldPivot customFieldPivot) {
        CustomFieldFormModel cufFormModel = new CustomFieldFormModel();
        cufFormModel.setInputType(customFieldPivot.getInputType());
        cufFormModel.setName(customFieldPivot.getName());
        cufFormModel.setLabel(customFieldPivot.getLabel());
        cufFormModel.setCode(customFieldPivot.getCode());
        cufFormModel.setDefaultValue(Objects.requireNonNullElse(customFieldPivot.getDefaultValue(), ""));
        cufFormModel.setOptional(customFieldPivot.isOptional());
        cufFormModel.setOptions(AdminPivotConverterServiceImpl.convertCufOptionsToListOfArrays(customFieldPivot.getOptions()));
        return cufFormModel.getCustomField();
    }

    @Override
    public Map<Long, RawValue> pivotToCustomFieldValues(List<CustomFieldValuePivot> customFieldValuePivotList, PivotImportMetadata pivotImportMetadata) {
        HashMap<Long, RawValue> customFieldsValues = new HashMap<Long, RawValue>();
        customFieldValuePivotList.forEach(customFieldValuePivot -> {
            SquashCustomFieldInfo customFieldInfo = pivotImportMetadata.getCustomFieldIdsMap().get(customFieldValuePivot.getPivotId());
            String value = customFieldValuePivot.getValue();
            if (InputType.TAG.equals((Object)customFieldInfo.inputType())) {
                ArrayList tagValues = Objects.nonNull(value) ? Arrays.stream(value.split("\\|")).toList() : new ArrayList();
                customFieldsValues.put(customFieldInfo.id(), new RawValue(tagValues));
            } else {
                customFieldsValues.put(customFieldInfo.id(), new RawValue(value));
            }
        });
        return customFieldsValues;
    }

    private static String[][] convertCufOptionsToListOfArrays(List<CustomFieldPivot.Option> options) {
        String[][] result = new String[options.size()][3];
        int i = 0;
        while (i < options.size()) {
            CustomFieldPivot.Option option = options.get(i);
            result[i][0] = option.getName();
            result[i][1] = option.getCode();
            result[i][2] = option.getColor();
            ++i;
        }
        return result;
    }

    @Override
    public CustomFieldValuePivot customFieldValueRecordToCustomFieldValuePivot(Record record) {
        CustomFieldValuePivot customFieldValuePivot = new CustomFieldValuePivot();
        customFieldValuePivot.setPivotId((Long)record.get(CustomFieldPivotDao.CFV_TABLE_CF_ID));
        customFieldValuePivot.setValue((String)record.get(CustomFieldPivotDao.CFV_TABLE_CF_VALUE));
        return customFieldValuePivot;
    }

    @Override
    public InfoList pivotToInfoList(InfoListPivot infoListPivot) {
        InfoList infoList = new InfoList();
        infoList.setLabel(infoListPivot.getLabel());
        infoList.setCode(infoListPivot.getCode());
        infoList.setDescription(infoListPivot.getDescription());
        infoListPivot.getInfoListItems().forEach(infoListItemPivot -> {
            UserListItem infoListItem = new UserListItem();
            infoListItem.setLabel(infoListItemPivot.getLabel());
            infoListItem.setCode(infoListItemPivot.getCode());
            infoListItem.setColour(infoListItemPivot.getColor());
            infoListItem.setIconName(infoListItemPivot.getIconName());
            infoListItem.setDefault(infoListItemPivot.getIsDefault());
            infoList.addItem((InfoListItem)infoListItem);
        });
        return infoList;
    }

    @Override
    public InfoListPivot recordToInfoListPivot(Record record) {
        InfoListPivot infoListPivot = new InfoListPivot();
        infoListPivot.setPivotId((Long)record.get((Field)Tables.INFO_LIST.INFO_LIST_ID));
        infoListPivot.setLabel((String)record.get((Field)Tables.INFO_LIST.LABEL));
        infoListPivot.setDescription((String)record.get((Field)Tables.INFO_LIST.DESCRIPTION));
        infoListPivot.setCode((String)record.get((Field)Tables.INFO_LIST.CODE));
        infoListPivot.getBoundProjectInfoLists().add(InfoListProjectBindingType.valueOf((String)((String)record.get(InfoListPivotDao.INFO_LIST_BINDING_TYPE))));
        return infoListPivot;
    }

    @Override
    public InfoListItemPivot recordToInfoListItemPivot(Record record) {
        InfoListItemPivot infoListItemPivot = new InfoListItemPivot();
        infoListItemPivot.setPivotId((Long)record.get((Field)Tables.INFO_LIST_ITEM.ITEM_ID));
        infoListItemPivot.setLabel((String)record.get((Field)Tables.INFO_LIST_ITEM.LABEL));
        infoListItemPivot.setCode((String)record.get((Field)Tables.INFO_LIST_ITEM.CODE));
        infoListItemPivot.setColor((String)record.get((Field)Tables.INFO_LIST_ITEM.COLOUR));
        infoListItemPivot.setIconName((String)record.get((Field)Tables.INFO_LIST_ITEM.ICON_NAME));
        infoListItemPivot.setDefault((Boolean)record.get((Field)Tables.INFO_LIST_ITEM.IS_DEFAULT));
        return infoListItemPivot;
    }
}

