/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.testautomation.resultpublisher;

import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.PersistenceContext;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.plugin.UsedInPlugin;
import org.squashtest.tm.api.testautomation.execution.dto.TestExecutionStatus;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.attachment.Attachment;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.testautomation.AutomatedSuite;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.service.attachment.AttachmentManagerService;
import org.squashtest.tm.service.internal.display.dto.AttachmentDto;
import org.squashtest.tm.service.internal.repository.AttachmentDao;
import org.squashtest.tm.service.internal.repository.AutomatedSuiteDao;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.testautomation.model.AutomatedExecutionState;
import org.squashtest.tm.service.testautomation.model.RestUploadedData;
import org.squashtest.tm.service.testautomation.resultpublisher.RestITPIManagerService;

@Service
@Transactional
public class AutomatedSuitePublisherService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutomatedSuitePublisherService.class);
    private static final Map<ExecutionStatus, Integer> PRIORITY_MAP;
    @Inject
    private AutomatedSuiteDao autoSuiteDao;
    @Inject
    private AttachmentManagerService attachmentManagerService;
    @Inject
    private RestITPIManagerService restITPIManagerService;
    @Inject
    private PermissionEvaluationService permissionEvaluationService;
    @Inject
    private AttachmentDao attachmentDao;
    @PersistenceContext
    private EntityManager entityManager;

    static {
        EnumMap<ExecutionStatus, Integer> statusPriorityMap = new EnumMap<ExecutionStatus, Integer>(ExecutionStatus.class);
        statusPriorityMap.put(ExecutionStatus.READY, 1);
        statusPriorityMap.put(ExecutionStatus.RUNNING, 2);
        statusPriorityMap.put(ExecutionStatus.UNTESTABLE, 3);
        statusPriorityMap.put(ExecutionStatus.SETTLED, 4);
        statusPriorityMap.put(ExecutionStatus.SKIPPED, 5);
        statusPriorityMap.put(ExecutionStatus.SUCCESS, 6);
        statusPriorityMap.put(ExecutionStatus.FAILURE, 7);
        statusPriorityMap.put(ExecutionStatus.BLOCKED, 8);
        statusPriorityMap.put(ExecutionStatus.CANCELLED, 9);
        PRIORITY_MAP = Collections.unmodifiableMap(statusPriorityMap);
    }

    public void forceExecutionStatus(Long suiteId, @NotNull AutomatedExecutionState stateChange) {
        AutomatedExecutionState automatedExecutionState = stateChange;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)automatedExecutionState);
        AutomatedSuite autoSuite = this.autoSuiteDao.findById(suiteId);
        this.checkPermissionsToUpdateAutomatedSuite(autoSuite);
        Date date = new Date();
        this.arbitraryUpdateMetadata(autoSuite, date);
        this.updateSelfExecutionStatus(autoSuite, stateChange);
        Optional.ofNullable(stateChange.getAttachments()).ifPresent(attachments -> {
            for (org.squashtest.tm.service.testautomation.model.Attachment attachment : attachments) {
                this.updateAttachments(autoSuite.getAttachmentList().getId(), attachment, EntityType.AUTOMATED_SUITE);
            }
        });
    }

    private void arbitraryUpdateMetadata(AutomatedSuite autoSuite, Date date) {
        autoSuite.setLastModifiedOn(date);
    }

    private void updateSelfExecutionStatus(AutomatedSuite automatedSuite, AutomatedExecutionState stateChange) {
        TestExecutionStatus testExecutionStatus = stateChange.getTfTestExecutionStatus().tfTestExecutionStatusToTmTestExecutionStatus();
        ExecutionStatus formerStatus = automatedSuite.getExecutionStatus().getCanonicalStatus();
        ExecutionStatus newStatus = ExecutionStatus.valueOf((String)testExecutionStatus.getStatus().name()).getCanonicalStatus();
        if (PRIORITY_MAP.get(newStatus) > PRIORITY_MAP.get(formerStatus)) {
            automatedSuite.setExecutionStatus(newStatus);
        }
        this.entityManager.flush();
        this.entityManager.clear();
    }

    @UsedInPlugin(value="rest-api")
    public void addItpiLabelAndIdToAttachmentName(long testId, AutomatedExecutionState stateChange) {
        TestPlanItem itpi = this.restITPIManagerService.getById(testId);
        TestCase testCase = itpi.getReferencedTestCase();
        String itpiLabel = testCase == null ? itpi.getLabel() : testCase.getName();
        Long itpiId = itpi.getId();
        Optional.ofNullable(stateChange.getAttachments()).ifPresent(attachments -> attachments.forEach(attachment -> attachment.setName(itpiLabel + "[" + String.valueOf(itpiId) + "]-" + attachment.getName())));
    }

    @UsedInPlugin(value="rest-api")
    public AttachmentDto attachReportToAutomatedSuite(String uuid, org.squashtest.tm.service.testautomation.model.Attachment allureUpdate) {
        AutomatedSuite autoSuite = this.autoSuiteDao.findByUuid(uuid);
        this.checkPermissionsToUpdateAutomatedSuite(autoSuite);
        Long attachmentListId = autoSuite.getAttachmentList().getId();
        return this.updateAttachments(attachmentListId, allureUpdate, EntityType.AUTOMATED_SUITE);
    }

    @UsedInPlugin(value="rest-api")
    public AttachmentDto updateAttachmentContent(org.squashtest.tm.service.testautomation.model.Attachment testAutoAttachment, Long attachmentId) {
        try {
            Attachment attachment = (Attachment)this.attachmentDao.findById(attachmentId).orElseThrow(EntityNotFoundException::new);
            return this.attachmentManagerService.updateAttachmentContent(attachment, testAutoAttachment.getContent());
        }
        catch (IOException e) {
            LOGGER.error("Unable to read attachment.", (Throwable)e);
            throw new NullPointerException();
        }
    }

    public AttachmentDto updateAttachments(Long attachmentListId, org.squashtest.tm.service.testautomation.model.Attachment attachment, EntityType entityType) {
        try {
            InputStream stream = attachment.getContent();
            String name = attachment.getName();
            long sizeInBytes = attachment.getContent().available();
            RestUploadedData attachmentUploadedData = new RestUploadedData(stream, name, sizeInBytes);
            return this.attachmentManagerService.addAttachment(attachmentListId, attachmentUploadedData, entityType);
        }
        catch (IOException e) {
            LOGGER.debug("Unable to read attachment.", (Throwable)e);
            return null;
        }
    }

    private void checkPermissionsToUpdateAutomatedSuite(AutomatedSuite suite) {
        boolean hasPermission = false;
        Iteration iteration = suite.getIteration();
        TestSuite testSuite = suite.getTestSuite();
        if (this.permissionEvaluationService.hasRole("ROLE_TA_API_CLIENT") || this.permissionEvaluationService.hasRole("ROLE_ADMIN")) {
            hasPermission = true;
        } else if (iteration != null) {
            hasPermission = this.permissionEvaluationService.hasPermissionOnObject("EXECUTE", iteration);
        } else if (testSuite != null) {
            hasPermission = this.permissionEvaluationService.hasPermissionOnObject("EXECUTE", testSuite);
        }
        if (!hasPermission) {
            throw new AccessDeniedException("Access is denied.");
        }
    }

    @UsedInPlugin(value="rest-api")
    public void updateAutomatedSuiteExecStatus(String uuid, String status) {
        try {
            ExecutionStatus executionStatus = ExecutionStatus.valueOf((String)status);
            AutomatedSuite autoSuite = this.autoSuiteDao.findByUuid(uuid);
            autoSuite.setExecutionStatus(executionStatus);
            TestSuite testSuite = autoSuite.getTestSuite();
            if (testSuite != null) {
                testSuite.setExecutionStatus(executionStatus);
            }
            if (ExecutionStatus.BLOCKED.equals((Object)executionStatus)) {
                autoSuite.setWorkflows(null);
            }
            this.entityManager.flush();
            this.entityManager.clear();
        }
        catch (IllegalArgumentException ex) {
            LOGGER.error("Received status {} is not a valid status.", new Object[]{status, ex});
        }
    }
}

