/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testcase.bdd;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;
import org.squashtest.tm.core.foundation.exception.ActionException;

public class ContextualizedActionWordException
extends ActionException {
    private static final long serialVersionUID = -8274793605542414514L;
    final int errorPosition;
    final String errorContext;

    protected ContextualizedActionWordException(String message, String source, int errorPosition) {
        super(message);
        this.errorPosition = errorPosition;
        this.errorContext = ContextualizedActionWordException.buildErrorContext(source, errorPosition);
    }

    private static String buildErrorContext(String source, int position) {
        int numWhiteSpaces = position - 1;
        StringBuilder sb = new StringBuilder(StringEscapeUtils.escapeHtml4((String)source));
        if (numWhiteSpaces >= 0) {
            sb.append("\n").append(Arrays.stream(new String[numWhiteSpaces]).map(s -> " ").collect(Collectors.joining())).append("^");
        }
        return sb.toString();
    }

    public Object[] messageArgs() {
        return new Object[]{this.errorPosition, this.errorContext};
    }
}

