/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.requirement;

import jakarta.inject.Inject;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.service.internal.repository.RequirementVersionDao;
import org.squashtest.tm.service.requirement.RequirementVersionResolverService;

@Transactional
@Service(value="squashtest.tm.service.RequirementVersionResolverService")
public class RequirementVersionResolverServiceImpl
implements RequirementVersionResolverService {
    @Inject
    private RequirementVersionDao versionDao;

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="hasPermission(#requirementId, 'org.squashtest.tm.domain.requirement.Requirement', 'READ') or hasRole('ROLE_ADMIN')")
    public RequirementVersion resolveByRequirementId(long requirementId) {
        return this.versionDao.findByRequirementIdAndMilestone(requirementId);
    }
}

