/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import jakarta.persistence.EntityGraph;
import jakarta.persistence.Query;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jooq.DSLContext;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementFolder;
import org.squashtest.tm.domain.requirement.RequirementLibraryNode;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.repository.RequirementFolderDao;
import org.squashtest.tm.service.internal.repository.hibernate.ContainerIdNameStartParameterCallback;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateEntityDao;
import org.squashtest.tm.service.internal.repository.hibernate.SetQueryParametersCallback;

@Repository
public class HibernateRequirementFolderDao
extends HibernateEntityDao<RequirementFolder>
implements RequirementFolderDao {
    private final DSLContext dsl;

    public HibernateRequirementFolderDao(DSLContext dsl) {
        this.dsl = dsl;
    }

    @Override
    public RequirementFolder findByContent(RequirementLibraryNode node) {
        Optional parentId = this.dsl.select((SelectField)Tables.RLN_RELATIONSHIP.ANCESTOR_ID).from((TableLike)Tables.RLN_RELATIONSHIP).where(Tables.RLN_RELATIONSHIP.DESCENDANT_ID.eq((Object)node.getId())).fetchOptionalInto(Long.class);
        return parentId.map(this::findById).orElse(null);
    }

    @Override
    public List<String> findNamesInLibraryStartingWith(long libraryId, String nameStart) {
        ContainerIdNameStartParameterCallback newCallBack1 = new ContainerIdNameStartParameterCallback(libraryId, nameStart);
        return this.executeListNamedQuery("requirementFolder.findNamesInLibraryStartingWith", newCallBack1);
    }

    @Override
    public List<String> findNamesInNodeStartingWith(long nodeId, String nameStart) {
        ContainerIdNameStartParameterCallback newCallBack1 = new ContainerIdNameStartParameterCallback(nodeId, nameStart);
        return this.executeListNamedQuery("requirementLibraryNode.findNamesInNodeStartingWith", newCallBack1);
    }

    @Override
    public RequirementFolder findByIdWithContent(Long id) {
        EntityGraph graph = this.entityManager.createEntityGraph(RequirementFolder.class);
        graph.addSubgraph("content", RequirementLibraryNode.class);
        return (RequirementFolder)this.entityManager.createQuery("SELECT rf FROM RequirementFolder rf  WHERE rf.id = :id", RequirementFolder.class).setHint("jakarta.persistence.fetchgraph", (Object)graph).setParameter("id", (Object)id).getSingleResult();
    }

    @Override
    public RequirementFolder loadContainerForPaste(long id) {
        EntityGraph graph = this.entityManager.createEntityGraph(RequirementFolder.class);
        graph.addSubgraph("content", Requirement.class).addAttributeNodes(new String[]{"syncExtender", "versions"});
        return (RequirementFolder)this.entityManager.createQuery("SELECT rf FROM RequirementFolder rf  WHERE rf.id = :id", RequirementFolder.class).setHint("jakarta.persistence.fetchgraph", (Object)graph).setParameter("id", (Object)id).getSingleResult();
    }

    @Override
    public RequirementFolder loadForNodeAddition(Long folderId) {
        return (RequirementFolder)this.entityManager.createQuery("select folder from RequirementFolder folder\njoin fetch folder.project project\njoin fetch project.requirementCategories\nleft join fetch folder.requirementFolderSyncExtender\nleft join fetch folder.content content\nleft join fetch content.syncExtender\nleft join fetch content.requirementFolderSyncExtender\nwhere folder.id = :id", RequirementFolder.class).setParameter("id", (Object)folderId).getSingleResult();
    }

    @Override
    public List<RequirementFolder> loadForNodeAddition(Collection<Long> folderIds) {
        return this.entityManager.createQuery("select distinct folder from RequirementFolder folder\njoin fetch folder.project project\njoin fetch project.requirementCategories\nleft join fetch folder.requirementFolderSyncExtender\nleft join fetch folder.content content\nleft join fetch content.syncExtender\nleft join fetch content.requirementFolderSyncExtender\nwhere folder.id in :ids", RequirementFolder.class).setParameter("ids", folderIds).getResultList();
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<Long[]> findPairedContentForList(List<Long> ids) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public List<Long> findContentForList(List<Long> ids) {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        List queryResults = this.entityManager.createNativeQuery("select * from RLN_RELATIONSHIP where ancestor_id in (:folderIds)").setParameter("folderIds", ids).getResultList();
        return queryResults.stream().map(row -> ((Number)row[1]).longValue()).toList();
    }

    @Override
    public RequirementFolder findParentOf(Long id) {
        ContentIdParametterCallback newCallBack = new ContentIdParametterCallback(id);
        return (RequirementFolder)this.executeEntityNamedQuery("requirementFolder.findParentOf", newCallBack);
    }

    private static final class ContentIdParametterCallback
    implements SetQueryParametersCallback {
        private long contentId;

        private ContentIdParametterCallback(long contentId) {
            this.contentId = contentId;
        }

        @Override
        public void setQueryParameters(Query query) {
            query.setParameter("contentId", (Object)this.contentId);
        }
    }
}

