/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.map.MultiValueMap;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.api.plugin.UsedInPlugin;
import org.squashtest.tm.domain.NamedReference;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.TestPlanStatistics;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseExecutionStatus;
import org.squashtest.tm.service.internal.repository.IterationDao;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateEntityDao;
import org.squashtest.tm.service.internal.repository.hibernate.SetIdParameter;
import org.squashtest.tm.service.internal.repository.hibernate.loaders.EntityGraphQueryBuilder;
import org.squashtest.tm.service.internal.repository.hibernate.loaders.NestedEntityGraphQueryBuilder;
import org.squashtest.tm.service.statistics.CountOnEnum;

@Repository
public class HibernateIterationDao
extends HibernateEntityDao<Iteration>
implements IterationDao {
    private static final String UNCHECKED = "unchecked";
    @PersistenceContext
    private EntityManager em;

    @Override
    public List<Iteration> findAllIterationContainingTestCase(long testCaseId) {
        return this.executeListNamedQuery("iterationDao.findAllIterationContainingTestCase", new SetIdParameter("testCaseId", testCaseId));
    }

    @Override
    public List<NamedReference> findAllTestSuitesAsNamedReferences(long iterationId) {
        return this.entityManager.createNamedQuery("iteration.findAllTestSuitesAsNamedReferences", NamedReference.class).setParameter("iterationId", (Object)iterationId).getResultList();
    }

    @UsedInPlugin(value="rest-api")
    public TestPlanStatistics getIterationStatisticsByItpiIds(List<Long> itpiIds) {
        List result = this.entityManager.createNamedQuery("iteration.countStatusesByItpiIds", Object[].class).setParameter("itpiIds", itpiIds).getResultList();
        LinkedHashMap<ExecutionStatus, Integer> canonicalStatusMap = CountOnEnum.fromTuples(result, ExecutionStatus.class).getStatistics(ExecutionStatus::getCanonicalStatus, ExecutionStatus.getCanonicalStatusSet());
        return new TestPlanStatistics(canonicalStatusMap);
    }

    @Override
    public List<TestCaseExecutionStatus> findExecStatusForIterationsAndTestCases(List<Long> testCasesIds, List<Long> iterationsIds) {
        if (testCasesIds.isEmpty()) {
            return Collections.emptyList();
        }
        List results = this.entityManager.createNamedQuery("iteration.findITPIByTestCaseGroupByStatus").setParameter("testCasesIds", testCasesIds).setParameter("iterationsIds", iterationsIds).getResultList();
        ArrayList<TestCaseExecutionStatus> formatedResult = new ArrayList<TestCaseExecutionStatus>(results.size());
        for (Object[] result : results) {
            formatedResult.add(new TestCaseExecutionStatus((ExecutionStatus)result[0], (Long)result[1]));
        }
        return formatedResult;
    }

    @Override
    public List<Long> findVerifiedTcIdsInIterations(List<Long> testCasesIds, List<Long> iterationIds) {
        return this.findAllByTestCasesAndIterations("iteration.findVerifiedTcIdsInIterations", testCasesIds, iterationIds, Long.class);
    }

    private <R> List<R> findAllByTestCasesAndIterations(String queryName, List<Long> testCaseIds, List<Long> iterationIds, Class<R> resultClass) {
        if (testCaseIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.entityManager.createNamedQuery(queryName, resultClass).setParameter("testCasesIds", testCaseIds).setParameter("iterationsIds", iterationIds).getResultList();
    }

    @Override
    public List<Long> findVerifiedTcIdsInIterationsWithExecution(List<Long> tcIds, List<Long> iterationsIds) {
        return this.findAllByTestCasesAndIterations("iteration.findVerifiedAndExecutedTcIdsInIterations", tcIds, iterationsIds, Long.class);
    }

    @Override
    public MultiMap findVerifiedITPI(List<Long> tcIds, List<Long> iterationsIds) {
        List<Object[]> itpis = this.findAllByTestCasesAndIterations("iteration.findITPIByTestCaseGroupByStatus", tcIds, iterationsIds, Object[].class);
        MultiValueMap result = new MultiValueMap();
        for (Object[] itpi : itpis) {
            TestCaseExecutionStatus tcStatus = new TestCaseExecutionStatus((ExecutionStatus)itpi[0], (Long)itpi[1]);
            result.put((Object)tcStatus.getTestCaseId(), (Object)tcStatus);
        }
        return result;
    }

    @Override
    public Iteration findByUUID(String targetUUID) {
        return (Iteration)this.em.createQuery("SELECT i FROM Iteration i WHERE i.uuid = :uuid", Iteration.class).setParameter("uuid", (Object)targetUUID).getSingleResult();
    }

    @Override
    public Long getProjectId(long iterationId) {
        return (Long)this.em.createQuery("select it.campaign.project.id from Iteration it where it.id = :id", Long.class).setParameter("id", (Object)iterationId).getSingleResult();
    }

    @Override
    public List<Long> findTestPlanIds(long iterationId) {
        return this.em.createQuery("select tp.id from Iteration it join it.testPlan.testPlanItems tp where it.id = :id", Long.class).setParameter("id", (Object)iterationId).getResultList();
    }

    @Override
    public Iteration loadContainerForPaste(long id) {
        Iteration iteration = new EntityGraphQueryBuilder<Iteration>(this.entityManager, Iteration.class, "select i from Iteration i where i.id = :id").addAttributeNodes("testSuites").execute(Map.of("id", id));
        new EntityGraphQueryBuilder<Iteration>(this.entityManager, Iteration.class, "select i from Iteration i where i.id = :id").addSubGraph("testPlan", "testPlanItems").addSubgraphToSubgraph("testPlan", "testPlanItems", "exploratorySessionOverview").execute(Map.of("id", id));
        return iteration;
    }

    @Override
    public List<Iteration> loadNodeForPaste(Collection<Long> ids) {
        List<Iteration> iterations = NestedEntityGraphQueryBuilder.of(this.em, Iteration.class, "SELECT DISTINCT it FROM Iteration it WHERE it.id IN :ids", NestedEntityGraphQueryBuilder.GraphDefinition.graphDefinition(NestedEntityGraphQueryBuilder.GraphDefinition.attr("campaign"), NestedEntityGraphQueryBuilder.GraphDefinition.sub("attachmentList", NestedEntityGraphQueryBuilder.GraphDefinition.sub("attachments", NestedEntityGraphQueryBuilder.GraphDefinition.attr("content"))), NestedEntityGraphQueryBuilder.GraphDefinition.sub("testPlan", NestedEntityGraphQueryBuilder.GraphDefinition.sub("testPlanItems", NestedEntityGraphQueryBuilder.GraphDefinition.sub("exploratorySessionOverview", NestedEntityGraphQueryBuilder.GraphDefinition.sub("attachmentList", NestedEntityGraphQueryBuilder.GraphDefinition.sub("attachments", NestedEntityGraphQueryBuilder.GraphDefinition.attr("content")))))))).executeDistinctList(Map.of("ids", ids));
        NestedEntityGraphQueryBuilder.of(this.em, Iteration.class, "SELECT DISTINCT it FROM Iteration it WHERE it.id IN :ids", NestedEntityGraphQueryBuilder.GraphDefinition.graphDefinition(NestedEntityGraphQueryBuilder.GraphDefinition.sub("testSuites", NestedEntityGraphQueryBuilder.GraphDefinition.sub("testPlanItems", NestedEntityGraphQueryBuilder.GraphDefinition.sub("exploratorySessionOverview", NestedEntityGraphQueryBuilder.GraphDefinition.sub("attachmentList", NestedEntityGraphQueryBuilder.GraphDefinition.sub("attachments", NestedEntityGraphQueryBuilder.GraphDefinition.attr("content"))))), NestedEntityGraphQueryBuilder.GraphDefinition.sub("attachmentList", NestedEntityGraphQueryBuilder.GraphDefinition.sub("attachments", NestedEntityGraphQueryBuilder.GraphDefinition.attr("content")))))).executeDistinctList(Map.of("ids", ids));
        return iterations;
    }

    @Override
    public boolean hasDeletedTestCaseInTestPlan(long iterationId) {
        return (Boolean)this.em.createQuery("select count(i) > 0\nfrom Iteration i\njoin i.testPlan tp\njoin tp.testPlanItems item\nwhere i.id = :id and item.referencedTestCase is null", Boolean.class).setParameter("id", (Object)iterationId).getSingleResult();
    }

    @Override
    public Iteration loadForExecutionResume(long iterationId) {
        List itemIds = this.entityManager.createQuery("select item.id\nfrom Iteration it\njoin it.testPlan tp\njoin tp.testPlanItems item\nwhere it.id = :id", Long.class).setParameter("id", (Object)iterationId).getResultList();
        if (!itemIds.isEmpty()) {
            this.entityManager.createQuery("select distinct tpi\nfrom TestPlanItem tpi\nleft join fetch tpi.executions exec\nleft join fetch exec.steps\nleft join fetch exec.automatedExecutionExtender\nwhere tpi.id in :itemIds", TestPlanItem.class).setParameter("itemIds", (Object)itemIds).getResultList();
            this.entityManager.createQuery("select distinct tc\nfrom TestCase tc\nleft join fetch tc.steps\nwhere tc.id in (\n    select tpi.referencedTestCase.id\n    from TestPlanItem tpi\n    where tpi.id in :itemIds\n    and tpi.referencedTestCase is not null\n)", TestCase.class).setParameter("itemIds", (Object)itemIds).getResultList();
        }
        return (Iteration)this.entityManager.createQuery("select distinct it\nfrom Iteration it\nleft join fetch it.testPlan tp\nleft join fetch tp.testPlanItems item\nwhere it.id = :id", Iteration.class).setParameter("id", (Object)iterationId).getSingleResult();
    }

    @Override
    public Iteration loadWithTestSuites(long iterationId) {
        return (Iteration)this.entityManager.createQuery("select it\nfrom Iteration it\nleft join fetch it.testSuites ts\nwhere it.id = :id", Iteration.class).setParameter("id", (Object)iterationId).getSingleResult();
    }
}

