/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectexporter.dao;

import java.util.Iterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record7;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AbstractPivotEntity;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AbstractPivotObject;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.SprintPivot;
import org.squashtest.tm.service.pivot.converters.ExecutionWorkspaceConverterService;
import org.squashtest.tm.service.pivot.projectexporter.SprintPivotDao;
import org.squashtest.tm.service.pivot.projectexporter.dao.CustomFieldPivotDao;

@Repository
public class SprintPivotDaoImpl
implements SprintPivotDao {
    private static final int BATCH_SIZE = 50;
    private final DSLContext dsl;
    private final CustomFieldPivotDao customFieldPivotDao;
    private final ExecutionWorkspaceConverterService executionWorkspaceConverterService;

    public SprintPivotDaoImpl(DSLContext dsl, CustomFieldPivotDao customFieldPivotDao, ExecutionWorkspaceConverterService executionWorkspaceConverterService) {
        this.dsl = dsl;
        this.customFieldPivotDao = customFieldPivotDao;
        this.executionWorkspaceConverterService = executionWorkspaceConverterService;
    }

    @Override
    public boolean hasSprintByProjectId(Long projectId) {
        return this.dsl.fetchExists((Select)this.dsl.selectOne().from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).join((TableLike)Tables.SPRINT).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.SPRINT.CLN_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)));
    }

    @Override
    public void getSprintByProjectId(Long projectId, Consumer<SprintPivot> sprintConsumer) {
        Table<Record7<Long, Long, String, String, String, String, String>> customFieldValuesTable = this.customFieldPivotDao.getCustomFieldValuesTableByProjectIdAndBindableEntity(projectId, BindableEntity.SPRINT);
        ResultQuery resultQuery = this.dsl.select((SelectField)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.NAME, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.DESCRIPTION, (SelectField)Tables.SPRINT.REFERENCE, (SelectField)Tables.SPRINT.START_DATE, (SelectField)Tables.SPRINT.END_DATE, (SelectField)Tables.SPRINT.STATUS, (SelectField)DSL.when((Condition)Tables.CAMPAIGN_FOLDER.CLN_ID.isNotNull(), (Object)EntityType.CAMPAIGN_FOLDER.name()).when(Tables.SPRINT_GROUP.CLN_ID.isNotNull(), (Object)EntityType.SPRINT_GROUP.name()).otherwise((Object)EntityType.CAMPAIGN_LIBRARY.name()).as(SprintPivotDao.PARENT_TYPE_FIELD), (SelectField)Tables.CLN_RELATIONSHIP.ANCESTOR_ID, CustomFieldPivotDao.CFV_TABLE_CF_ID, CustomFieldPivotDao.CFV_TABLE_CF_VALUE).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).join((TableLike)Tables.SPRINT).on(Tables.SPRINT.CLN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).leftJoin(customFieldValuesTable).on(Tables.SPRINT.CLN_ID.eq(CustomFieldPivotDao.CFV_TABLE_BOUND_ENTITY_ID)).leftJoin((TableLike)Tables.CLN_RELATIONSHIP).on(Tables.SPRINT.CLN_ID.eq((Field)Tables.CLN_RELATIONSHIP.DESCENDANT_ID)).leftJoin((TableLike)Tables.CAMPAIGN_FOLDER).on(Tables.CAMPAIGN_FOLDER.CLN_ID.eq((Field)Tables.CLN_RELATIONSHIP.ANCESTOR_ID)).leftJoin((TableLike)Tables.SPRINT_GROUP).on(Tables.SPRINT_GROUP.CLN_ID.eq((Field)Tables.CLN_RELATIONSHIP.ANCESTOR_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).orderBy((OrderField)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID).fetchSize(50);
        this.consumeSprint(resultQuery, sprintConsumer);
    }

    private <T extends Record> void consumeSprint(ResultQuery<T> resultQuery, Consumer<SprintPivot> writingToJsonConsumer) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Stream stream = resultQuery.fetchStream();){
            Iterator iterator = stream.iterator();
            AbstractPivotObject sprintPivot = null;
            while (iterator.hasNext()) {
                Record record = (Record)iterator.next();
                if (sprintPivot == null) {
                    sprintPivot = this.executionWorkspaceConverterService.sprintRecordToSprintPivot(record);
                    this.customFieldPivotDao.appendCustomFieldValuesFromRecord(((AbstractPivotEntity)sprintPivot).getCustomFields(), record);
                    continue;
                }
                if (!sprintPivot.pivotIdToSquashId().equals(record.get((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID))) {
                    writingToJsonConsumer.accept((SprintPivot)sprintPivot);
                    sprintPivot = this.executionWorkspaceConverterService.sprintRecordToSprintPivot(record);
                    this.customFieldPivotDao.appendCustomFieldValuesFromRecord(((AbstractPivotEntity)sprintPivot).getCustomFields(), record);
                    continue;
                }
                this.customFieldPivotDao.appendCustomFieldValuesFromRecord(((AbstractPivotEntity)sprintPivot).getCustomFields(), record);
            }
            writingToJsonConsumer.accept((SprintPivot)sprintPivot);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

