/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.test.automation.server;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jooq.DSLContext;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.testautomation.TestAutomationServer;
import org.squashtest.tm.service.annotation.CheckEntityExists;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.display.test.automation.server.TestAutomationServerDisplayService;
import org.squashtest.tm.service.internal.display.dto.CredentialsDto;
import org.squashtest.tm.service.internal.display.dto.TestAutomationServerAdminViewDto;
import org.squashtest.tm.service.internal.display.dto.TestAutomationServerDto;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.display.grid.administration.TestAutomationServerGrid;
import org.squashtest.tm.service.internal.repository.TestAutomationServerDao;
import org.squashtest.tm.service.internal.repository.display.TestAutomationServerDisplayDao;
import org.squashtest.tm.service.servers.ManageableCredentials;
import org.squashtest.tm.service.servers.StoredCredentialsManager;
import org.squashtest.tm.service.testautomation.TestAutomationServerCredentialsService;

@Service
@Transactional(readOnly=true)
public class TestAutomationServerDisplayServiceImpl
implements TestAutomationServerDisplayService {
    private final DSLContext dsl;
    private final TestAutomationServerDisplayDao testAutomationServerDisplayDao;
    private final StoredCredentialsManager credentialsManager;
    private final TestAutomationServerCredentialsService testAutomationServerCredentialsService;
    private final TestAutomationServerDao testAutomationServerDao;

    @Inject
    public TestAutomationServerDisplayServiceImpl(DSLContext dsl, TestAutomationServerDisplayDao testAutomationServerDisplayDao, StoredCredentialsManager credentialsManager, TestAutomationServerCredentialsService testAutomationServerCredentialsService, TestAutomationServerDao testAutomationServerDao) {
        this.dsl = dsl;
        this.testAutomationServerDisplayDao = testAutomationServerDisplayDao;
        this.credentialsManager = credentialsManager;
        this.testAutomationServerCredentialsService = testAutomationServerCredentialsService;
        this.testAutomationServerDao = testAutomationServerDao;
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public GridResponse getTestAutomationServerGrid(GridRequest request) {
        TestAutomationServerGrid testAutomationServerGrid = new TestAutomationServerGrid();
        return testAutomationServerGrid.getRows(request, this.dsl);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public List<TestAutomationServerDto> findAll() {
        return this.testAutomationServerDisplayDao.findAll();
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @CheckEntityExists(entityType=TestAutomationServer.class)
    public TestAutomationServerAdminViewDto getTestAutomationServerView(@Id long testAutomationServerId) {
        TestAutomationServerAdminViewDto dto = TestAutomationServerAdminViewDto.from(this.testAutomationServerDisplayDao.getTestAutomationServerById(testAutomationServerId));
        ManageableCredentials credentials = this.credentialsManager.findAppLevelCredentials(testAutomationServerId);
        dto.setSupportsAutomatedExecutionEnvironments(this.testAutomationServerDisplayDao.supportsAutomatedExecutionEnvironments(dto.getKind()));
        dto.setEnvironmentTags(this.getDefaultEnvironmentTags(testAutomationServerId));
        dto.setCredentials(CredentialsDto.from(credentials));
        dto.setSupportedAuthenticationProtocols(this.getSupportedAuthenticationProtocols(testAutomationServerId));
        return dto;
    }

    private List<String> getSupportedAuthenticationProtocols(long testAutomationServerId) {
        Optional server = this.testAutomationServerDao.findById(testAutomationServerId);
        return server.map(testAutomationServer -> Arrays.stream(this.testAutomationServerCredentialsService.getSupportedProtocols((TestAutomationServer)testAutomationServer)).map(Enum::name).toList()).orElse(new ArrayList());
    }

    @Override
    public List<String> getDefaultEnvironmentTags(long testAutomationServerId) {
        return this.testAutomationServerDao.getEnvironmentTags(testAutomationServerId);
    }

    @Override
    public boolean hasDefinedCredentials(long testAutomationServerId) {
        return this.credentialsManager.unsecuredFindAppLevelCredentials(testAutomationServerId) != null;
    }

    @Override
    @PreAuthorize(value="hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration' , 'READ') or hasRole('ROLE_ADMIN')")
    public Map<Long, Long> findProjectAndServerIdsByIterationId(Long iterationId) {
        return this.testAutomationServerDao.findIdsByIterationId(iterationId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#testSuiteId, 'org.squashtest.tm.domain.campaign.TestSuite', 'READ') or hasRole('ROLE_ADMIN')")
    public Map<Long, Long> findProjectAndServerIdsByTestSuiteId(Long testSuiteId) {
        return this.testAutomationServerDao.findIdsByTestSuiteId(testSuiteId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public Long findTestAutomationServerIdByGenericProjectId(long projectId) {
        return this.testAutomationServerDao.findTestAutomationServerIdByGenericProjectId(projectId);
    }

    @Override
    public Long findTestAutomationServerIdByGenericProjectIdUnsecured(long projectId) {
        return this.testAutomationServerDao.findTestAutomationServerIdByGenericProjectId(projectId);
    }
}

