/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport.column.testcase;

import org.squashtest.tm.core.foundation.lang.PathUtils;
import org.squashtest.tm.service.importer.EntityType;
import org.squashtest.tm.service.importer.Target;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.RequirementVersionTarget;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.TestCaseTarget;

public class CoverageTarget
implements Target {
    private String reqPath;
    private int reqVersion;
    private String tcPath;
    private TestCaseTarget testCase;
    private RequirementVersionTarget requirementVersion;

    public String getReqPath() {
        return this.reqPath;
    }

    public void setReqPath(String reqPath) {
        this.reqPath = this.cleanPath(reqPath);
    }

    public int getReqVersion() {
        return this.reqVersion;
    }

    public void setReqVersion(int reqVersion) {
        this.reqVersion = reqVersion;
    }

    public String getTcPath() {
        return this.tcPath;
    }

    public void setTcPath(String tcPath) {
        this.tcPath = this.cleanPath(tcPath);
    }

    public boolean isReqPathWellFormed() {
        return PathUtils.isPathWellFormed((String)this.reqPath);
    }

    public boolean isTcPathWellFormed() {
        return PathUtils.isPathWellFormed((String)this.tcPath);
    }

    public TestCaseTarget getTestCase() {
        return this.testCase;
    }

    public void setTestCase(TestCaseTarget testCase) {
        this.testCase = testCase;
    }

    public RequirementVersionTarget getRequirementVersion() {
        return this.requirementVersion;
    }

    public void setRequirementVersion(RequirementVersionTarget requirementVersion) {
        this.requirementVersion = requirementVersion;
    }

    @Override
    public EntityType getType() {
        return EntityType.COVERAGE;
    }

    @Override
    public boolean isWellFormed() {
        return this.isReqPathWellFormed() && this.isTcPathWellFormed();
    }

    @Override
    public String getSourcePath() {
        return this.getReqPath();
    }

    public Long getRequirementId() {
        return this.requirementVersion.getRequirement().getId();
    }

    public Long getTestCaseId() {
        return this.testCase.getId();
    }

    private String cleanPath(String path) {
        path = path.trim();
        path = PathUtils.cleanMultipleSlashes((String)path);
        path = PathUtils.removeAllUnnecessarySpaces((String)path);
        return path;
    }
}

