/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.attachment;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.sql.Blob;
import java.util.List;
import java.util.Objects;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.attachment.Attachment;
import org.squashtest.tm.domain.attachment.AttachmentContent;
import org.squashtest.tm.service.attachment.RawAttachment;
import org.squashtest.tm.service.internal.attachment.AttachmentRepository;
import org.squashtest.tm.service.internal.attachment.AttachmentRepositoryVisitor;

@Component(value="databaseAttachmentRepository")
@ConditionalOnProperty(name={"squashtm.feature.file.repository"}, havingValue="false", matchIfMissing=true)
@Transactional
public class DatabaseAttachmentRepository
implements AttachmentRepository {
    @PersistenceContext
    private EntityManager entityManager;

    private Session currentSession() throws HibernateException {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Override
    public AttachmentContent createContent(RawAttachment rawAttachment, long attachmentListId) {
        AttachmentContent content = new AttachmentContent();
        Throwable throwable = null;
        Object var6_6 = null;
        try (Session session = this.currentSession();){
            Blob blob = session.getLobHelper().createBlob(rawAttachment.getStream(), rawAttachment.getSizeInBytes());
            content.setContent(blob);
            session.persist((Object)content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return content;
    }

    @Override
    public InputStream getContentStream(Long attachmentId) throws FileNotFoundException {
        Attachment attachment = (Attachment)this.entityManager.find(Attachment.class, (Object)attachmentId);
        if (Objects.nonNull(attachment)) {
            return attachment.getContent().getStream();
        }
        throw new FileNotFoundException();
    }

    @Override
    public byte[] getContentBytes(Long attachmentId) {
        Attachment attachment = (Attachment)this.entityManager.find(Attachment.class, (Object)attachmentId);
        return attachment.getContent().getBytes();
    }

    @Override
    public void removeContent(long attachmentId) {
    }

    @Override
    public void copyContent(Attachment copy) {
    }

    @Override
    public void deleteContent(List<Long> attachmentListIds) {
    }

    @Override
    public void removeContent(long attachmentListId, long attachmentContentId) {
    }

    @Override
    public void accept(AttachmentRepositoryVisitor visitor) {
        visitor.visit(this);
    }
}

