/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.user;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Paths;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.exception.user.InfrastructureAdminException;
import org.squashtest.tm.service.user.ApiTokenService;
import org.squashtest.tm.service.user.InfrastructureAdminService;
import org.squashtest.tm.service.user.UserManagerService;

@Service
@Transactional
public class InfrastructureAdminServiceImpl
implements InfrastructureAdminService {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfrastructureAdminServiceImpl.class);
    private static final String TOKEN_FILE_NAME = "squash-cloud-admin-init-token.tmp";
    private final UserManagerService userManagerService;
    private final ApiTokenService apiTokenService;
    @Value(value="${java.io.tmpdir}")
    private String infrastructureAdminTokenFolderPath;

    public InfrastructureAdminServiceImpl(UserManagerService userManagerService, ApiTokenService apiTokenService) {
        this.userManagerService = userManagerService;
        this.apiTokenService = apiTokenService;
    }

    @Override
    public void createInfrastructureAdminAndToken() {
        LOGGER.debug("Creating infrastructure administrator user.", new Object[0]);
        User user = this.userManagerService.createInfrastructureAdmin();
        LOGGER.debug("Generating API token for infrastructure administrator.", new Object[0]);
        String userToken = this.apiTokenService.generateApiTokenForInfrastructureAdmin(user).generatedJwtToken();
        LOGGER.debug("Registering API token on the server.", new Object[0]);
        this.registerTokenOnServer(userToken);
    }

    @Override
    public String getTokenFilePath() {
        return Paths.get(this.infrastructureAdminTokenFolderPath, TOKEN_FILE_NAME).toString();
    }

    private void registerTokenOnServer(String userToken) {
        String filePath = this.getTokenFilePath();
        try {
            File file = new File(filePath);
            if (!file.exists()) {
                File folder = file.getParentFile();
                if (!folder.exists() && !folder.mkdirs()) {
                    throw new IOException("Failed to create directory: %s".formatted(folder.getAbsolutePath()));
                }
                if (!file.createNewFile()) {
                    throw new IOException("Failed to create file: %s".formatted(filePath));
                }
            }
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(file, false));){
                writer.write(userToken);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            LOGGER.debug("Token successfully saved in the file.", new Object[0]);
        }
        catch (IOException e) {
            throw new InfrastructureAdminException("Failed to save token file.", (Throwable)e);
        }
    }
}

