/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl.collectors;

import com.google.common.base.Strings;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.NodeReference;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.testcase.TestCaseKind;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.grid.DataRow;
import org.squashtest.tm.service.internal.repository.display.CustomFieldValueDisplayDao;
import org.squashtest.tm.service.internal.repository.display.MilestoneDisplayDao;
import org.squashtest.tm.service.internal.repository.display.TreeNodeCollector;
import org.squashtest.tm.service.internal.repository.display.impl.collectors.AbstractTreeNodeCollector;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;

@Component
public class TestCaseCollector
extends AbstractTreeNodeCollector
implements TreeNodeCollector {
    public TestCaseCollector(DSLContext dsl, CustomFieldValueDisplayDao customFieldValueDisplayDao, ActiveMilestoneHolder activeMilestoneHolder, MilestoneDisplayDao milestoneDisplayDao) {
        super(dsl, customFieldValueDisplayDao, activeMilestoneHolder, milestoneDisplayDao);
    }

    @Override
    protected Map<Long, DataRow> doCollect(List<Long> ids) {
        Map<Long, DataRow> testCaseRowsByIds = this.collectTestCaseRows(ids);
        this.appendTestCaseMilestones(testCaseRowsByIds);
        return testCaseRowsByIds;
    }

    private Map<Long, DataRow> collectTestCaseRows(List<Long> ids) {
        return this.dsl.select((SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, (SelectField)Tables.TEST_CASE_LIBRARY_NODE.NAME.as("NAME"), (SelectField)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.as("projectId"), (SelectField)Tables.TEST_CASE.IMPORTANCE, (SelectField)Tables.TEST_CASE.REFERENCE, (SelectField)Tables.TEST_CASE.TC_STATUS, (SelectField)Tables.SCRIPTED_TEST_CASE.TCLN_ID.as("SCRIPTED_TEST_CASE_ID"), (SelectField)Tables.KEYWORD_TEST_CASE.TCLN_ID.as("KEYWORD_TEST_CASE_ID"), (SelectField)Tables.EXPLORATORY_TEST_CASE.TCLN_ID.as("EXPLORATORY_TEST_CASE_ID"), (SelectField)Tables.INFO_LIST_ITEM.ICON_NAME.as("TC_NATURE_ICON"), (SelectField)Tables.INFO_LIST_ITEM.LABEL.as("TC_NATURE_LABEL"), (SelectField)Tables.INFO_LIST_ITEM.ITEM_TYPE.as("TC_NATURE_TYPE"), (SelectField)DSL.countDistinct((Field)Tables.TEST_CASE_STEPS.STEP_ID).as("STEP_COUNT"), (SelectField)DSL.countDistinct((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID).as("COVERAGE_COUNT")).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).innerJoin((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).innerJoin((TableLike)Tables.INFO_LIST_ITEM).on(Tables.TEST_CASE.TC_NATURE.eq((Field)Tables.INFO_LIST_ITEM.ITEM_ID)).leftJoin((TableLike)Tables.SCRIPTED_TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.SCRIPTED_TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.KEYWORD_TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.KEYWORD_TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.EXPLORATORY_TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.EXPLORATORY_TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.TEST_CASE_STEPS).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_CASE_STEPS.TEST_CASE_ID)).leftJoin((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID)).where(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.in(ids)).groupBy(new GroupField[]{Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, Tables.TEST_CASE.TCLN_ID, Tables.SCRIPTED_TEST_CASE.TCLN_ID, Tables.KEYWORD_TEST_CASE.TCLN_ID, Tables.EXPLORATORY_TEST_CASE.TCLN_ID, Tables.INFO_LIST_ITEM.ITEM_ID}).fetch().stream().collect(Collectors.toMap(record -> (Long)record.get((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID), record -> {
            DataRow dataRow = new DataRow();
            dataRow.setId(new NodeReference(NodeType.TEST_CASE, (Long)record.get((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).toNodeId());
            dataRow.setProjectId((Long)record.get("projectId", Long.class));
            Map data = record.intoMap();
            data.put("TC_KIND", TestCaseKind.fromLeftJoinIds((Long)((Long)record.get("SCRIPTED_TEST_CASE_ID", Long.class)), (Long)((Long)record.get("KEYWORD_TEST_CASE_ID", Long.class)), (Long)((Long)record.get("EXPLORATORY_TEST_CASE_ID", Long.class))));
            dataRow.setData(data);
            if (!Strings.isNullOrEmpty((String)((String)record.get((Field)Tables.TEST_CASE.REFERENCE, String.class)))) {
                dataRow.getData().replace("NAME", (String)record.get((Field)Tables.TEST_CASE.REFERENCE) + " - " + (String)record.get((Field)Tables.TEST_CASE_LIBRARY_NODE.NAME));
            }
            return dataRow;
        }));
    }

    private void appendTestCaseMilestones(Map<Long, DataRow> testCaseRowsByIds) {
        Optional<Milestone> activeMilestone = this.activeMilestoneHolder.getActiveMilestone();
        if (activeMilestone.isPresent()) {
            Multimap<Long, Long> milestoneByTestCaseId = this.milestoneDisplayDao.findMilestonesByTestCaseId(testCaseRowsByIds.keySet());
            testCaseRowsByIds.forEach((testCaseId, dataRow) -> dataRow.addData("MILESTONES", milestoneByTestCaseId.get(testCaseId)));
        }
    }

    @Override
    public NodeType getHandledEntityType() {
        return NodeType.TEST_CASE;
    }
}

