/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.dto.json;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.service.internal.dto.CustomFieldBindingModel;
import org.squashtest.tm.service.internal.dto.json.JsonInfoList;
import org.squashtest.tm.service.internal.dto.json.JsonMilestone;

public class JsonProject {
    private long id;
    private String uri;
    private String name;
    private Map<String, List<CustomFieldBindingModel>> customFieldBindings;
    private Set<JsonMilestone> milestones;
    private JsonInfoList requirementCategories;
    private JsonInfoList testCaseNatures;
    private JsonInfoList testCaseTypes;

    private JsonProject() {
    }

    public JsonProject(Long id, String name) {
        this.id = id;
        this.uri = "/projects/" + String.valueOf(id);
        this.name = name;
    }

    public static JsonProject toJson(Project project) {
        JsonProject res = new JsonProject();
        res.id = project.getId();
        res.uri = "/projects/" + res.id;
        res.name = HtmlUtils.htmlUnescape((String)project.getName());
        return res;
    }

    public long getId() {
        return this.id;
    }

    public String getUri() {
        return this.uri;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, List<CustomFieldBindingModel>> getCustomFieldBindings() {
        return this.customFieldBindings;
    }

    public JsonInfoList getRequirementCategories() {
        return this.requirementCategories;
    }

    public JsonInfoList getTestCaseNatures() {
        return this.testCaseNatures;
    }

    public JsonInfoList getTestCaseTypes() {
        return this.testCaseTypes;
    }

    public void setCustomFieldBindings(Map<String, List<CustomFieldBindingModel>> customFieldBindings) {
        this.customFieldBindings = customFieldBindings;
    }

    public void addCustomFieldBindingModel(CustomFieldBindingModel customFieldBindingModel) {
        String boundEntity = customFieldBindingModel.getBoundEntity().getEnumName();
        if (this.customFieldBindings.containsKey(boundEntity)) {
            this.customFieldBindings.get(boundEntity).add(customFieldBindingModel);
        } else {
            ArrayList<CustomFieldBindingModel> models = new ArrayList<CustomFieldBindingModel>();
            models.add(customFieldBindingModel);
            this.customFieldBindings.put(boundEntity, models);
        }
    }

    public void setRequirementCategories(JsonInfoList requirementCategories) {
        this.requirementCategories = requirementCategories;
    }

    public void setTestCaseNatures(JsonInfoList testCaseNatures) {
        this.testCaseNatures = testCaseNatures;
    }

    public void setTestCaseTypes(JsonInfoList testCaseTypes) {
        this.testCaseTypes = testCaseTypes;
    }

    public Set<JsonMilestone> getMilestones() {
        return this.milestones;
    }

    public void setMilestones(Set<JsonMilestone> milestones) {
        this.milestones = milestones;
    }
}

