/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.search;

import com.google.common.collect.ImmutableList;
import jakarta.persistence.EntityManager;
import java.util.List;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record2;
import org.jooq.Result;
import org.jooq.SelectField;
import org.jooq.SortField;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.query.NaturalJoinStyle;
import org.squashtest.tm.domain.query.QueryModel;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.records.ProjectRecord;
import org.squashtest.tm.service.display.search.CampaignSearchService;
import org.squashtest.tm.service.display.search.ResearchResult;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridSort;
import org.squashtest.tm.service.internal.display.search.AbstractSearchService;
import org.squashtest.tm.service.internal.display.search.filter.FilterHandlers;
import org.squashtest.tm.service.internal.display.search.filter.FilterValueHandlers;
import org.squashtest.tm.service.internal.repository.ColumnPrototypeDao;
import org.squashtest.tm.service.internal.repository.CustomItpiLastExecutionFilterDao;
import org.squashtest.tm.service.project.ProjectFinder;
import org.squashtest.tm.service.query.QueryProcessingService;

@Service
@Transactional(readOnly=true)
public class CampaignSearchServiceImpl
extends AbstractSearchService
implements CampaignSearchService {
    private final CustomItpiLastExecutionFilterDao customItpiLastExecutionFilterDao;
    private final DSLContext dslContext;

    public CampaignSearchServiceImpl(QueryProcessingService queryService, ColumnPrototypeDao columnPrototypeDao, EntityManager entityManager, ProjectFinder projectFinder, FilterHandlers filterHandlers, FilterValueHandlers gridFilterValueHandlers, CustomItpiLastExecutionFilterDao customItpiLastExecutionFilterDao, DSLContext dslContext) {
        super(queryService, columnPrototypeDao, entityManager, projectFinder, filterHandlers, gridFilterValueHandlers, dslContext);
        this.customItpiLastExecutionFilterDao = customItpiLastExecutionFilterDao;
        this.dslContext = dslContext;
    }

    @Override
    protected QueryModel prepareBaseQuery(GridRequest request) {
        QueryModel queryModel = super.prepareBaseQuery(request);
        queryModel.setJoinStyle(NaturalJoinStyle.LEFT_JOIN);
        return queryModel;
    }

    @Override
    protected List<String> getIdentifierColumnName() {
        return ImmutableList.of((Object)"ITEM_TEST_PLAN_ID", (Object)"ITERATION_ID", (Object)"CAMPAIGN_ID");
    }

    @Override
    protected String getDefaultSortColumnName() {
        return "ITEM_TEST_PLAN_ID";
    }

    @Override
    public ResearchResult search(GridRequest gridRequest) {
        if (this.shouldSearchForLastExecutedScope(gridRequest)) {
            return this.searchForLastExecutedScope(gridRequest);
        }
        return super.search(gridRequest);
    }

    private boolean shouldSearchForLastExecutedScope(GridRequest gridRequest) {
        return gridRequest.getFilterValues().stream().anyMatch(filter -> filter.getValues().contains("LAST_EXECUTED"));
    }

    private ResearchResult searchForLastExecutedScope(GridRequest gridRequest) {
        this.assertCurrentUserHasPermissionToSearch();
        Table<?> rankedIds = this.customItpiLastExecutionFilterDao.getTableForTCInDynamicScope(gridRequest);
        Field totalCountField = DSL.count().over().cast(Long.class).as("ITERATION_COUNT");
        Field latestExecutionIdField = rankedIds.field("LATEST_EXECUTION_ID", Long.class);
        int pageSize = gridRequest.getSize();
        int offset = gridRequest.getPage() != null && pageSize > 0 ? gridRequest.getPage() * pageSize : 0;
        List<? extends SortField<?>> sortFields = this.fieldTestCaseSearchSorts(rankedIds, gridRequest);
        Result result = this.dslContext.select((SelectField)latestExecutionIdField, (SelectField)totalCountField).from(rankedIds).orderBy(sortFields).limit((Number)offset, (Number)pageSize).fetch();
        List itemIds = result.getValues(latestExecutionIdField);
        Long totalCount = result.isEmpty() ? Long.valueOf(0L) : (Long)((Record2)result.get(0)).get(totalCountField);
        return new ResearchResult(itemIds, totalCount);
    }

    @Override
    protected EntityType getLibraryEntityType() {
        return EntityType.CAMPAIGN_LIBRARY;
    }

    @Override
    protected TableField<ProjectRecord, Long> getLibraryIdField() {
        return Tables.PROJECT.CL_ID;
    }

    private List<? extends SortField<?>> fieldTestCaseSearchSorts(Table<?> rankedIds, GridRequest request) {
        return request.getSort().stream().map(sort -> this.customItpiLastExecutionFilterDao.convertGridSortToOrderBy(rankedIds, (GridSort)sort)).toList();
    }
}

