/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion;

import com.google.common.collect.Lists;
import jakarta.persistence.EntityManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jooq.CommonTableExpression;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Component;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.attachment.ExternalContentCoordinates;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.campaign.CampaignFolder;
import org.squashtest.tm.domain.campaign.CampaignLibraryNode;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldHolder;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender;
import org.squashtest.tm.domain.testautomation.FailureDetail;
import org.squashtest.tm.domain.testautomation.TestAutomationServerKind;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.annotation.SpringDaoMetaAnnotationAspect;
import org.squashtest.tm.service.attachment.AttachmentManagerService;
import org.squashtest.tm.service.audit.AuditModificationService;
import org.squashtest.tm.service.campaign.CustomTestSuiteModificationService;
import org.squashtest.tm.service.deletion.OperationReport;
import org.squashtest.tm.service.deletion.SuppressionPreviewReport;
import org.squashtest.tm.service.denormalizedenvironment.DenormalizedEnvironmentTagManagerService;
import org.squashtest.tm.service.denormalizedenvironment.DenormalizedEnvironmentVariableManagerService;
import org.squashtest.tm.service.internal.campaign.CampaignNodeDeletionHandler;
import org.squashtest.tm.service.internal.campaign.LockedCampaignNodeDetectionService;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueService;
import org.squashtest.tm.service.internal.deletion.AbstractNodeDeletionHandler;
import org.squashtest.tm.service.internal.deletion.CampaignDeletionHandlerImpl$AjcClosure1;
import org.squashtest.tm.service.internal.deletion.jdbc.JdbcCampaignDeletionHandlerFactory;
import org.squashtest.tm.service.internal.deletion.jdbc.JdbcExecutionDeletionHandlerFactory;
import org.squashtest.tm.service.internal.deletion.jdbc.JdbcIterationDeletionHandlerFactory;
import org.squashtest.tm.service.internal.deletion.jdbc.JdbcTestPlanItemDeletionHandlerFactory;
import org.squashtest.tm.service.internal.denormalizedfield.PrivateDenormalizedFieldValueService;
import org.squashtest.tm.service.internal.repository.AutomatedExecutionExtenderDao;
import org.squashtest.tm.service.internal.repository.AutomatedSuiteDao;
import org.squashtest.tm.service.internal.repository.AutomatedTestDao;
import org.squashtest.tm.service.internal.repository.CampaignDeletionDao;
import org.squashtest.tm.service.internal.repository.CampaignFolderDao;
import org.squashtest.tm.service.internal.repository.ExecutionDao;
import org.squashtest.tm.service.internal.repository.FailureDetailDao;
import org.squashtest.tm.service.internal.repository.FolderDao;
import org.squashtest.tm.service.internal.repository.IterationDao;
import org.squashtest.tm.service.internal.repository.IterationTestPlanDao;
import org.squashtest.tm.service.internal.repository.TestPlanItemDao;
import org.squashtest.tm.service.internal.repository.TestSuiteDao;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Component(value="squashtest.tm.service.deletion.CampaignNodeDeletionHandler")
public class CampaignDeletionHandlerImpl
extends AbstractNodeDeletionHandler<CampaignLibraryNode, CampaignFolder>
implements CampaignNodeDeletionHandler {
    public static final int BIND_VARIABLES_LIMIT = 25000;
    private final LockedCampaignNodeDetectionService lockedCampaignNodeDetectionService;
    private final CampaignFolderDao folderDao;
    private final CampaignDeletionDao deletionDao;
    private final TestSuiteDao suiteDao;
    private final IterationTestPlanDao iterationTestPlanDao;
    private final ExecutionDao executionDao;
    private final AutomatedTestDao autoTestDao;
    private final PrivateCustomFieldValueService customValueService;
    private final PrivateDenormalizedFieldValueService denormalizedFieldValueService;
    private final DenormalizedEnvironmentVariableManagerService denormalizedEnvironmentVariableManagerService;
    private final DenormalizedEnvironmentTagManagerService denormalizedEnvironmentTagManagerService;
    private final ActiveMilestoneHolder activeMilestoneHolder;
    private final CustomTestSuiteModificationService customTestSuiteModificationService;
    private final JdbcIterationDeletionHandlerFactory jdbcIterationDeletionHandlerFactory;
    private final JdbcCampaignDeletionHandlerFactory jdbcCampaignDeletionHandlerFactory;
    private final JdbcExecutionDeletionHandlerFactory jdbcExecutionDeletionHandler;
    private final DSLContext dslContext;
    private final AutomatedExecutionExtenderDao automatedExecutionExtenderDao;
    private final FailureDetailDao failureDetailDao;
    private final AutomatedSuiteDao autoSuiteDao;
    private final EntityManager entityManager;
    private final TestPlanItemDao testPlanItemDao;
    private final PermissionEvaluationService permissionEvaluationService;
    private final AuditModificationService auditModificationService;
    private final IterationDao iterationDao;
    private final JdbcTestPlanItemDeletionHandlerFactory testPlanItemDeletionHandler;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public CampaignDeletionHandlerImpl(LockedCampaignNodeDetectionService lockedCampaignNodeDetectionService, CampaignFolderDao folderDao, CampaignDeletionDao deletionDao, TestSuiteDao suiteDao, IterationTestPlanDao iterationTestPlanDao, ExecutionDao executionDao, AutomatedTestDao autoTestDao, PrivateCustomFieldValueService customValueService, PrivateDenormalizedFieldValueService denormalizedFieldValueService, DenormalizedEnvironmentVariableManagerService denormalizedEnvironmentVariableManagerService, DenormalizedEnvironmentTagManagerService denormalizedEnvironmentTagManagerService, ActiveMilestoneHolder activeMilestoneHolder, CustomTestSuiteModificationService customTestSuiteModificationService, JdbcIterationDeletionHandlerFactory jdbcIterationDeletionHandlerFactory, JdbcCampaignDeletionHandlerFactory jdbcCampaignDeletionHandlerFactory, JdbcExecutionDeletionHandlerFactory jdbcExecutionDeletionHandler, DSLContext dslContext, AutomatedExecutionExtenderDao automatedExecutionExtenderDao, FailureDetailDao failureDetailDao, AutomatedSuiteDao autoSuiteDao, EntityManager entityManager, AttachmentManagerService attachmentManager, TestPlanItemDao testPlanItemDao, PermissionEvaluationService permissionEvaluationService, AuditModificationService auditModificationService, IterationDao iterationDao, JdbcTestPlanItemDeletionHandlerFactory testPlanItemDeletionHandler) {
        super(attachmentManager);
        this.lockedCampaignNodeDetectionService = lockedCampaignNodeDetectionService;
        this.folderDao = folderDao;
        this.deletionDao = deletionDao;
        this.suiteDao = suiteDao;
        this.iterationTestPlanDao = iterationTestPlanDao;
        this.executionDao = executionDao;
        this.autoTestDao = autoTestDao;
        this.customValueService = customValueService;
        this.denormalizedFieldValueService = denormalizedFieldValueService;
        this.denormalizedEnvironmentVariableManagerService = denormalizedEnvironmentVariableManagerService;
        this.denormalizedEnvironmentTagManagerService = denormalizedEnvironmentTagManagerService;
        this.activeMilestoneHolder = activeMilestoneHolder;
        this.customTestSuiteModificationService = customTestSuiteModificationService;
        this.jdbcIterationDeletionHandlerFactory = jdbcIterationDeletionHandlerFactory;
        this.jdbcCampaignDeletionHandlerFactory = jdbcCampaignDeletionHandlerFactory;
        this.jdbcExecutionDeletionHandler = jdbcExecutionDeletionHandler;
        this.dslContext = dslContext;
        this.automatedExecutionExtenderDao = automatedExecutionExtenderDao;
        this.failureDetailDao = failureDetailDao;
        this.autoSuiteDao = autoSuiteDao;
        this.entityManager = entityManager;
        this.testPlanItemDao = testPlanItemDao;
        this.permissionEvaluationService = permissionEvaluationService;
        this.auditModificationService = auditModificationService;
        this.iterationDao = iterationDao;
        this.testPlanItemDeletionHandler = testPlanItemDeletionHandler;
    }

    @Override
    protected FolderDao<CampaignFolder, CampaignLibraryNode> getFolderDao() {
        return this.folderDao;
    }

    @Override
    protected List<SuppressionPreviewReport> diagnoseSuppression(List<Long> nodeIds) {
        ArrayList<SuppressionPreviewReport> reportList = new ArrayList<SuppressionPreviewReport>();
        reportList.addAll(this.lockedCampaignNodeDetectionService.detectLockedCampaigns(nodeIds));
        reportList.addAll(this.lockedCampaignNodeDetectionService.detectLockedSprints(nodeIds));
        reportList.addAll(this.lockedCampaignNodeDetectionService.detectLockedByMilestone(nodeIds));
        reportList.addAll(this.lockedCampaignNodeDetectionService.detectLockedWithActiveMilestone(nodeIds));
        return reportList;
    }

    @Override
    public List<SuppressionPreviewReport> simulateIterationDeletion(List<Long> targetIds) {
        ArrayList<SuppressionPreviewReport> reportList = new ArrayList<SuppressionPreviewReport>();
        reportList.addAll(this.lockedCampaignNodeDetectionService.detectLockedIteration(targetIds));
        reportList.addAll(this.lockedCampaignNodeDetectionService.detectLockedByMilestoneIteration(targetIds));
        return reportList;
    }

    @Override
    public List<SuppressionPreviewReport> simulateSuiteDeletion(List<Long> targetIds) {
        ArrayList<SuppressionPreviewReport> reportList = new ArrayList<SuppressionPreviewReport>();
        reportList.addAll(this.lockedCampaignNodeDetectionService.detectLockedSuites(targetIds));
        reportList.addAll(this.lockedCampaignNodeDetectionService.detectLockedByMilestoneTestSuite(targetIds));
        reportList.addAll(this.lockedCampaignNodeDetectionService.detectTestPlanItemBoundMultipleTestSuite(targetIds));
        return reportList;
    }

    @Override
    protected List<Long> detectLockedNodes(List<Long> nodeIds) {
        return this.diagnoseSuppression(nodeIds).stream().flatMap(report -> report.getLockedNodes().stream()).distinct().toList();
    }

    @Override
    protected OperationReport batchDeleteNodes(List<Long> ids) {
        return this.jdbcCampaignDeletionHandlerFactory.build(ids).delete();
    }

    @Override
    protected OperationReport batchUnbindFromMilestone(List<Long> ids) {
        List<Long> remainingIds = this.deletionDao.findRemainingCampaignIds(ids);
        List<Long> lockedIds = this.deletionDao.findCampaignsWhichMilestonesForbidsDeletion(remainingIds);
        remainingIds.removeAll(lockedIds);
        OperationReport report = new OperationReport();
        Optional<Milestone> activeMilestone = this.activeMilestoneHolder.getActiveMilestone();
        activeMilestone.ifPresent(milestone -> this.deletionDao.unbindFromMilestone(remainingIds, milestone.getId()));
        report.addRemoved(remainingIds, "campaign");
        return report;
    }

    @Override
    public OperationReport deleteIterations(List<Long> targetIds) {
        ArrayList<Long> iterationsToDelete = new ArrayList<Long>(targetIds.size());
        List lockedIds = this.simulateIterationDeletion(targetIds).stream().flatMap(report -> report.getLockedNodes().stream()).toList();
        iterationsToDelete.addAll(targetIds);
        iterationsToDelete.removeAll(lockedIds);
        this.doDeleteIterations(iterationsToDelete);
        OperationReport report2 = new OperationReport();
        report2.addRemoved(iterationsToDelete, "iteration");
        return report2;
    }

    private void doDeleteSuites(Collection<TestSuite> testSuites) {
        List<ExternalContentCoordinates> pairContentIDListIDS = testSuites.stream().flatMap(testSuite -> {
            testSuite.getTestPlanItems().forEach(testPlanItem -> testPlanItem.getTestSuites().clear());
            testSuite.getIteration().removeTestSuite(testSuite);
            return this.getExternalAttachmentContentCoordinatesOfObject((AttachmentHolder)testSuite).stream();
        }).toList();
        List<Long> testSuiteIds = testSuites.stream().map(TestSuite::getId).toList();
        this.customValueService.deleteAllCustomFieldValues(BindableEntity.TEST_SUITE, testSuiteIds);
        List attachmentListIds = this.suiteDao.findTestSuiteAttachmentListIds(testSuiteIds);
        List automatedSuitesIds = this.suiteDao.findTestSuitesAutomatedSuiteIds(testSuiteIds);
        this.deleteAutomatedSuites(automatedSuitesIds);
        this.suiteDao.removeTestSuites(testSuiteIds);
        this.attachmentManager.removeAttachmentsAndLists(attachmentListIds);
        this.attachmentManager.deleteContents(pairContentIDListIDS);
    }

    @Override
    public void deleteExecution(Execution execution) {
        List<ExternalContentCoordinates> pairContentIDListIDSteps = this.deleteExecSteps(execution);
        List<ExternalContentCoordinates> pairContentIDListIDExec = this.getExternalAttachmentContentCoordinatesOfObject((AttachmentHolder)execution);
        if (!pairContentIDListIDExec.isEmpty()) {
            pairContentIDListIDSteps.addAll(pairContentIDListIDExec);
        }
        Long projectId = execution.getProject().getId();
        this.deleteAutomatedExecutionExtenderAndDenormalizedEnvironments(execution, projectId);
        this.denormalizedFieldValueService.deleteAllDenormalizedFieldValues((DenormalizedFieldHolder)execution);
        this.customValueService.deleteAllCustomFieldValues((BoundEntity)execution);
        TestPlanItem testPlanItem = execution.getTestPlanItem();
        testPlanItem.removeExecutionsById(Collections.singletonList(execution.getId()));
        this.entityManager.flush();
        testPlanItem.reorderExecutions();
        this.customTestSuiteModificationService.updateExecutionStatus(testPlanItem.getTestSuites());
        this.attachmentManager.deleteContents(pairContentIDListIDSteps);
    }

    @Override
    public void deleteAutomatedSuites(List<Long> automatedSuiteIds) {
        this.processAutomatedSuitesDeletion(automatedSuiteIds);
    }

    private void processAutomatedSuitesDeletion(List<Long> automatedSuiteIds) {
        List<Long> list = automatedSuiteIds;
        ExecutionDao executionDao = this.executionDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)executionDao, list);
        Object[] objectArray = new Object[]{this, executionDao, list, joinPoint};
        CampaignDeletionHandlerImpl$AjcClosure1 campaignDeletionHandlerImpl$AjcClosure1 = new CampaignDeletionHandlerImpl$AjcClosure1(objectArray);
        List executionIds = (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(campaignDeletionHandlerImpl$AjcClosure1.linkClosureAndJoinPoint(4112));
        if (!executionIds.isEmpty()) {
            this.bulkDeleteExecutions(executionIds);
        }
        List<Long> attachmentListIds = this.autoSuiteDao.findAttachmentListIdsByIds(automatedSuiteIds);
        List<ExternalContentCoordinates> externalContentCoordinates = this.attachmentManager.getListPairContentIDListIDForAutomatedSuiteIds(automatedSuiteIds);
        this.autoSuiteDao.deleteAutomatedSuiteWorkflowsBySuiteIds(automatedSuiteIds);
        this.autoSuiteDao.deleteAllByIds(automatedSuiteIds);
        this.autoTestDao.pruneOrphans();
        this.attachmentManager.removeAttachmentsAndLists(attachmentListIds);
        this.attachmentManager.deleteContents(externalContentCoordinates);
    }

    private void deleteDenormalizedEnvironments(Execution execution, Long projectId) {
        if (this.isExecutedByAutomServer(projectId)) {
            this.denormalizedEnvironmentVariableManagerService.removeDenormalizedEnvironmentVariablesOnExecutionDelete(execution.getAutomatedExecutionExtender());
            this.denormalizedEnvironmentTagManagerService.removeDenormalizedTagsOnExecutionDelete(execution.getAutomatedExecutionExtender());
            this.entityManager.flush();
        }
    }

    private boolean isExecutedByAutomServer(Long projectId) {
        TestAutomationServerKind serverKind = this.executionDao.getTestAutomationServerKindByProjectId(projectId);
        return Objects.nonNull(serverKind) && TestAutomationServerKind.squashOrchestrator.equals((Object)serverKind);
    }

    @Override
    public void bulkDeleteExecutions(List<Long> executionIds) {
        List executionIdPartitions = Lists.partition(executionIds, (int)25000);
        HashSet testSuiteIds = new HashSet();
        executionIdPartitions.forEach(executionIdPartition -> {
            testSuiteIds.addAll(this.suiteDao.findAllIdsByExecutionIds((List)executionIdPartition));
            List itpiIds = this.executionDao.findItpiIdsByExecutionIds(executionIds);
            this.jdbcExecutionDeletionHandler.build(executionIds).deleteExecutions();
            this.batchUpdateItpiExecutionStatusAfterExecutionsDeletion(itpiIds);
            this.entityManager.flush();
        });
        List testSuites = this.suiteDao.findAllByIds(testSuiteIds);
        this.customTestSuiteModificationService.updateExecutionStatus(testSuites);
        this.entityManager.clear();
    }

    private void doDeleteIterations(List<Long> iterations) {
        if (!iterations.isEmpty()) {
            this.jdbcIterationDeletionHandlerFactory.build(iterations).deleteIterations();
        }
    }

    @Override
    public void deleteTestPlanItem(TestPlanItem item) {
        ArrayList<FailureDetail> failureDetails = new ArrayList<FailureDetail>(item.getFailureDetailList());
        this.deleteFailureDetails(failureDetails);
        item.getFailureDetailList().clear();
        ArrayList<Execution> execs = new ArrayList<Execution>(item.getExecutions());
        this.deleteExecutions(execs);
        this.deletionDao.removeEntity(item);
    }

    @Override
    public void deleteExecutions(List<Execution> executions) {
        ArrayList<Execution> executionsCopy = new ArrayList<Execution>(executions);
        for (Execution execution : executionsCopy) {
            this.deleteExecution(execution);
        }
    }

    @Override
    public void deleteFailureDetail(FailureDetail failureDetail) {
        List extenders = failureDetail.getAutomatedExecutions();
        for (AutomatedExecutionExtender extender : extenders) {
            extender.getFailureDetailList().remove(failureDetail);
            this.automatedExecutionExtenderDao.save(extender);
        }
        failureDetail.getAutomatedExecutions().clear();
        this.failureDetailDao.save(failureDetail);
        this.deletionDao.removeEntity(failureDetail);
    }

    @Override
    public void deleteFailureDetails(List<FailureDetail> failureDetails) {
        ArrayList<FailureDetail> failureDetailsCopy = new ArrayList<FailureDetail>(failureDetails);
        for (FailureDetail failureDetail : failureDetailsCopy) {
            this.deleteFailureDetail(failureDetail);
        }
    }

    private List<ExternalContentCoordinates> deleteExecSteps(Execution execution) {
        ArrayList<ExecutionStep> steps = new ArrayList<ExecutionStep>(execution.getSteps());
        execution.getSteps().clear();
        List<Object> pairContentIDListID = !steps.isEmpty() ? this.attachmentManager.getListPairContentIDListIDForExecutionSteps(steps) : new ArrayList();
        for (ExecutionStep step : steps) {
            this.denormalizedFieldValueService.deleteAllDenormalizedFieldValues((DenormalizedFieldHolder)step);
            this.customValueService.deleteAllCustomFieldValues((BoundEntity)step);
            this.deletionDao.removeEntity(step);
        }
        return pairContentIDListID;
    }

    private void deleteAutomatedExecutionExtenderAndDenormalizedEnvironments(Execution execution, Long projectId) {
        if (execution.getAutomatedExecutionExtender() == null) {
            return;
        }
        AutomatedExecutionExtender extender = execution.getAutomatedExecutionExtender();
        this.removeExtenderAssociationFromFailureDetails(extender);
        this.deleteDenormalizedEnvironments(execution, projectId);
        this.autoTestDao.removeIfUnused(extender.getAutomatedTest());
        this.deletionDao.removeEntity(extender);
        execution.setAutomatedExecutionExtender(null);
    }

    private void removeExtenderAssociationFromFailureDetails(AutomatedExecutionExtender extender) {
        List failureDetails = extender.getFailureDetailList();
        for (FailureDetail failureDetail : failureDetails) {
            failureDetail.getAutomatedExecutions().remove(extender);
            this.failureDetailDao.save(failureDetail);
        }
    }

    @Override
    public OperationReport deleteSuites(List<Long> suiteIds, boolean removeFromIter) {
        List<Long> testPlanItemIds;
        ArrayList<Long> suiteToDelete = new ArrayList<Long>(suiteIds.size());
        List lockedIds = this.simulateSuiteDeletion(suiteIds).stream().flatMap(report -> report.getLockedNodes().stream()).toList();
        suiteToDelete.addAll(suiteIds);
        suiteToDelete.removeAll(lockedIds);
        if (removeFromIter && !(testPlanItemIds = this.iterationTestPlanDao.findTestPlanItemsToRemoveInDeleteTestSuite(suiteToDelete, suiteIds)).isEmpty()) {
            Long iterationId = this.suiteDao.findIterationIdByTestSuiteId((Long)suiteToDelete.get(0));
            this.removeTestPlanItemsFromIteration(testPlanItemIds, iterationId);
        }
        List suitesToDelete = this.suiteDao.findAllByIds(suiteToDelete);
        this.doDeleteSuites(suitesToDelete);
        OperationReport report2 = new OperationReport();
        if (!suitesToDelete.isEmpty()) {
            report2.addRemoved(suiteIds, "test-suite");
        }
        return report2;
    }

    @Override
    protected boolean isMilestoneMode() {
        return this.activeMilestoneHolder.getActiveMilestone().isPresent();
    }

    private void batchUpdateItpiExecutionStatusAfterExecutionsDeletion(List<Long> iterationTestPlanItemIds) {
        CommonTableExpression cte = DSL.name((String)"cte").fields("TEST_PLAN_ITEM_ID", "EXECUTION_STATUS", "POSITION").as((ResultQuery)DSL.select((SelectField)Tables.EXECUTION.TEST_PLAN_ITEM_ID, (SelectField)Tables.EXECUTION.EXECUTION_STATUS, (SelectField)DSL.rowNumber().over().partitionBy(new GroupField[]{Tables.EXECUTION.TEST_PLAN_ITEM_ID}).orderBy(new OrderField[]{Tables.EXECUTION.EXECUTION_ORDER.desc()})).from((TableLike)Tables.EXECUTION).where(Tables.EXECUTION.TEST_PLAN_ITEM_ID.in(iterationTestPlanItemIds)));
        Map itemTestPlanIdsByExecutionStatus = this.dslContext.with(new CommonTableExpression[]{cte}).select((SelectField)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, (SelectField)DSL.when((Condition)cte.field("EXECUTION_STATUS").isNull(), (Object)ExecutionStatus.READY.name()).otherwise(cte.field("EXECUTION_STATUS", String.class)).as("EXECUTION_STATUS")).from((TableLike)Tables.TEST_PLAN_ITEM).leftJoin((TableLike)cte).on(cte.field("TEST_PLAN_ITEM_ID", Long.class).eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).where(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.in(iterationTestPlanItemIds).and(cte.field("POSITION", Integer.class).eq((Object)1).or(cte.field("TEST_PLAN_ITEM_ID", Integer.class).isNull().and(Tables.TEST_PLAN_ITEM.EXECUTION_STATUS.notEqual((Object)ExecutionStatus.READY.name()))))).fetchGroups(DSL.field((String)"EXECUTION_STATUS", String.class), (Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID);
        org.squashtest.tm.jooq.domain.tables.Execution execution2 = Tables.EXECUTION.as("e2");
        Condition compareByOrderAndId = execution2.EXECUTION_ORDER.lessThan((Field)Tables.EXECUTION.EXECUTION_ORDER).or(execution2.EXECUTION_ORDER.eq((Field)Tables.EXECUTION.EXECUTION_ORDER).and(execution2.EXECUTION_ID.lessOrEqual((Field)Tables.EXECUTION.EXECUTION_ID)));
        this.dslContext.update((Table)Tables.EXECUTION).set((Field)Tables.EXECUTION.EXECUTION_ORDER, (Select)DSL.select((SelectField)DSL.count().minus((Number)1)).from((TableLike)execution2).where(execution2.TEST_PLAN_ITEM_ID.eq((Field)Tables.EXECUTION.TEST_PLAN_ITEM_ID).and(compareByOrderAndId))).where(Tables.EXECUTION.TEST_PLAN_ITEM_ID.in(iterationTestPlanItemIds)).execute();
        for (Map.Entry entry : itemTestPlanIdsByExecutionStatus.entrySet()) {
            this.dslContext.update((Table)Tables.TEST_PLAN_ITEM).set((Field)Tables.TEST_PLAN_ITEM.EXECUTION_STATUS, (Object)((String)entry.getKey())).where(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.in((Collection)entry.getValue())).execute();
        }
    }

    @Override
    public boolean removeTestPlanItemsFromIteration(List<Long> testPlanItemsIds, long iterationId) {
        List<Long> authorizedTestPlanItemIds = this.filterPermittedTestPlanItemIds(testPlanItemsIds);
        this.testPlanItemDeletionHandler.build(authorizedTestPlanItemIds).deleteTestPlanItems();
        Iteration it = (Iteration)this.iterationDao.findById(iterationId);
        this.auditModificationService.updateAuditable((AuditableMixin)it);
        return testPlanItemsIds.size() != authorizedTestPlanItemIds.size();
    }

    @Override
    public void removeTestPlanItems(Collection<Long> testPlanItemsIds) {
        List<Long> authorizedTestPlanItemIds = this.filterPermittedTestPlanItemIds(testPlanItemsIds);
        this.testPlanItemDeletionHandler.build(authorizedTestPlanItemIds).deleteTestPlanItems();
    }

    private List<Long> filterPermittedTestPlanItemIds(Collection<Long> testPlanItemIds) {
        List<Long> testPlanItemIdsWithExecution = this.testPlanItemDao.filterItemsWithExecutions(testPlanItemIds);
        ArrayList<Long> authorizedTestPlanItemIds = new ArrayList<Long>();
        for (Long testPlanItemId : testPlanItemIds) {
            Permissions permissionToCheck;
            Permissions permissions = permissionToCheck = testPlanItemIdsWithExecution.contains(testPlanItemId) ? Permissions.EXTENDED_DELETE : Permissions.DELETE;
            if (!this.permissionEvaluationService.hasRoleOrPermissionOnObject("ROLE_ADMIN", permissionToCheck.name(), testPlanItemId, TestPlanItem.class.getName())) continue;
            authorizedTestPlanItemIds.add(testPlanItemId);
        }
        return authorizedTestPlanItemIds;
    }

    static {
        CampaignDeletionHandlerImpl.ajc$preClinit();
    }

    static final /* synthetic */ List findAllIdsByAutomatedSuiteIds_aroundBody0(CampaignDeletionHandlerImpl campaignDeletionHandlerImpl, ExecutionDao executionDao, List list, JoinPoint joinPoint) {
        return executionDao.findAllIdsByAutomatedSuiteIds(list);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("CampaignDeletionHandlerImpl.java", CampaignDeletionHandlerImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "findAllIdsByAutomatedSuiteIds", "org.squashtest.tm.service.internal.repository.ExecutionDao", "java.util.List", "arg0", "", "java.util.List"), 326);
    }
}

