/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.clipboard;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.NodeReference;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.domain.Referenceable;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.CampaignFolder;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.SprintGroup;
import org.squashtest.tm.domain.customreport.CustomReportLibraryNode;
import org.squashtest.tm.domain.library.NodeContainer;
import org.squashtest.tm.domain.library.TreeNode;
import org.squashtest.tm.domain.requirement.HighLevelRequirement;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementFolder;
import org.squashtest.tm.domain.testcase.TestCaseFolder;
import org.squashtest.tm.service.clipboard.ClipboardService;
import org.squashtest.tm.service.customreport.CustomReportLibraryNodeService;

@Service
public class ClipboardServiceImpl
implements ClipboardService {
    @PersistenceContext
    private EntityManager entityManager;
    private final CustomReportLibraryNodeService customReportLibraryNodeService;

    public ClipboardServiceImpl(CustomReportLibraryNodeService customReportLibraryNodeService) {
        this.customReportLibraryNodeService = customReportLibraryNodeService;
    }

    @Override
    public List<NodeReference> copyNodes(@RequestBody List<NodeReference> sourceNodeList) {
        ArrayList<NodeReference> childrenList = new ArrayList<NodeReference>();
        sourceNodeList.forEach(nodeReference -> this.extractContent((NodeReference)nodeReference, (List<NodeReference>)childrenList));
        return childrenList;
    }

    private void extractContent(NodeReference nodeReference, List<NodeReference> childrenList) {
        switch (nodeReference.getNodeType()) {
            case CAMPAIGN_FOLDER: {
                CampaignFolder campaignFolder = (CampaignFolder)this.entityManager.find(CampaignFolder.class, (Object)nodeReference.getId());
                this.processChildren((NodeContainer)campaignFolder, childrenList);
                break;
            }
            case CAMPAIGN: {
                Campaign campaign = (Campaign)this.entityManager.find(Campaign.class, (Object)nodeReference.getId());
                this.processChildren((NodeContainer)campaign, childrenList);
                break;
            }
            case SPRINT_GROUP: {
                SprintGroup sprintGroup = (SprintGroup)this.entityManager.find(SprintGroup.class, (Object)nodeReference.getId());
                this.processChildren((NodeContainer)sprintGroup, childrenList);
                break;
            }
            case ITERATION: {
                Iteration iteration = (Iteration)this.entityManager.find(Iteration.class, (Object)nodeReference.getId());
                this.processChildren((NodeContainer)iteration, childrenList);
                break;
            }
            case TEST_CASE_FOLDER: {
                TestCaseFolder testCaseFolder = (TestCaseFolder)this.entityManager.find(TestCaseFolder.class, (Object)nodeReference.getId());
                this.processChildren((NodeContainer)testCaseFolder, childrenList);
                break;
            }
            case REQUIREMENT_FOLDER: {
                RequirementFolder requirementFolder = (RequirementFolder)this.entityManager.find(RequirementFolder.class, (Object)nodeReference.getId());
                this.processChildren((NodeContainer)requirementFolder, childrenList);
                break;
            }
            case REQUIREMENT: {
                Requirement requirement = (Requirement)this.entityManager.find(Requirement.class, (Object)nodeReference.getId());
                this.processChildren((NodeContainer)requirement, childrenList);
                break;
            }
            case HIGH_LEVEL_REQUIREMENT: {
                HighLevelRequirement highLevelRequirement = (HighLevelRequirement)this.entityManager.find(HighLevelRequirement.class, (Object)nodeReference.getId());
                this.processChildren((NodeContainer)highLevelRequirement, childrenList);
                break;
            }
            case CUSTOM_REPORT_FOLDER: {
                this.processCustomReportLibraryNode(nodeReference, childrenList);
                break;
            }
            case TEST_CASE: 
            case TEST_SUITE: 
            case SPRINT: 
            case CHART_DEFINITION: 
            case CUSTOM_REPORT_CUSTOM_EXPORT: 
            case CUSTOM_REPORT_DASHBOARD: 
            case REPORT_DEFINITION: 
            case ACTION_WORD: {
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("This type '%s' is not handled", nodeReference.getNodeType()));
            }
        }
    }

    private void processCustomReportLibraryNode(NodeReference nodeReference, List<NodeReference> childrenList) {
        CustomReportLibraryNode customReportLibraryNode = (CustomReportLibraryNode)this.entityManager.find(CustomReportLibraryNode.class, (Object)nodeReference.getId());
        List<Long> nodeChildren = this.customReportLibraryNodeService.findAllFirstLevelDescendantIds(Collections.singletonList(customReportLibraryNode.getId()));
        for (Long nodeChild : nodeChildren) {
            NodeReference childNodeReference = new NodeReference(NodeType.CUSTOM_REPORT_FOLDER, nodeChild);
            childrenList.add(childNodeReference);
            this.extractContent(childNodeReference, childrenList);
        }
    }

    private <NODE extends TreeNode> void processChildren(NodeContainer<NODE> nodeContainer, List<NodeReference> childrenList) {
        Collection nodeChildren = nodeContainer.getOrderedContent();
        for (TreeNode nodeChild : nodeChildren) {
            EntityReference ref = ((Referenceable)nodeChild).toEntityReference();
            NodeReference childNodeReference = ref.toNodeReference();
            childrenList.add(childNodeReference);
            this.extractContent(childNodeReference, childrenList);
        }
    }
}

