/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign;

import com.google.common.collect.Lists;
import jakarta.persistence.EntityManager;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldHolder;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender;
import org.squashtest.tm.domain.testautomation.AutomatedSuite;
import org.squashtest.tm.domain.testautomation.AutomatedTestTechnology;
import org.squashtest.tm.domain.testcase.CreateExecutionFromTestCaseVisitor;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseVisitor;
import org.squashtest.tm.exception.execution.TestPlanItemNotExecutableException;
import org.squashtest.tm.service.attachment.AttachmentManagerService;
import org.squashtest.tm.service.campaign.AutomatedExecutionCreationService;
import org.squashtest.tm.service.denormalizedenvironment.DenormalizedEnvironmentTagManagerService;
import org.squashtest.tm.service.denormalizedenvironment.DenormalizedEnvironmentVariableManagerService;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueService;
import org.squashtest.tm.service.internal.denormalizedfield.PrivateDenormalizedFieldValueService;
import org.squashtest.tm.service.internal.repository.ExecutionDao;
import org.squashtest.tm.service.internal.repository.IterationTestPlanDao;
import org.squashtest.tm.service.internal.repository.ProjectDao;
import org.squashtest.tm.service.internal.repository.hibernate.utils.HibernateConfig;
import org.squashtest.tm.service.testautomation.model.EnvironmentVariableValue;
import org.squashtest.tm.service.testautomation.model.SquashAutomExecutionConfiguration;

@Service
@Transactional
public class AutomatedExecutionCreationServiceImpl
implements AutomatedExecutionCreationService {
    private final PrivateCustomFieldValueService customFieldValuesService;
    private final ExecutionDao executionDao;
    private final PrivateDenormalizedFieldValueService denormalizedFieldValueService;
    private final AttachmentManagerService attachmentManagerService;
    private final IterationTestPlanDao iterationTestPlanDao;
    private final DenormalizedEnvironmentVariableManagerService denormalizedEnvironmentVariableManagerService;
    private final DenormalizedEnvironmentTagManagerService denormalizedEnvironmentTagManagerService;
    private final ProjectDao projectDao;
    private final EntityManager entityManager;

    public AutomatedExecutionCreationServiceImpl(PrivateCustomFieldValueService customFieldValuesService, ExecutionDao executionDao, PrivateDenormalizedFieldValueService denormalizedFieldValueService, AttachmentManagerService attachmentManagerService, IterationTestPlanDao iterationTestPlanDao, DenormalizedEnvironmentVariableManagerService denormalizedEnvironmentVariableManagerService, DenormalizedEnvironmentTagManagerService denormalizedEnvironmentTagManagerService, ProjectDao projectDao, EntityManager entityManager) {
        this.customFieldValuesService = customFieldValuesService;
        this.executionDao = executionDao;
        this.denormalizedFieldValueService = denormalizedFieldValueService;
        this.attachmentManagerService = attachmentManagerService;
        this.iterationTestPlanDao = iterationTestPlanDao;
        this.denormalizedEnvironmentVariableManagerService = denormalizedEnvironmentVariableManagerService;
        this.denormalizedEnvironmentTagManagerService = denormalizedEnvironmentTagManagerService;
        this.projectDao = projectDao;
        this.entityManager = entityManager;
    }

    @Override
    public void createAutomatedExecutions(AutomatedSuite automatedSuite, List<Long> testPlanItemIds, Long projectId) {
        HibernateConfig.enableBatch(this.entityManager, 20);
        Project project = this.projectDao.fetchForAutomatedExecutionCreation(projectId);
        Lists.partition(testPlanItemIds, (int)20).forEach(batch -> {
            List<TestPlanItem> testPlanItems = this.iterationTestPlanDao.fetchForAutomatedExecutionCreation((Collection<Long>)batch);
            List<Execution> executions = this.createAutomatedExecutions(automatedSuite, (List<Long>)batch, testPlanItems);
            this.addExternalFields(executions, project);
        });
        this.updateIteration(automatedSuite);
    }

    @Override
    public Map<Long, Long> createSquashOrchestratorAutomatedExecutions(AutomatedSuite automatedSuite, List<Long> testPlanItemIds, Project project) {
        return this.processExecutionsWithMapping(automatedSuite, testPlanItemIds, executions -> this.addExternalFields((List<Execution>)executions, project));
    }

    @Override
    public Map<Long, Long> createSquashOrchestratorAutomatedExecutions(AutomatedSuite automatedSuite, List<Long> testPlanItemIds, Long projectId, Map<Long, SquashAutomExecutionConfiguration> configurations) {
        Project project = this.projectDao.fetchForAutomatedExecutionCreation(projectId);
        return this.processExecutionsWithMapping(automatedSuite, testPlanItemIds, executions -> {
            this.createDenormalizedEnvironments(configurations, (List<Execution>)executions);
            this.addExternalFields((List<Execution>)executions, project);
        });
    }

    private Map<Long, Long> processExecutionsWithMapping(AutomatedSuite automatedSuite, List<Long> testPlanItemIds, Consumer<List<Execution>> executionProcessor) {
        HibernateConfig.enableBatch(this.entityManager, 20);
        Map<Long, Long> result = Lists.partition(testPlanItemIds, (int)20).stream().flatMap(batch -> {
            List<TestPlanItem> testPlanItems = this.iterationTestPlanDao.fetchForAutomatedExecutionCreation((Collection<Long>)batch);
            List<Execution> executions = this.createAutomatedExecutions(automatedSuite, (List<Long>)batch, testPlanItems);
            executionProcessor.accept(executions);
            return executions.stream();
        }).collect(Collectors.toMap(exec -> exec.getTestPlanItem().getId(), Execution::getId));
        this.updateIteration(automatedSuite);
        return result;
    }

    private void updateIteration(AutomatedSuite automatedSuite) {
        Iteration iteration = automatedSuite.getIteration();
        if (iteration != null) {
            iteration = (Iteration)this.entityManager.merge((Object)iteration);
            iteration.updateAutoDates(new Date());
        }
    }

    private List<Execution> createAutomatedExecutions(AutomatedSuite automatedSuite, List<Long> testPlanItemIds, List<TestPlanItem> testPlanItems) {
        Map<Long, Integer> nextPositionItem = this.iterationTestPlanDao.getNextExecutionOrders(testPlanItemIds);
        List<Execution> executions = testPlanItems.stream().map(item -> {
            Integer position = (Integer)nextPositionItem.get(item.getId());
            return this.createAutomatedExecution(automatedSuite, (TestPlanItem)item, position);
        }).toList();
        this.entityManager.flush();
        return executions;
    }

    private Execution createAutomatedExecution(AutomatedSuite automatedSuite, TestPlanItem item, Integer position) {
        if (item.isTestCaseDeleted()) {
            throw new TestPlanItemNotExecutableException("Cannot create the execution: the referenced test case has been deleted.");
        }
        CreateExecutionFromTestCaseVisitor createExecutionVisitor = new CreateExecutionFromTestCaseVisitor(item.getReferencedDataset());
        item.getReferencedTestCase().accept((TestCaseVisitor)createExecutionVisitor);
        Execution execution = createExecutionVisitor.getCreatedExecution();
        execution.setOrder(position);
        item.addNewExecution(execution);
        AutomatedExecutionExtender extender = new AutomatedExecutionExtender();
        extender.setExecution(execution);
        extender.setAutomatedSuite(automatedSuite);
        execution.setAutomatedExecutionExtender(extender);
        TestCase referencedTestCase = execution.getReferencedTestCase();
        extender.setAutomatedTest(referencedTestCase.getAutomatedTest());
        AutomatedTestTechnology automatedTestTechnology = referencedTestCase.getAutomatedTestTechnology();
        if (automatedTestTechnology != null) {
            extender.setTestTechnology(automatedTestTechnology.getName());
        } else {
            extender.setTestTechnology(null);
        }
        this.executionDao.save(execution);
        this.copyAttachments(execution);
        return execution;
    }

    private void createDenormalizedEnvironments(Map<Long, SquashAutomExecutionConfiguration> configurations, List<Execution> executions) {
        HashMap<SquashAutomExecutionConfiguration, Map> test = new HashMap<SquashAutomExecutionConfiguration, Map>();
        for (Execution execution : executions) {
            Long testCaseProjectId = execution.getReferencedTestCase().getProject().getId();
            SquashAutomExecutionConfiguration configuration2 = configurations.get(testCaseProjectId);
            if (configuration2 == null) {
                throw new IllegalArgumentException("No configuration found for test case " + String.valueOf(execution.getReferencedTestCase().getId()));
            }
            Long extenderId = execution.getAutomatedExecutionExtender().getId();
            AutomatedTestTechnology testTechnology = execution.getReferencedTestCase().getAutomatedTestTechnology();
            test.computeIfAbsent(configuration2, k -> new HashMap()).put(extenderId, testTechnology);
        }
        test.forEach((configuration, extenders) -> {
            this.createDenormalizedEnvironmentTags(configuration.getEnvironmentTags(), (Map<Long, AutomatedTestTechnology>)extenders);
            this.createDenormalizedEnvironmentVariables(configuration.getEnvironmentVariables(), extenders.keySet());
        });
    }

    private void createDenormalizedEnvironmentVariables(Map<String, EnvironmentVariableValue> environmentVariables, Set<Long> extenderIds) {
        if (environmentVariables == null || environmentVariables.isEmpty()) {
            return;
        }
        Map<String, String> variables = environmentVariables.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((EnvironmentVariableValue)entry.getValue()).getValue()));
        this.denormalizedEnvironmentVariableManagerService.createAllDenormalizedEnvironmentVariablesForAutomatedExecution(variables, extenderIds);
    }

    private void createDenormalizedEnvironmentTags(List<String> environmentTags, Map<Long, AutomatedTestTechnology> extenderTechnologies) {
        if (environmentTags == null || environmentTags.isEmpty()) {
            return;
        }
        this.denormalizedEnvironmentTagManagerService.createAllDenormalizedEnvironmentTagsForAutomatedExecution(environmentTags, extenderTechnologies);
    }

    private void addExternalFields(List<Execution> createdExecutions, Project project) {
        this.createCustomFieldsForExecutionAndExecutionSteps(createdExecutions, project);
        this.createDenormalizedFieldsForExecutionAndExecutionSteps(createdExecutions);
        this.entityManager.flush();
        this.entityManager.clear();
    }

    private void createCustomFieldsForExecutionAndExecutionSteps(List<Execution> executions, Project project) {
        this.customFieldValuesService.createAllCustomFieldValues(executions, (GenericProject)project);
        List steps = executions.stream().flatMap(exec -> exec.getSteps().stream()).toList();
        this.customFieldValuesService.createAllCustomFieldValues(steps, (GenericProject)project);
    }

    private void createDenormalizedFieldsForExecutionAndExecutionSteps(List<Execution> executions) {
        Map<Long, List<DenormalizedFieldHolder>> map = executions.stream().map(DenormalizedFieldHolder.class::cast).collect(Collectors.groupingBy(holder -> ((Execution)holder).getReferencedTestCase().getId()));
        this.denormalizedFieldValueService.createBatchDenormalizedFieldValues(map, BindableEntity.TEST_CASE);
        this.denormalizedFieldValueService.createAllDenormalizedFieldValuesForSteps(executions);
    }

    private void copyAttachments(Execution execution) {
        this.attachmentManagerService.copyContentsOnExternalRepository((AttachmentHolder)execution);
        for (ExecutionStep executionStep : execution.getSteps()) {
            this.attachmentManagerService.copyContentsOnExternalRepository((AttachmentHolder)executionStep);
        }
    }
}

