/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.bugtracker.adapter;

import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.squashtest.csp.core.bugtracker.core.BugTrackerNoCredentialsException;
import org.squashtest.csp.core.bugtracker.core.BugTrackerRemoteException;
import org.squashtest.csp.core.bugtracker.core.ProjectNotFoundException;
import org.squashtest.csp.core.bugtracker.core.UnsupportedAuthenticationModeException;
import org.squashtest.csp.core.bugtracker.spi.BugTrackerCacheInfo;
import org.squashtest.csp.core.bugtracker.spi.BugTrackerInterfaceDescriptor;
import org.squashtest.tm.bugtracker.advanceddomain.DelegateCommand;
import org.squashtest.tm.bugtracker.advanceddomain.RemoteIssueFindContext;
import org.squashtest.tm.bugtracker.advanceddomain.RemoteIssueSearchForm;
import org.squashtest.tm.bugtracker.advanceddomain.RemoteIssueSearchRequest;
import org.squashtest.tm.bugtracker.definition.Attachment;
import org.squashtest.tm.bugtracker.definition.RemoteIssue;
import org.squashtest.tm.bugtracker.definition.RemoteProject;
import org.squashtest.tm.bugtracker.definition.context.BugTrackerBindingInfo;
import org.squashtest.tm.bugtracker.definition.context.RemoteIssueContext;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.domain.servers.Credentials;

public interface InternalBugtrackerConnector {
    public AuthenticationProtocol[] getSupportedAuthProtocols();

    public boolean supports(AuthenticationProtocol var1);

    public void authenticate(Credentials var1) throws UnsupportedAuthenticationModeException;

    public void checkCredentials(Credentials var1) throws BugTrackerNoCredentialsException, BugTrackerRemoteException;

    public boolean areCredentialsValid(Credentials var1);

    public URL makeViewIssueUrl(BugTracker var1, String var2);

    public RemoteProject findProject(String var1) throws ProjectNotFoundException, BugTrackerRemoteException;

    public RemoteProject findProjectById(String var1) throws ProjectNotFoundException, BugTrackerRemoteException;

    public RemoteIssue createIssue(RemoteIssue var1) throws BugTrackerRemoteException;

    public RemoteIssue createReportIssueTemplate(String var1, RemoteIssueContext var2);

    public BugTrackerInterfaceDescriptor getInterfaceDescriptor();

    public RemoteIssue findIssue(String var1);

    public List<RemoteIssue> findIssues(Collection<String> var1);

    default public List<RemoteIssue> findKnownIssues(Collection<String> issueKeys, RemoteIssueFindContext context) {
        return this.findIssues(issueKeys);
    }

    default public RemoteIssueSearchForm createIssueSearchForm(BugTrackerBindingInfo bugTrackerBindingInfo) {
        return RemoteIssueSearchForm.defaultForm();
    }

    public Optional<? extends RemoteIssue> searchIssue(RemoteIssueSearchRequest var1);

    public void forwardAttachments(String var1, List<Attachment> var2);

    public Object executeDelegateCommand(DelegateCommand var1);

    public void linkIssues(String var1, List<String> var2);

    public String getKeyForLogin(BugTracker var1);

    public String getKeyForPassword(BugTracker var1);

    public boolean allowsReportingCache();

    public void refreshCacheForBugTracker(BugTracker var1);

    public void refreshCacheForProject(BugTracker var1, long var2);

    public BugTrackerCacheInfo getCacheInfo();
}

