/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport;

import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.tm.core.foundation.lang.PathUtils;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.testcase.ParameterAssignationMode;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.service.importer.ImportMode;
import org.squashtest.tm.service.importer.ImportStatus;
import org.squashtest.tm.service.importer.LogEntry;
import org.squashtest.tm.service.importer.Target;
import org.squashtest.tm.service.importer.WithPath;
import org.squashtest.tm.service.internal.batchimport.CallStepParamsInfo;
import org.squashtest.tm.service.internal.batchimport.Existence;
import org.squashtest.tm.service.internal.batchimport.LogTrain;
import org.squashtest.tm.service.internal.batchimport.Model;
import org.squashtest.tm.service.internal.batchimport.ProjectTargetStatus;
import org.squashtest.tm.service.internal.batchimport.TargetStatus;
import org.squashtest.tm.service.internal.batchimport.column.requirement.RequirementSheetColumn;
import org.squashtest.tm.service.internal.batchimport.column.testcase.CoverageInstruction;
import org.squashtest.tm.service.internal.batchimport.column.testcase.CoverageTarget;
import org.squashtest.tm.service.internal.batchimport.column.testcase.DatasetSheetColumn;
import org.squashtest.tm.service.internal.batchimport.column.testcase.ParameterSheetColumn;
import org.squashtest.tm.service.internal.batchimport.column.testcase.StepSheetColumn;
import org.squashtest.tm.service.internal.batchimport.column.testcase.TestCaseSheetColumn;
import org.squashtest.tm.service.internal.batchimport.instruction.LinkedLowLevelRequirementInstruction;
import org.squashtest.tm.service.internal.batchimport.instruction.RequirementLinkInstruction;
import org.squashtest.tm.service.internal.batchimport.instruction.RequirementVersionInstruction;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.DatasetTarget;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.LinkedLowLevelRequirementTarget;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.ParameterTarget;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.RequirementLinkTarget;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.RequirementTarget;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.RequirementVersionTarget;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.TestCaseTarget;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.TestStepTarget;
import org.squashtest.tm.service.internal.batchimport.requirement.dto.RequirementImportValidationBag;
import org.squashtest.tm.service.internal.batchimport.testcase.dto.TestCaseImportValidationBag;
import org.squashtest.tm.service.plugin.PluginFinderService;
import org.squashtest.tm.service.requirement.HighLevelRequirementService;
import org.squashtest.tm.service.requirement.RequirementLibraryFinderService;

@Component
@Scope(value="prototype")
public class EntityValidator {
    private final PluginFinderService pluginFinderService;
    private final HighLevelRequirementService highLevelRequirementService;
    private final RequirementLibraryFinderService reqFinderService;
    private Model model;

    public EntityValidator(PluginFinderService pluginFinderService, HighLevelRequirementService highLevelRequirementService, RequirementLibraryFinderService reqFinderService) {
        this.pluginFinderService = pluginFinderService;
        this.highLevelRequirementService = highLevelRequirementService;
        this.reqFinderService = reqFinderService;
    }

    public void setModel(Model model) {
        this.model = model;
    }

    public LogTrain updateTestCaseChecks(TestCaseTarget target, TestCase testCase, TestCaseImportValidationBag validationBag) {
        LogTrain logs = this.createTestCaseChecks(target, testCase, validationBag);
        String name = testCase.getName();
        if (StringUtils.isBlank((CharSequence)name)) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.mandatoryColumn", TestCaseSheetColumn.TC_NAME.header).build());
        }
        logs.append(this.checkNatureAndTypeAndFixIfNeeded(target, testCase, validationBag));
        return logs;
    }

    public LogTrain createTestCaseChecks(TestCaseTarget target, TestCase testCase, TestCaseImportValidationBag validationBag) {
        String reference;
        ProjectTargetStatus projectStatus;
        String name = testCase.getName();
        LogTrain logs = new LogTrain();
        if (!target.isWellFormed()) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.field.malformedPath", target.getPath()).build());
        }
        if (target.isWellFormed() && (projectStatus = this.model.getProjectStatus(target.getProject())).getStatus() != Existence.EXISTS) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.tc.tcPath.projectNotFound", new Object[0]).build());
        }
        if (name != null && name.length() > 255) {
            logs.addEntry(LogEntry.warning().forTarget(target).withMessage("message.import.log.error.field.maxSize", TestCaseSheetColumn.TC_NAME.header).withImpact("message.import.log.impact.truncatedValue", new Object[0]).build());
        }
        if (!StringUtils.isBlank((CharSequence)(reference = testCase.getReference())) && reference.length() > 50) {
            logs.addEntry(LogEntry.warning().forTarget(target).withMessage("message.import.log.error.field.maxSize", TestCaseSheetColumn.TC_REFERENCE.header).withImpact("message.import.log.impact.truncatedValue", new Object[0]).build());
        }
        logs.append(this.checkNatureAndTypeAndFixIfNeeded(target, testCase, validationBag));
        return logs;
    }

    LogTrain basicTestStepChecks(TestStepTarget target) {
        ProjectTargetStatus projectStatus;
        LogTrain logs = new LogTrain();
        TestCaseTarget testCase = target.getTestCase();
        if (!testCase.isWellFormed()) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.field.malformedPath", testCase.getPath()).build());
        }
        TargetStatus tcStatus = this.model.getStatus(testCase);
        if (tcStatus.status == Existence.TO_BE_DELETED || tcStatus.status == Existence.NOT_EXISTS) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.tc.notFound", new Object[0]).build());
        }
        if (target.isWellFormed() && (projectStatus = this.model.getProjectStatus(target.getProject())).getStatus() != Existence.EXISTS) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.tc.tcPath.projectNotFound", new Object[0]).build());
        }
        return logs;
    }

    LogTrain validateCallStep(TestStepTarget target, TestCaseTarget calledTestCase, CallStepParamsInfo paramInfos, ImportMode mode) {
        LogTrain logs = new LogTrain();
        String errorMessage = this.checkTestCaseExists(calledTestCase);
        if (errorMessage != null) {
            this.logMustExistAndBeValidCalledTest(target, mode, logs, errorMessage);
        } else {
            if (this.model.wouldCreateCycle(target, calledTestCase)) {
                logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.tc.callStep.cyclicCalls", target.getTestCase().getPath(), calledTestCase.getPath()).build());
            }
            if (paramInfos.getParamMode() == ParameterAssignationMode.CALLED_DATASET) {
                DatasetTarget dsTarget;
                String dsname = paramInfos.getCalledDatasetName();
                if (dsname.length() > 255) {
                    LogEntry entry = LogEntry.warning().forTarget(target).withMessage("message.import.log.error.field.maxSize", StepSheetColumn.TC_STEP_CALL_DATASET.name()).withImpact("message.import.log.impact.truncatedValue", new Object[0]).build();
                    logs.addEntry(entry);
                }
                if (this.model.datasetNotExist(dsTarget = new DatasetTarget(calledTestCase, dsname))) {
                    logs.addEntry(LogEntry.warning().forTarget(target).withMessage("message.import.log.error.tc.callStep.calledDatasetNotFound", new Object[0]).withImpact("message.import.log.impact.callStepCallsNoDataset", new Object[0]).build());
                }
            }
        }
        return logs;
    }

    private String checkTestCaseExists(TestCaseTarget calledTestCase) {
        TargetStatus calledStatus = this.model.getStatus(calledTestCase);
        String mustExistAndBeValidMessage = null;
        if (calledStatus.status == Existence.NOT_EXISTS || calledStatus.status == Existence.TO_BE_DELETED) {
            mustExistAndBeValidMessage = "message.import.log.error.tc.callStep.calledTcNotFound";
        } else if (!calledTestCase.isWellFormed()) {
            mustExistAndBeValidMessage = "message.import.log.error.tc.callStep.wrongFormat";
        }
        return mustExistAndBeValidMessage;
    }

    public void preVersionValidation(RequirementVersionInstruction instruction) {
        this.checkVersionPath(instruction);
        this.checkVersionName(instruction);
    }

    private void checkVersionPath(RequirementVersionInstruction instruction) {
        RequirementVersionTarget target = (RequirementVersionTarget)instruction.getTarget();
        if (!target.isWellFormed()) {
            return;
        }
        String path = target.getRequirement().getPath();
        String[] names = PathUtils.splitPath((String)path);
        int i = 1;
        while (i < names.length) {
            String name = names[i];
            if (name.length() > 255) {
                names[i] = StringUtils.abbreviate((String)name, (int)255);
                instruction.addLogEntry(ImportStatus.WARNING, "message.import.log.error.field.maxSize", null, RequirementSheetColumn.REQ_PATH.header);
                target.getRequirement().setPath(PathUtils.buildPathFromParts((String[])names));
            }
            ++i;
        }
    }

    private void checkVersionName(RequirementVersionInstruction instruction) {
        RequirementVersion reqVersion = instruction.getRequirementVersion();
        String name = reqVersion.getName();
        if (name != null && name.length() > 255) {
            reqVersion.setName(StringUtils.abbreviate((String)name, (int)255));
            instruction.addLogEntry(ImportStatus.WARNING, "message.import.log.error.field.maxSize", "message.import.log.impact.truncatedValue", RequirementSheetColumn.REQ_VERSION_NAME.header);
        }
    }

    public LogTrain createRequirementVersionChecks(RequirementVersionTarget target, RequirementVersion reqVersion, RequirementImportValidationBag validationBag) {
        LogTrain logs = new LogTrain();
        return this.basicReqVersionTests(target, reqVersion, logs, validationBag);
    }

    public void createHighLevelRequirementChecks(RequirementVersionTarget target, LogTrain logs) {
        this.highLevelRequirementCreateTests(target, logs);
    }

    public LogTrain updateRequirementChecks(RequirementVersionTarget target, RequirementVersion reqVersion, RequirementImportValidationBag validationBag) {
        LogTrain logs = new LogTrain();
        this.checkRequirementVersionNumber(target, logs);
        if (logs.hasCriticalErrors()) {
            return logs;
        }
        this.basicReqVersionTests(target, reqVersion, logs, validationBag);
        return logs;
    }

    private void checkRequirementVersionNumber(RequirementVersionTarget target, LogTrain logs) {
        if (target.getVersion() == null || target.getVersion() < 1) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.requirement.version.invalidVersionNumber", new Object[0]).build());
        }
    }

    private LogTrain basicReqVersionTests(RequirementVersionTarget target, RequirementVersion reqVersion, LogTrain logs, RequirementImportValidationBag validationBag) {
        this.checkMalformedPath(target, logs);
        if (logs.hasCriticalErrors()) {
            return logs;
        }
        this.checkProjectExists(target, logs);
        this.checkVersionReference(target, reqVersion, logs);
        logs.append(this.checkCategoryAndFixIfNeeded(target, reqVersion, validationBag));
        return logs;
    }

    private void highLevelRequirementCreateTests(RequirementVersionTarget target, LogTrain logs) {
        RequirementTarget reqTarget = target.getRequirement();
        if (reqTarget.isHighLevel()) {
            this.checkPremiumPluginIsInstalled(target, logs, true);
            if (logs.hasCriticalErrors()) {
                return;
            }
            if (!Existence.EXISTS.equals((Object)this.model.getStatus(reqTarget).getStatus()) && this.model.isRequirementChild(reqTarget)) {
                logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.highLevelReqUnderAnotherReq", RequirementSheetColumn.REQ_PATH.header).build());
                this.model.flagNonImportable(reqTarget);
            }
        }
    }

    public void checkImportableFlag(RequirementVersionTarget target, LogTrain logs) {
        if (!logs.hasCriticalErrors() && !this.model.isImportable(target.getRequirement())) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.requirement.hasNonImportableParent", new Object[0]).build());
        }
    }

    public void highLevelRequirementUpdateTests(RequirementVersionTarget target, LogTrain logs) {
        Requirement origRequirement;
        if (logs.hasCriticalErrors()) {
            return;
        }
        RequirementTarget reqTarget = target.getRequirement();
        Requirement requirement = origRequirement = reqTarget.getId() != null ? this.reqFinderService.findRequirement(reqTarget.getId()) : null;
        if (origRequirement != null) {
            boolean needTestForUpdate = reqTarget.isHighLevel() ^ origRequirement.isHighLevel();
            this.basicHighLevelRequirementTests(target, logs, needTestForUpdate, false);
            this.requirementConvertTests(origRequirement, logs, target);
        }
    }

    private void requirementConvertTests(Requirement origRequirement, LogTrain logs, RequirementVersionTarget target) {
        if (!origRequirement.isHighLevel() && target.getRequirement().isHighLevel()) {
            this.checkReqAlreadyLinkedToHighLvlReq(origRequirement, logs, target);
        } else if (origRequirement.isHighLevel() && !target.getRequirement().isHighLevel()) {
            this.checkHighLvlReqHasLinkedLowLvlReqs(origRequirement, logs, target);
        }
    }

    private void checkReqAlreadyLinkedToHighLvlReq(Requirement origRequirement, LogTrain logs, RequirementVersionTarget target) {
        if (origRequirement.getHighLevelRequirement() != null) {
            logs.addEntry(LogEntry.warning().forTarget(target).withMessage("message.import.log.warning.reqAlreadyLinkedToHighLvlReq", new Object[0]).withImpact("message.import.log.impact.requirement.highLvlReqReferenceLoss", new Object[0]).build());
        }
    }

    private void checkHighLvlReqHasLinkedLowLvlReqs(Requirement origRequirement, LogTrain logs, RequirementVersionTarget target) {
        List<Requirement> linkedLowLevelReqs = this.highLevelRequirementService.findStandardRequirementsByHighLvlReqId(origRequirement.getId());
        if (linkedLowLevelReqs != null && !linkedLowLevelReqs.isEmpty()) {
            logs.addEntry(LogEntry.warning().forTarget(target).withMessage("message.import.log.warning.highLvlReqHasLinkedLowLvlReqs", new Object[0]).withImpact("message.import.log.impact.requirement.linkedLowLvlReqsLoss", new Object[0]).build());
        }
    }

    private void basicHighLevelRequirementTests(RequirementVersionTarget target, LogTrain logs, boolean needTest, boolean isCreateReq) {
        RequirementTarget reqTarget = target.getRequirement();
        if (reqTarget != null && needTest) {
            this.checkPremiumPluginIsInstalled(target, logs, isCreateReq);
            if (logs.hasCriticalErrors()) {
                return;
            }
            if (this.isChildRequirementByPath(target.getPath())) {
                logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.highLevelReqUnderAnotherReq", RequirementSheetColumn.REQ_PATH.header).build());
            }
        }
    }

    private void checkPremiumPluginIsInstalled(RequirementVersionTarget target, LogTrain logs, boolean isCreateReq) {
        if (!this.pluginFinderService.isPremiumPluginInstalled()) {
            if (isCreateReq) {
                logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.highLevelReqNeedsPremiumPluginForCreate", new Object[0]).build());
            } else {
                logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.highLevelReqNeedsPremiumPluginForUpdate", RequirementSheetColumn.REQ_PATH.header).build());
            }
        }
    }

    public boolean isChildRequirementByPath(String targetPath) {
        List paths = PathUtils.scanPath((String)targetPath);
        if (paths.size() > 2) {
            String parentPath = (String)paths.get(paths.size() - 2);
            RequirementTarget parentTarget = new RequirementTarget(parentPath);
            Long parentId = this.reqFinderService.findNodeIdByPath(parentPath);
            return this.isReqParentARequirement(parentId, parentTarget);
        }
        return false;
    }

    private boolean isReqParentARequirement(Long parentId, RequirementTarget parentTarget) {
        return parentId != null && this.reqFinderService.findRequirement(parentId) != null || parentId == null && !this.model.isRequirementFolder(parentTarget);
    }

    private void checkVersionReference(RequirementVersionTarget target, RequirementVersion reqVersion, LogTrain logs) {
        String reference = reqVersion.getReference();
        if (!StringUtils.isBlank((CharSequence)reference) && reference.length() > 50) {
            logs.addEntry(LogEntry.warning().forTarget(target).withMessage("message.import.log.error.field.maxSize", RequirementSheetColumn.REQ_VERSION_REFERENCE.header).withImpact("message.import.log.impact.truncatedValue", new Object[0]).build());
        }
    }

    private void checkProjectExists(RequirementVersionTarget target, LogTrain logs) {
        ProjectTargetStatus projectStatus;
        if (target.isWellFormed() && (projectStatus = this.model.getProjectStatus(target.getProject())).getStatus() != Existence.EXISTS) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.tc.tcPath.projectNotFound", new Object[0]).build());
        }
    }

    private void checkMalformedPath(RequirementVersionTarget target, LogTrain logs) {
        if (!target.isWellFormed() || this.pathHasEmptyParts(target.getPath())) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.field.malformedPath", target.getPath()).build());
        }
    }

    private boolean pathHasEmptyParts(String path) {
        String[] splits;
        String[] stringArray = splits = PathUtils.splitPath((String)path);
        int n = splits.length;
        int n2 = 0;
        while (n2 < n) {
            String split = stringArray[n2];
            if (split.isEmpty()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void logMustExistAndBeValidCalledTest(TestStepTarget target, ImportMode mode, LogTrain logs, String message) {
        switch (mode) {
            case CREATE: {
                logs.addEntry(LogEntry.warning().forTarget(target).withMessage(message, new Object[0]).withImpact("message.import.log.impact.callStepImportedAsActionStep", new Object[0]).build());
                break;
            }
            default: {
                logs.addEntry(LogEntry.failure().forTarget(target).withMessage(message, new Object[0]).build());
            }
        }
    }

    LogTrain basicParameterChecks(ParameterTarget target) {
        return this.basicParameterChecks(target, ParameterSheetColumn.TC_OWNER_PATH.name(), "message.import.log.error.tc.tcOwnerNotFound");
    }

    public LogTrain basicParameterValueChecks(ParameterTarget target) {
        return this.basicParameterChecks(target, "TC_PARAMETER_OWNER_PATH", "message.import.log.error.tc.paramValueParamOwnerNotFound");
    }

    private LogTrain basicParameterChecks(ParameterTarget target, String fieldPathErrorArg, String ownerNotFoundMessage) {
        LogTrain logs = new LogTrain();
        TestCaseTarget testCase = target.getOwner();
        this.basicTestCaseTargetCheck(testCase, logs, fieldPathErrorArg, ownerNotFoundMessage, target);
        this.basicParameterChecksValidateName(target, logs);
        return logs;
    }

    LogTrain basicDatasetCheck(DatasetTarget target) {
        LogTrain logs = new LogTrain();
        String fieldNameErrorArg = DatasetSheetColumn.TC_DATASET_NAME.name();
        TestCaseTarget testCase = target.getTestCase();
        this.basicTestCaseTargetCheck(testCase, logs, testCase.getPath(), "message.import.log.error.tc.notFound", target);
        String name = target.getName();
        if (name != null && name.length() > 255) {
            logs.addEntry(LogEntry.warning().forTarget(target).withMessage("message.import.log.error.field.maxSize", fieldNameErrorArg).withImpact("message.import.log.impact.truncatedValue", new Object[0]).build());
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.mandatoryColumn", fieldNameErrorArg).build());
        }
        return logs;
    }

    private <T extends Target & WithPath> void basicTestCaseTargetCheck(TestCaseTarget testCase, LogTrain logs, String fieldPathErrorArg, String tcNotFoundMessage, T target) {
        ProjectTargetStatus projectStatus;
        if (!testCase.isWellFormed()) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.field.malformedPath", fieldPathErrorArg).build());
        }
        TargetStatus tcStatus = this.model.getStatus(testCase);
        if (tcStatus.status == Existence.TO_BE_DELETED || tcStatus.status == Existence.NOT_EXISTS) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage(tcNotFoundMessage, new Object[0]).build());
        }
        if (testCase.isWellFormed() && (projectStatus = this.model.getProjectStatus(((WithPath)target).getProject())).getStatus() != Existence.EXISTS) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.tc.tcPath.projectNotFound", new Object[0]).build());
        }
    }

    private void basicParameterChecksValidateName(ParameterTarget target, LogTrain logs) {
        String fieldNameErrorArg = ParameterSheetColumn.TC_PARAM_NAME.name();
        String name = target.getName();
        if (StringUtils.isBlank((CharSequence)name)) {
            logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.mandatoryColumn", fieldNameErrorArg).build());
        } else {
            if (name.length() > 255) {
                logs.addEntry(LogEntry.warning().forTarget(target).withMessage("message.import.log.error.field.maxSize", fieldNameErrorArg).withImpact("message.import.log.impact.truncatedValue", new Object[0]).build());
            }
            String regex = "^[A-Za-z0-9_-]{1,255}$";
            name = name.trim();
            target.setName(name);
            Pattern p = Pattern.compile(regex);
            Matcher m = p.matcher(name);
            if (!StringUtils.isBlank((CharSequence)name) && !m.matches() && name.length() < 256) {
                logs.addEntry(LogEntry.failure().forTarget(target).withMessage("message.import.log.error.tc.param.wrongFormat", fieldNameErrorArg).build());
            }
        }
    }

    private LogTrain checkNatureAndTypeAndFixIfNeeded(TestCaseTarget target, TestCase testCase, TestCaseImportValidationBag validationBag) {
        ProjectTargetStatus projectStatus;
        LogTrain logs = new LogTrain();
        if (target.isWellFormed() && (projectStatus = this.model.getProjectStatus(target.getProject())).getStatus() == Existence.EXISTS) {
            if (!this.natureDefinedAndConsistent(testCase, validationBag.consistentNatures())) {
                testCase.setNature(validationBag.defaultNature());
                logs.addEntry(LogEntry.warning().forTarget(target).withMessage("message.import.log.error.natureinvalid", target.getPath()).withImpact("message.import.log.impact.useDefaultValue", new Object[0]).build());
            }
            if (!this.typeDefinedAndConsistent(testCase, validationBag.consistentTypes())) {
                testCase.setType(validationBag.defaultType());
                logs.addEntry(LogEntry.warning().forTarget(target).withMessage("message.import.log.error.typeinvalid", target.getPath()).withImpact("message.import.log.impact.useDefaultValue", new Object[0]).build());
            }
        }
        return logs;
    }

    private LogTrain checkCategoryAndFixIfNeeded(RequirementVersionTarget target, RequirementVersion reqVersion, RequirementImportValidationBag validationBag) {
        LogTrain logs = new LogTrain();
        if (target.isWellFormed() && !this.categoryDefinedAndConsistent(reqVersion, validationBag.consistentCategories())) {
            reqVersion.updateCategoryWhithoutCheck(validationBag.defaultCategory());
            logs.addEntry(LogEntry.warning().forTarget(target).withMessage("message.import.log.error.categoryinvalid", target.getPath()).withImpact("message.import.log.impact.useDefaultValue", new Object[0]).build());
        }
        return logs;
    }

    private boolean categoryDefinedAndConsistent(RequirementVersion reqVersion, Set<String> consistentCategories) {
        InfoListItem category = reqVersion.getCategory();
        if (category == null) {
            return false;
        }
        return consistentCategories.contains(category.getCode());
    }

    private boolean natureDefinedAndConsistent(TestCase testCase, Set<String> consistentNatures) {
        InfoListItem nature = testCase.getNature();
        if (nature == null) {
            return true;
        }
        return consistentNatures.contains(nature.getCode());
    }

    private boolean typeDefinedAndConsistent(TestCase testCase, Set<String> consistentTypes) {
        InfoListItem type = testCase.getType();
        if (type == null) {
            return true;
        }
        return consistentTypes.contains(type.getCode());
    }

    public void preCoverageValidation(CoverageInstruction instruction) {
        CoverageTarget target = (CoverageTarget)instruction.getTarget();
        if (!target.isReqPathWellFormed()) {
            instruction.addLogEntry(ImportStatus.FAILURE, "message.import.log.error.field.malformedPath", null, target.getReqPath());
        }
        if (target.getReqVersion() <= 0) {
            instruction.addLogEntry(ImportStatus.FAILURE, "message.import.log.error.requirement.version.invalidVersionNumber", null, new Object[0]);
        }
        if (!target.isTcPathWellFormed()) {
            instruction.addLogEntry(ImportStatus.FAILURE, "message.import.log.error.field.malformedPath", null, target.getTcPath());
        }
    }

    public void preRequirementLinkValidation(RequirementLinkInstruction instruction) {
        RequirementVersionTarget dest;
        RequirementLinkTarget target = (RequirementLinkTarget)instruction.getTarget();
        RequirementVersionTarget source = target.getSourceVersion();
        if (!source.isWellFormed()) {
            instruction.addLogEntry(ImportStatus.FAILURE, "message.import.log.error.requirementlinks.malformed-sourcepath", null, source.getPath());
        }
        if (!(dest = target.getDestVersion()).isWellFormed()) {
            instruction.addLogEntry(ImportStatus.FAILURE, "message.import.log.error.requirementlinks.malformed-destpath", null, dest.getPath());
        }
    }

    public void preLinkedLowLevelRequirementValidation(LinkedLowLevelRequirementInstruction instruction) {
        LinkedLowLevelRequirementTarget target = (LinkedLowLevelRequirementTarget)instruction.getTarget();
        if (!target.isHighLevelReqPathWellFormed()) {
            instruction.addLogEntry(ImportStatus.FAILURE, "message.import.log.error.field.malformedPath", null, target.getHighLevelReqPath());
        }
        if (!target.isStandardReqPathWellFormed()) {
            instruction.addLogEntry(ImportStatus.FAILURE, "message.import.log.error.field.malformedPath", null, target.getStandardReqPath());
        }
    }
}

