/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository;

import java.util.Collection;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.plugin.UsedInPlugin;
import org.squashtest.tm.domain.requirement.RemoteRequirementPerimeterStatus;
import org.squashtest.tm.domain.requirement.RequirementSyncExtender;
import org.squashtest.tm.service.annotation.EmptyCollectionGuard;
import org.squashtest.tm.service.internal.repository.CustomRequirementSyncExtenderDao;

public interface RequirementSyncExtenderDao
extends JpaRepository<RequirementSyncExtender, Long>,
CustomRequirementSyncExtenderDao {
    @Query
    @UsedInPlugin(value="Xsquash4Jira & Xsquash4GitLab")
    public RequirementSyncExtender retrieveByRemoteKey(@Param(value="id") String var1, @Param(value="pId") Long var2);

    @Query
    @UsedInPlugin(value="Xsquash4Jira & Xsquash4GitLab")
    public RequirementSyncExtender retrieveByRemoteKeyAndSyncId(@Param(value="id") String var1, @Param(value="remoteSynchronisationId") Long var2);

    @Query
    @EmptyCollectionGuard
    public Collection<RequirementSyncExtender> retrieveAllByRemoteKey(@Param(value="ids") Collection<String> var1, @Param(value="pId") Long var2);

    @Query
    public Collection<RequirementSyncExtender> retrieveAllByRemoteProjectsAndFilter(@Param(value="remotePId") String var1, @Param(value="filter") String var2, @Param(value="pId") Long var3);

    @Query
    public Collection<RequirementSyncExtender> retrieveAllByServer(@Param(value="serverId") Long var1);

    @Query
    @Modifying
    @Transactional
    public void deleteAllByServer(@Param(value="serverId") Long var1);

    @Query(value="delete from RequirementSyncExtender rm where rm.remoteSynchronisation.id in :remoteSynchronisationId")
    @Modifying
    public void deleteByRemoteSynchronisationId(@Param(value="remoteSynchronisationId") List<Long> var1);

    @Query(value="update RequirementSyncExtender rm set rm.remoteRequirementPerimeterStatus=:status where rm.remoteSynchronisation.id = :remoteSynchronisationId and rm.remoteReqId in :keys")
    @Modifying
    @UsedInPlugin(value="Xsquash4Jira & Xsquash4GitLab")
    public void updatePerimeter(@Param(value="remoteSynchronisationId") Long var1, @Param(value="keys") List<String> var2, @Param(value="status") RemoteRequirementPerimeterStatus var3);

    @Query(value="delete from RequirementSyncExtender sync where sync.server.id in :bugTrackerIds")
    @Modifying
    public void deleteAllByBugTrackerIds(@Param(value="bugTrackerIds") List<Long> var1);
}

