/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectexporter.dao;

import java.util.Iterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record2;
import org.jooq.Record7;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.RequirementLibraryNode;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AbstractPivotObject;
import org.squashtest.tm.service.internal.dto.pivotdefinition.requirementworkspace.RequirementPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.requirementworkspace.RequirementVersionPivot;
import org.squashtest.tm.service.pivot.converters.RequirementPivotConverterService;
import org.squashtest.tm.service.pivot.projectexporter.dao.CustomFieldPivotDao;
import org.squashtest.tm.service.pivot.projectexporter.dao.RequirementPivotDao;

@Repository
public class RequirementPivotDaoImpl
implements RequirementPivotDao {
    private static final int BATCH_SIZE = 50;
    private final DSLContext dsl;
    private final CustomFieldPivotDao customFieldPivotDao;
    private final RequirementPivotConverterService requirementPivotConverterService;

    public RequirementPivotDaoImpl(CustomFieldPivotDao customFieldPivotDao, DSLContext dsl, RequirementPivotConverterService requirementPivotConverterService) {
        this.customFieldPivotDao = customFieldPivotDao;
        this.dsl = dsl;
        this.requirementPivotConverterService = requirementPivotConverterService;
    }

    @Override
    public boolean hasRequirementByProjectId(Long projectId) {
        return this.dsl.fetchExists((Select)this.dsl.selectOne().from((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).join((TableLike)Tables.REQUIREMENT).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.REQUIREMENT.RLN_ID)).where(Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)));
    }

    @Override
    public void getRequirementByProjectId(Long projectId, Consumer<RequirementPivot> consumer) {
        Table<Record7<Long, Long, String, String, String, String, String>> customFieldValuesTable = this.customFieldPivotDao.getCustomFieldValuesTableByProjectIdAndBindableEntity(projectId, BindableEntity.REQUIREMENT_VERSION);
        Table<Record2<Long, String>> linkedToHighLevelReq = this.getLinkedRequirementToHighLevelTable(projectId);
        Table<Record2<Long, Short>> maxDepthDescendantTable = this.getMaxDepthRequirementRelationshipClosure(projectId);
        ResultQuery resultQuery = this.dsl.select((SelectField)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID, (SelectField)Tables.RESOURCE.NAME, (SelectField)Tables.RESOURCE.DESCRIPTION, (SelectField)Tables.REQUIREMENT_VERSION.RES_ID, (SelectField)Tables.REQUIREMENT_VERSION.REFERENCE, (SelectField)Tables.REQUIREMENT_VERSION.REQUIREMENT_STATUS, (SelectField)Tables.REQUIREMENT_VERSION.CRITICALITY, (SelectField)Tables.INFO_LIST_ITEM.CODE, (SelectField)Tables.RLN_RELATIONSHIP.ANCESTOR_ID, (SelectField)Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.isNotNull().as(RequirementPivotDao.IS_HIGH_LEVEL), RequirementPivotDao.RLN_ID_LINKED_HIGH_LEVEL, (SelectField)Tables.REQUIREMENT_FOLDER.RLN_ID.isNotNull().as(RequirementPivotDao.IS_FOLDER), CustomFieldPivotDao.CFV_TABLE_CF_ID, CustomFieldPivotDao.CFV_TABLE_CF_VALUE).from((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).join((TableLike)Tables.REQUIREMENT).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.REQUIREMENT.RLN_ID)).join((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID)).join((TableLike)Tables.RESOURCE).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.RESOURCE.RES_ID)).leftJoin((TableLike)Tables.HIGH_LEVEL_REQUIREMENT).on(Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT.RLN_ID)).leftJoin(linkedToHighLevelReq).on(Tables.REQUIREMENT.RLN_ID.eq(linkedToHighLevelReq.field((Field)Tables.REQUIREMENT.HIGH_LEVEL_REQUIREMENT_ID))).leftJoin((TableLike)Tables.INFO_LIST_ITEM).on(Tables.INFO_LIST_ITEM.ITEM_ID.eq((Field)Tables.REQUIREMENT_VERSION.CATEGORY)).leftJoin((TableLike)Tables.RLN_RELATIONSHIP).on(Tables.RLN_RELATIONSHIP.DESCENDANT_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID)).leftJoin((TableLike)Tables.REQUIREMENT_FOLDER).on(Tables.RLN_RELATIONSHIP.ANCESTOR_ID.eq((Field)Tables.REQUIREMENT_FOLDER.RLN_ID)).leftJoin(customFieldValuesTable).on(Tables.REQUIREMENT_VERSION.RES_ID.eq(CustomFieldPivotDao.CFV_TABLE_BOUND_ENTITY_ID)).join(maxDepthDescendantTable).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq(maxDepthDescendantTable.field((Field)Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID))).where(Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).orderBy(RequirementPivotDao.MAX_DEPTH, (OrderField)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID, (OrderField)Tables.REQUIREMENT_VERSION.VERSION_NUMBER).fetchSize(50);
        this.consumeRequirement(resultQuery, consumer);
    }

    private Table<Record2<Long, Short>> getMaxDepthRequirementRelationshipClosure(Long projectId) {
        return DSL.select((SelectField)Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID, (SelectField)DSL.max((Field)Tables.RLN_RELATIONSHIP_CLOSURE.DEPTH).as(RequirementPivotDao.MAX_DEPTH)).from((TableLike)Tables.RLN_RELATIONSHIP_CLOSURE).join((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID)).where(Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).groupBy(new GroupField[]{Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID}).asTable();
    }

    private Table<Record2<Long, String>> getLinkedRequirementToHighLevelTable(Long projectId) {
        RequirementLibraryNode linkedRln = Tables.REQUIREMENT_LIBRARY_NODE.as("LINKED_RLN_ID_TO_HIGH_LEVEL");
        return DSL.select((SelectField)Tables.REQUIREMENT.HIGH_LEVEL_REQUIREMENT_ID, (SelectField)DSL.groupConcat((Field)Tables.REQUIREMENT.RLN_ID).separator(",").as(RequirementPivotDao.RLN_ID_LINKED_HIGH_LEVEL)).from((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).join((TableLike)Tables.REQUIREMENT).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.REQUIREMENT.HIGH_LEVEL_REQUIREMENT_ID)).join((TableLike)linkedRln).on(Tables.REQUIREMENT.RLN_ID.eq((Field)linkedRln.RLN_ID)).where(Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).and(linkedRln.PROJECT_ID.eq((Object)projectId)).groupBy(new GroupField[]{Tables.REQUIREMENT.HIGH_LEVEL_REQUIREMENT_ID}).asTable();
    }

    private <T extends Record> void consumeRequirement(ResultQuery<T> resultQuery, Consumer<RequirementPivot> writingToJsonConsumer) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Stream stream = resultQuery.fetchStream();){
            Iterator iterator = stream.iterator();
            AbstractPivotObject requirementPivot = null;
            RequirementVersionPivot requirementVersionPivot = null;
            while (iterator.hasNext()) {
                Record record = (Record)iterator.next();
                if (requirementPivot == null) {
                    requirementPivot = this.requirementPivotConverterService.requirementRecordToRequirementPivot(record);
                    requirementVersionPivot = this.requirementPivotConverterService.requirementVersionRecordToRequirementVersionPivot(record);
                    this.customFieldPivotDao.appendCustomFieldValuesFromRecord(requirementVersionPivot.getCustomFields(), record);
                    ((RequirementPivot)requirementPivot).getRequirementVersions().add(requirementVersionPivot);
                    continue;
                }
                if (!requirementPivot.pivotIdToSquashId().equals(record.get((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID))) {
                    writingToJsonConsumer.accept((RequirementPivot)requirementPivot);
                    requirementPivot = this.requirementPivotConverterService.requirementRecordToRequirementPivot(record);
                    requirementVersionPivot = this.requirementPivotConverterService.requirementVersionRecordToRequirementVersionPivot(record);
                    this.customFieldPivotDao.appendCustomFieldValuesFromRecord(requirementVersionPivot.getCustomFields(), record);
                    ((RequirementPivot)requirementPivot).getRequirementVersions().add(requirementVersionPivot);
                    continue;
                }
                requirementVersionPivot = this.fillExistingRequirement((RequirementPivot)requirementPivot, requirementVersionPivot, record);
            }
            writingToJsonConsumer.accept((RequirementPivot)requirementPivot);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private RequirementVersionPivot fillExistingRequirement(RequirementPivot requirementPivot, RequirementVersionPivot requirementVersionPivot, Record record) {
        if (!requirementVersionPivot.pivotIdToSquashId().equals(record.get((Field)Tables.REQUIREMENT_VERSION.RES_ID))) {
            requirementVersionPivot = this.requirementPivotConverterService.requirementVersionRecordToRequirementVersionPivot(record);
            this.customFieldPivotDao.appendCustomFieldValuesFromRecord(requirementVersionPivot.getCustomFields(), record);
            requirementPivot.getRequirementVersions().add(requirementVersionPivot);
        } else {
            this.customFieldPivotDao.appendCustomFieldValuesFromRecord(requirementVersionPivot.getCustomFields(), record);
        }
        return requirementVersionPivot;
    }
}

