/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectexporter;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.springframework.stereotype.Service;
import org.squashtest.tm.service.internal.dto.projectimporter.JsonImportFile;
import org.squashtest.tm.service.pivot.PivotFileManager;
import org.squashtest.tm.service.pivot.projectexporter.TestCasePivotExporterService;
import org.squashtest.tm.service.pivot.projectexporter.dao.CalledTestCasePivotDao;
import org.squashtest.tm.service.pivot.projectexporter.dao.TestCasePivotDao;

@Service
public class TestCasePivotExporterServiceImpl
implements TestCasePivotExporterService {
    private final TestCasePivotDao testCasePivotDao;
    private final CalledTestCasePivotDao calledTestCasePivotDao;
    private final PivotFileManager pivotFileManager;

    public TestCasePivotExporterServiceImpl(TestCasePivotDao testCasePivotDao, CalledTestCasePivotDao calledTestCasePivotDao, PivotFileManager pivotFileManager) {
        this.testCasePivotDao = testCasePivotDao;
        this.calledTestCasePivotDao = calledTestCasePivotDao;
        this.pivotFileManager = pivotFileManager;
    }

    @Override
    public void generateTestCaseJsonFile(JsonFactory jsonFactory, ArchiveOutputStream<ZipArchiveEntry> archive, Long projectId) throws IOException {
        if (this.testCasePivotDao.hasTestCase(projectId)) {
            this.pivotFileManager.writeJson(jsonFactory, jsonGenerator -> this.handleTestCase((JsonGenerator)jsonGenerator, projectId), JsonImportFile.TEST_CASES.getFileName(), archive);
        }
    }

    private void handleTestCase(JsonGenerator jsonGenerator, Long projectId) throws IOException {
        jsonGenerator.writeFieldName("test_cases");
        jsonGenerator.writeStartArray();
        this.testCasePivotDao.getTestCaseByProjectId(projectId, this.pivotFileManager.consumerThrowingIOException(arg_0 -> ((JsonGenerator)jsonGenerator).writeObject(arg_0)));
        jsonGenerator.writeEndArray();
    }

    @Override
    public void generateCalledTestCaseJsonFile(JsonFactory jsonFactory, ArchiveOutputStream<ZipArchiveEntry> archive, Long projectId) throws IOException {
        if (this.calledTestCasePivotDao.hasCalledTestCase(projectId)) {
            this.pivotFileManager.writeJson(jsonFactory, jsonGenerator -> this.handleCalledTestCase((JsonGenerator)jsonGenerator, projectId), JsonImportFile.CALLED_TEST_CASES.getFileName(), archive);
        }
    }

    private void handleCalledTestCase(JsonGenerator jsonGenerator, Long projectId) throws IOException {
        jsonGenerator.writeFieldName("called_test_cases");
        jsonGenerator.writeStartArray();
        this.calledTestCasePivotDao.getCalledTestCaseByProjectId(projectId, this.pivotFileManager.consumerThrowingIOException(arg_0 -> ((JsonGenerator)jsonGenerator).writeObject(arg_0)));
        jsonGenerator.writeEndArray();
    }
}

