/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.testplan;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jooq.DSLContext;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.campaign.Sprint;
import org.squashtest.tm.domain.campaign.SprintReqVersion;
import org.squashtest.tm.service.campaign.IterationTestPlanManagerService;
import org.squashtest.tm.service.display.testplan.SprintTestPlanDisplayService;
import org.squashtest.tm.service.internal.display.campaign.AvailableDatasetAppender;
import org.squashtest.tm.service.internal.display.campaign.ReadUnassignedTestPlanHelper;
import org.squashtest.tm.service.internal.display.campaign.SprintReqTestPlanItemSuccessRateCalculator;
import org.squashtest.tm.service.internal.display.grid.DataRow;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.display.grid.campaign.SprintOverallExecPlanGrid;
import org.squashtest.tm.service.internal.display.grid.campaign.SprintReqVersionTestPlanGrid;
import org.squashtest.tm.service.internal.display.grid.campaign.TestPlanGridHelpers;
import org.squashtest.tm.service.internal.dto.ExecutionSummaryDto;
import org.squashtest.tm.service.internal.repository.display.utils.RequestAliasesConstants;

@Service
@Transactional(readOnly=true)
public class SprintTestPlanDisplayServiceImpl
implements SprintTestPlanDisplayService {
    private final DSLContext dslContext;
    private final AvailableDatasetAppender availableDatasetAppender;
    private final SprintReqTestPlanItemSuccessRateCalculator successRateCalculator;
    private final ReadUnassignedTestPlanHelper readUnassignedTestPlanHelper;
    private final IterationTestPlanManagerService iterationTestPlanManagerService;

    public SprintTestPlanDisplayServiceImpl(DSLContext dslContext, AvailableDatasetAppender availableDatasetAppender, SprintReqTestPlanItemSuccessRateCalculator successRateCalculator, ReadUnassignedTestPlanHelper readUnassignedTestPlanHelper, IterationTestPlanManagerService iterationTestPlanManagerService) {
        this.dslContext = dslContext;
        this.availableDatasetAppender = availableDatasetAppender;
        this.successRateCalculator = successRateCalculator;
        this.readUnassignedTestPlanHelper = readUnassignedTestPlanHelper;
        this.iterationTestPlanManagerService = iterationTestPlanManagerService;
    }

    @Override
    public GridResponse findSprintReqVersionTestPlan(Long sprintReqVersionId, GridRequest gridRequest) {
        String userToRestrictTo = this.readUnassignedTestPlanHelper.getUserToRestrictTo(sprintReqVersionId, SprintReqVersion.class.getName());
        SprintReqVersionTestPlanGrid sprintReqVersionTestPlanGrid = new SprintReqVersionTestPlanGrid(sprintReqVersionId, userToRestrictTo);
        GridResponse gridResponse = sprintReqVersionTestPlanGrid.getRows(gridRequest, this.dslContext);
        this.appendDataRows(gridResponse);
        this.availableDatasetAppender.appendAvailableDatasets(gridResponse);
        this.successRateCalculator.appendSuccessRate(gridResponse);
        return gridResponse;
    }

    @Override
    @PreAuthorize(value="hasPermission(#sprintId, 'org.squashtest.tm.domain.campaign.Sprint' ,'READ')  or hasRole('ROLE_ADMIN')")
    public GridResponse findSprintOverallExecPlan(long sprintId, GridRequest gridRequest) {
        String userToRestrictTo = this.readUnassignedTestPlanHelper.getUserToRestrictTo(sprintId, Sprint.class.getName());
        SprintOverallExecPlanGrid sprintOverallExecPlanGrid = new SprintOverallExecPlanGrid(sprintId, userToRestrictTo);
        GridResponse gridResponse = sprintOverallExecPlanGrid.getRows(gridRequest, this.dslContext);
        this.appendDataRows(gridResponse);
        this.availableDatasetAppender.appendAvailableDatasets(gridResponse);
        this.successRateCalculator.appendSuccessRate(gridResponse);
        return gridResponse;
    }

    private void appendDataRows(GridResponse gridResponse) {
        String idKey = RequestAliasesConstants.toCamelCase("TEST_PLAN_ITEM_ID");
        List<Long> itemTestPlanIds = gridResponse.getDataRows().stream().map(row -> (Long)row.getData().get(idKey)).toList();
        Map<Long, List<ExecutionSummaryDto>> executionSummaryDtoMap = this.iterationTestPlanManagerService.getLastExecutionStatuses(itemTestPlanIds);
        for (DataRow row2 : gridResponse.getDataRows()) {
            TestPlanGridHelpers.checkScriptedTestCaseHasScenario(row2);
            this.addLastExecutionStatuses(row2, executionSummaryDtoMap);
        }
    }

    private void addLastExecutionStatuses(DataRow row, Map<Long, List<ExecutionSummaryDto>> executionSummaryDtoMap) {
        Long rowItemTestPlanId = (Long)row.getData().get(RequestAliasesConstants.toCamelCase("TEST_PLAN_ITEM_ID"));
        row.addData(RequestAliasesConstants.toCamelCase("LAST_EXECUTION_STATUSES"), executionSummaryDtoMap.getOrDefault(rowItemTestPlanId, Collections.emptyList()));
    }
}

