/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.grid.filters;

import java.util.List;
import java.util.Objects;
import org.jooq.Condition;
import org.jooq.Field;
import org.squashtest.tm.service.internal.display.grid.GridFilterValue;
import org.squashtest.tm.service.internal.display.grid.filters.GridFilterConditionBuilder;

public class LikeConditionBuilder
implements GridFilterConditionBuilder {
    private final Field<?> field;
    private final GridFilterValue gridFilterValue;

    LikeConditionBuilder(Field<?> field, GridFilterValue gridFilterValue) {
        Objects.requireNonNull(field);
        Objects.requireNonNull(gridFilterValue);
        List<String> values = gridFilterValue.getValues();
        if (values.isEmpty() || Objects.isNull(values.get(0))) {
            throw new IllegalArgumentException("At least one non null value is required to build a like condition");
        }
        this.field = field;
        this.gridFilterValue = gridFilterValue;
    }

    @Override
    public Condition build() {
        List<String> values = this.gridFilterValue.getValues();
        return this.field.likeIgnoreCase("%" + values.get(0) + "%");
    }
}

