/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.customfield;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.domain.chart.Filter;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.CustomFieldBinding;
import org.squashtest.tm.domain.customfield.CustomFieldOption;
import org.squashtest.tm.domain.customfield.CustomFieldValue;
import org.squashtest.tm.domain.customfield.SingleSelectField;
import org.squashtest.tm.domain.gridconfiguration.GridColumnDisplayConfiguration;
import org.squashtest.tm.event.ChangeCustomFieldCodeEvent;
import org.squashtest.tm.exception.NameAlreadyInUseException;
import org.squashtest.tm.exception.RequiredFieldException;
import org.squashtest.tm.exception.customfield.CodeAlreadyExistsException;
import org.squashtest.tm.exception.customfield.DefaultValueRequiredException;
import org.squashtest.tm.service.annotation.SpringDaoMetaAnnotationAspect;
import org.squashtest.tm.service.chart.ChartFilterFinder;
import org.squashtest.tm.service.customfield.CustomCustomFieldManagerService;
import org.squashtest.tm.service.customfield.CustomFieldBindingModificationService;
import org.squashtest.tm.service.customfield.CustomFieldValueFinderService;
import org.squashtest.tm.service.internal.customfield.CustomCustomFieldManagerServiceImpl$AjcClosure1;
import org.squashtest.tm.service.internal.repository.CustomFieldBindingDao;
import org.squashtest.tm.service.internal.repository.CustomFieldDao;
import org.squashtest.tm.service.internal.repository.CustomFieldValueDao;
import org.squashtest.tm.service.internal.repository.GridColumnDisplayConfigurationDao;

@Transactional
@Service(value="CustomCustomFieldManagerService")
public class CustomCustomFieldManagerServiceImpl
implements CustomCustomFieldManagerService {
    @Inject
    private CustomFieldDao customFieldDao;
    @Inject
    private CustomFieldBindingDao customFieldBindingDao;
    @Inject
    private CustomFieldValueDao customFieldValueDao;
    @Inject
    private CustomFieldBindingModificationService customFieldBindingModificationService;
    @Inject
    private ApplicationEventPublisher eventPublisher;
    @Inject
    private CustomFieldValueFinderService customFieldValueFinderService;
    @Inject
    private ChartFilterFinder chartFilterFinder;
    @Inject
    private GridColumnDisplayConfigurationDao gridColumnDisplayConfigurationDao;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @Override
    public Page<CustomField> findSortedCustomFields(Pageable pageable) {
        return this.customFieldDao.findAll(pageable);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void deleteCustomField(long customFieldId) {
        CustomField customField = (CustomField)this.customFieldDao.getReferenceById(customFieldId);
        List<CustomFieldBinding> bindings = this.customFieldBindingDao.findAllByCustomFieldIdOrderByPositionAsc(customFieldId);
        ArrayList<Long> bindingIds = new ArrayList<Long>();
        for (CustomFieldBinding binding : bindings) {
            bindingIds.add(binding.getId());
        }
        if (!bindingIds.isEmpty()) {
            this.customFieldBindingModificationService.doRemoveCustomFieldBindings(bindingIds);
        }
        this.customFieldDao.delete(customField);
        this.gridColumnDisplayConfigurationDao.deleteByActiveColumnId(GridColumnDisplayConfiguration.getCufColumnNameFromCufId((Long)customFieldId));
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void deleteCustomField(List<Long> customFieldIds) {
        for (Long id : customFieldIds) {
            this.deleteCustomField(id);
        }
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public CustomField persist(CustomField newCustomField) {
        CustomField customField = newCustomField;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)customField);
        return this.persistUnsecured(newCustomField);
    }

    @Override
    public CustomField persistUnsecured(CustomField newCustomField) {
        CustomField customField = newCustomField;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)customField);
        this.checkDuplicateName(newCustomField);
        this.checkDuplicateCode(newCustomField);
        this.customFieldDao.save(newCustomField);
        return newCustomField;
    }

    private void checkDuplicateCode(CustomField newCustomField) {
        CustomField codeDuplicate = this.customFieldDao.findByCode(newCustomField.getCode());
        if (codeDuplicate != null) {
            throw new CodeAlreadyExistsException(null, newCustomField.getCode(), CustomField.class);
        }
    }

    private void checkDuplicateName(CustomField newCustomField) {
        CustomField nameDuplicate = this.customFieldDao.findByName(newCustomField.getName());
        if (nameDuplicate != null) {
            throw new NameAlreadyInUseException("CustomField", HtmlUtils.htmlEscape((String)newCustomField.getName()));
        }
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void changeName(long customFieldId, String newName) {
        String trimedNewName = newName.trim();
        CustomField customField = (CustomField)this.customFieldDao.getReferenceById(customFieldId);
        String oldName = customField.getName();
        if (StringUtils.equals((CharSequence)oldName, (CharSequence)newName)) {
            return;
        }
        if (this.customFieldDao.findByName(trimedNewName) != null) {
            throw new NameAlreadyInUseException("CustomField", trimedNewName, "name");
        }
        customField.setName(trimedNewName);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void changeOptional(Long customFieldId, boolean optional) {
        CustomField customField = (CustomField)this.customFieldDao.getReferenceById(customFieldId);
        if (!optional) {
            this.checkDefaultValueExists(customField);
            this.addDefaultValueToCustomFields(customFieldId, customField.getDefaultValue());
        }
        customField.setOptional(optional);
    }

    private void checkDefaultValueExists(CustomField customField) {
        if (customField.getDefaultValue() == null || customField.getDefaultValue().isEmpty()) {
            throw new DefaultValueRequiredException();
        }
    }

    private void addDefaultValueToCustomFields(Long customFieldId, String defaulfValue) {
        List<CustomFieldBinding> bindings = this.customFieldBindingDao.findAllByCustomFieldIdOrderByPositionAsc(customFieldId);
        for (CustomFieldBinding binding : bindings) {
            List<CustomFieldValue> values = this.customFieldValueDao.findAllCustomValuesOfBinding(binding.getId());
            for (CustomFieldValue value : values) {
                if (value.getValue() != null && !value.getValue().isEmpty()) continue;
                value.setValue(defaulfValue);
            }
        }
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void changeOptionLabel(Long customFieldId, String optionLabel, String newLabel) {
        if (newLabel == null || newLabel.trim().isEmpty()) {
            throw new RequiredFieldException("label");
        }
        SingleSelectField customField = this.customFieldDao.findSingleSelectFieldById(customFieldId);
        customField.changeOptionLabel(optionLabel, newLabel);
        this.updateCustomFieldValuesWithNewOptionLabel(optionLabel, newLabel, customFieldId);
        this.updateChartFilterValuesWithNewOptionLabel(optionLabel, newLabel, customFieldId);
    }

    private void updateCustomFieldValuesWithNewOptionLabel(String optionLabel, String newLabel, Long customFieldId) {
        List<CustomFieldValue> customFieldValues = this.customFieldValueFinderService.findAllCustomFieldValuesOfCustomField(customFieldId);
        customFieldValues.forEach(customFieldValue -> {
            if (customFieldValue.getValue().equals(optionLabel)) {
                customFieldValue.setValue(newLabel);
            }
        });
    }

    private void updateChartFilterValuesWithNewOptionLabel(String optionLabel, String newLabel, Long customFieldId) {
        List<Filter> chartFilters = this.chartFilterFinder.findFiltersByCustomFieldId(customFieldId);
        chartFilters.forEach(chartFilter -> {
            ArrayList updatedFilterValues = new ArrayList();
            chartFilter.getValues().forEach(filterValue -> {
                if (filterValue.equals(optionLabel)) {
                    updatedFilterValues.add(newLabel);
                } else {
                    updatedFilterValues.add(filterValue);
                }
            });
            chartFilter.setValues(updatedFilterValues);
        });
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void changeOptionCode(long customFieldId, String optionLabel, String newCode) {
        if (newCode == null || newCode.trim().isEmpty()) {
            throw new RequiredFieldException("code");
        }
        SingleSelectField customField = this.customFieldDao.findSingleSelectFieldById(customFieldId);
        customField.changeOptionCode(optionLabel, newCode);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void changeOptionColour(long customFieldId, String optionLabel, String newColour) {
        SingleSelectField customField = this.customFieldDao.findSingleSelectFieldById(customFieldId);
        customField.changeOptionColour(optionLabel, newColour);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void addOption(Long customFieldId, CustomFieldOption option) {
        SingleSelectField customField = this.customFieldDao.findSingleSelectFieldById(customFieldId);
        customField.addOption(option);
    }

    @Override
    public SingleSelectField findSingleSelectFieldById(Long customFieldId) {
        return this.customFieldDao.findSingleSelectFieldById(customFieldId);
    }

    @Override
    public List<CustomField> findByCodes(List<String> codes) {
        List<String> list = codes;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289(list);
        return this.customFieldDao.findByCodes(codes);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void removeOptions(long customFieldId, List<String> optionLabels) {
        optionLabels.forEach(optionLabel -> this.removeOption(customFieldId, (String)optionLabel));
    }

    private void removeOption(long customFieldId, String optionLabel) {
        SingleSelectField customField = this.customFieldDao.findSingleSelectFieldById(customFieldId);
        customField.removeOption(optionLabel);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void changeOptionsPositions(long customFieldId, int newIndex, List<String> optionsLabels) {
        SingleSelectField customField = this.customFieldDao.findSingleSelectFieldById(customFieldId);
        customField.moveOptions(newIndex, optionsLabels);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void changeCode(long customFieldId, String code) {
        CustomField field = (CustomField)this.customFieldDao.getReferenceById(customFieldId);
        this.checkDuplicateCode(field, code);
        String oldCode = field.getCode();
        field.setCode(code);
        this.eventPublisher.publishEvent((ApplicationEvent)new ChangeCustomFieldCodeEvent((Object)new String[]{oldCode, code}));
    }

    private void checkDuplicateCode(CustomField field, String newCode) {
        if (StringUtils.equals((CharSequence)field.getCode(), (CharSequence)newCode)) {
            return;
        }
        if (this.customFieldDao.findByCode(newCode) != null) {
            throw new CodeAlreadyExistsException(field.getCode(), newCode, CustomField.class);
        }
    }

    @Override
    public List<String> getAvailableTagsForEntity(String boundEntityType, List<Long> projectIds) {
        List<Long> list = projectIds;
        BindableEntity bindableEntity = BindableEntity.valueOf((String)boundEntityType);
        CustomFieldValueDao customFieldValueDao = this.customFieldValueDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)customFieldValueDao, (Object)bindableEntity, list);
        Object[] objectArray = new Object[]{this, customFieldValueDao, bindableEntity, list, joinPoint};
        CustomCustomFieldManagerServiceImpl$AjcClosure1 customCustomFieldManagerServiceImpl$AjcClosure1 = new CustomCustomFieldManagerServiceImpl$AjcClosure1(objectArray);
        return (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(customCustomFieldManagerServiceImpl$AjcClosure1.linkClosureAndJoinPoint(4112));
    }

    static {
        CustomCustomFieldManagerServiceImpl.ajc$preClinit();
    }

    static final /* synthetic */ List findAllAvailableTagForEntityInProjects_aroundBody0(CustomCustomFieldManagerServiceImpl customCustomFieldManagerServiceImpl, CustomFieldValueDao customFieldValueDao, BindableEntity bindableEntity, List list, JoinPoint joinPoint) {
        return customFieldValueDao.findAllAvailableTagForEntityInProjects(bindableEntity, list);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("CustomCustomFieldManagerServiceImpl.java", CustomCustomFieldManagerServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "findAllAvailableTagForEntityInProjects", "org.squashtest.tm.service.internal.repository.CustomFieldValueDao", "org.squashtest.tm.domain.customfield.BindableEntity:java.util.List", "arg0:arg1", "", "java.util.List"), 371);
    }
}

