/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.jooq.domain.tables;

import java.util.Arrays;
import java.util.List;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Identity;
import org.jooq.Index;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Row7;
import org.jooq.Schema;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableOptions;
import org.jooq.UniqueKey;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.TableImpl;
import org.squashtest.tm.jooq.domain.Indexes;
import org.squashtest.tm.jooq.domain.Keys;
import org.squashtest.tm.jooq.domain.Public;
import org.squashtest.tm.jooq.domain.tables.CoreUser;
import org.squashtest.tm.jooq.domain.tables.Project;
import org.squashtest.tm.jooq.domain.tables.ThirdPartyServer;
import org.squashtest.tm.jooq.domain.tables.records.StoredCredentialsRecord;

public class StoredCredentials
extends TableImpl<StoredCredentialsRecord> {
    private static final long serialVersionUID = 1L;
    public static final StoredCredentials STORED_CREDENTIALS = new StoredCredentials();
    public final TableField<StoredCredentialsRecord, Long> CREDENTIAL_ID = StoredCredentials.createField((Name)DSL.name((String)"CREDENTIAL_ID"), (DataType)SQLDataType.BIGINT.nullable(false).identity(true), (Table)this, (String)"primary key");
    public final TableField<StoredCredentialsRecord, Short> ENC_VERSION = StoredCredentials.createField((Name)DSL.name((String)"ENC_VERSION"), (DataType)SQLDataType.SMALLINT, (Table)this, (String)"the version of encryption service used. Possibly the value will remain to 1 forever.");
    public final TableField<StoredCredentialsRecord, String> ENC_CREDENTIALS = StoredCredentials.createField((Name)DSL.name((String)"ENC_CREDENTIALS"), (DataType)SQLDataType.CLOB, (Table)this, (String)"the credentials as an encrypted string");
    public final TableField<StoredCredentialsRecord, Long> AUTHENTICATED_SERVER = StoredCredentials.createField((Name)DSL.name((String)"AUTHENTICATED_SERVER"), (DataType)SQLDataType.BIGINT, (Table)this, (String)"foreign key to the server to authenticate");
    public final TableField<StoredCredentialsRecord, String> CONTENT_TYPE = StoredCredentials.createField((Name)DSL.name((String)"CONTENT_TYPE"), (DataType)SQLDataType.VARCHAR((int)4).defaultValue(DSL.field((String)"'CRED'", (DataType)SQLDataType.VARCHAR)), (Table)this, (String)"the role of the content, either CRED or CONF");
    public final TableField<StoredCredentialsRecord, Long> AUTHENTICATED_USER = StoredCredentials.createField((Name)DSL.name((String)"AUTHENTICATED_USER"), (DataType)SQLDataType.BIGINT.defaultValue(DSL.field((String)"NULL", (DataType)SQLDataType.BIGINT)), (Table)this, (String)"Foreign key to the user account that owns the credentials. A NULL value means that Squash-TM               owns the credentials (app-level credentials).");
    public final TableField<StoredCredentialsRecord, Long> PROJECT_ID = StoredCredentials.createField((Name)DSL.name((String)"PROJECT_ID"), (DataType)SQLDataType.BIGINT.defaultValue(DSL.field((String)"NULL", (DataType)SQLDataType.BIGINT)), (Table)this, (String)"Foreign key to the project bound to these credentials. NULL for app-level and user-level credentials.");
    private transient ThirdPartyServer _thirdPartyServer;
    private transient CoreUser _coreUser;
    private transient Project _project;

    public Class<StoredCredentialsRecord> getRecordType() {
        return StoredCredentialsRecord.class;
    }

    private StoredCredentials(Name alias, Table<StoredCredentialsRecord> aliased) {
        this(alias, aliased, null);
    }

    private StoredCredentials(Name alias, Table<StoredCredentialsRecord> aliased, Field<?>[] parameters) {
        super(alias, null, aliased, parameters, DSL.comment((String)""), TableOptions.table());
    }

    public StoredCredentials(String alias) {
        this(DSL.name((String)alias), (Table<StoredCredentialsRecord>)STORED_CREDENTIALS);
    }

    public StoredCredentials(Name alias) {
        this(alias, (Table<StoredCredentialsRecord>)STORED_CREDENTIALS);
    }

    public StoredCredentials() {
        this(DSL.name((String)"STORED_CREDENTIALS"), null);
    }

    public <O extends Record> StoredCredentials(Table<O> child, ForeignKey<O, StoredCredentialsRecord> key) {
        super(child, key, (Table)STORED_CREDENTIALS);
    }

    public Schema getSchema() {
        return this.aliased() ? null : Public.PUBLIC;
    }

    public List<Index> getIndexes() {
        return Arrays.asList(Indexes.IDX_FK_STORED_CREDENTIALS_AUTHENTICATED_SERVER);
    }

    public Identity<StoredCredentialsRecord, Long> getIdentity() {
        return super.getIdentity();
    }

    public UniqueKey<StoredCredentialsRecord> getPrimaryKey() {
        return Keys.PK_STORED_CREDENTIALS;
    }

    public List<UniqueKey<StoredCredentialsRecord>> getUniqueKeys() {
        return Arrays.asList(Keys.UNIQ_STORED_CREDENTIALS_SERVER_USER);
    }

    public List<ForeignKey<StoredCredentialsRecord, ?>> getReferences() {
        return Arrays.asList(Keys.FK_STORED_CREDENTIALS_AUTHENTICATED_SERVER, Keys.FK_STORED_CREDENTIALS_USER, Keys.FK_STORED_CREDENTIALS_PROJECT);
    }

    public ThirdPartyServer thirdPartyServer() {
        if (this._thirdPartyServer == null) {
            this._thirdPartyServer = new ThirdPartyServer(this, Keys.FK_STORED_CREDENTIALS_AUTHENTICATED_SERVER);
        }
        return this._thirdPartyServer;
    }

    public CoreUser coreUser() {
        if (this._coreUser == null) {
            this._coreUser = new CoreUser(this, Keys.FK_STORED_CREDENTIALS_USER);
        }
        return this._coreUser;
    }

    public Project project() {
        if (this._project == null) {
            this._project = new Project(this, Keys.FK_STORED_CREDENTIALS_PROJECT);
        }
        return this._project;
    }

    public StoredCredentials as(String alias) {
        return new StoredCredentials(DSL.name((String)alias), (Table<StoredCredentialsRecord>)this);
    }

    public StoredCredentials as(Name alias) {
        return new StoredCredentials(alias, (Table<StoredCredentialsRecord>)this);
    }

    public StoredCredentials rename(String name) {
        return new StoredCredentials(DSL.name((String)name), null);
    }

    public StoredCredentials rename(Name name) {
        return new StoredCredentials(name, null);
    }

    public Row7<Long, Short, String, Long, String, Long, Long> fieldsRow() {
        return (Row7)super.fieldsRow();
    }
}

