/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.jooq.domain.tables;

import java.util.Arrays;
import java.util.List;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Identity;
import org.jooq.Index;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Row6;
import org.jooq.Schema;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableOptions;
import org.jooq.UniqueKey;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.TableImpl;
import org.squashtest.tm.jooq.domain.Indexes;
import org.squashtest.tm.jooq.domain.Keys;
import org.squashtest.tm.jooq.domain.Public;
import org.squashtest.tm.jooq.domain.tables.ScmServer;
import org.squashtest.tm.jooq.domain.tables.records.ScmRepositoryRecord;

public class ScmRepository
extends TableImpl<ScmRepositoryRecord> {
    private static final long serialVersionUID = 1L;
    public static final ScmRepository SCM_REPOSITORY = new ScmRepository();
    public final TableField<ScmRepositoryRecord, Long> SCM_REPOSITORY_ID = ScmRepository.createField((Name)DSL.name((String)"SCM_REPOSITORY_ID"), (DataType)SQLDataType.BIGINT.nullable(false).identity(true), (Table)this, (String)"The auto-generated id of the scm repository.");
    public final TableField<ScmRepositoryRecord, Long> SERVER_ID = ScmRepository.createField((Name)DSL.name((String)"SERVER_ID"), (DataType)SQLDataType.BIGINT.nullable(false), (Table)this, (String)"The foreign key to the related SCM_SEVER");
    public final TableField<ScmRepositoryRecord, String> NAME = ScmRepository.createField((Name)DSL.name((String)"NAME"), (DataType)SQLDataType.VARCHAR((int)255).nullable(false), (Table)this, (String)"The name of the repository.");
    public final TableField<ScmRepositoryRecord, String> WORKING_BRANCH = ScmRepository.createField((Name)DSL.name((String)"WORKING_BRANCH"), (DataType)SQLDataType.VARCHAR((int)255).nullable(false), (Table)this, (String)"The name of the working branch on which SquashTM will push.");
    public final TableField<ScmRepositoryRecord, String> REPOSITORY_PATH = ScmRepository.createField((Name)DSL.name((String)"REPOSITORY_PATH"), (DataType)SQLDataType.VARCHAR((int)255).nullable(false), (Table)this, (String)"The absolute path to the local repository on the local server.");
    public final TableField<ScmRepositoryRecord, String> WORKING_FOLDER_PATH = ScmRepository.createField((Name)DSL.name((String)"WORKING_FOLDER_PATH"), (DataType)SQLDataType.VARCHAR((int)255), (Table)this, (String)"The relative path of the working folder in which SquashTM will push.");
    private transient ScmServer _scmServer;

    public Class<ScmRepositoryRecord> getRecordType() {
        return ScmRepositoryRecord.class;
    }

    private ScmRepository(Name alias, Table<ScmRepositoryRecord> aliased) {
        this(alias, aliased, null);
    }

    private ScmRepository(Name alias, Table<ScmRepositoryRecord> aliased, Field<?>[] parameters) {
        super(alias, null, aliased, parameters, DSL.comment((String)""), TableOptions.table());
    }

    public ScmRepository(String alias) {
        this(DSL.name((String)alias), (Table<ScmRepositoryRecord>)SCM_REPOSITORY);
    }

    public ScmRepository(Name alias) {
        this(alias, (Table<ScmRepositoryRecord>)SCM_REPOSITORY);
    }

    public ScmRepository() {
        this(DSL.name((String)"SCM_REPOSITORY"), null);
    }

    public <O extends Record> ScmRepository(Table<O> child, ForeignKey<O, ScmRepositoryRecord> key) {
        super(child, key, (Table)SCM_REPOSITORY);
    }

    public Schema getSchema() {
        return this.aliased() ? null : Public.PUBLIC;
    }

    public List<Index> getIndexes() {
        return Arrays.asList(Indexes.IDX_FK_SCM_REPOSITORY_SCM_SERVER);
    }

    public Identity<ScmRepositoryRecord, Long> getIdentity() {
        return super.getIdentity();
    }

    public UniqueKey<ScmRepositoryRecord> getPrimaryKey() {
        return Keys.PK_SCM_REPOSITORY;
    }

    public List<UniqueKey<ScmRepositoryRecord>> getUniqueKeys() {
        return Arrays.asList(Keys.UNIQ_SCM_REPO_NAME_BRANCH_SERVER_ID);
    }

    public List<ForeignKey<ScmRepositoryRecord, ?>> getReferences() {
        return Arrays.asList(Keys.FK_SCM_REPOSITORY_SCM_SERVER);
    }

    public ScmServer scmServer() {
        if (this._scmServer == null) {
            this._scmServer = new ScmServer(this, Keys.FK_SCM_REPOSITORY_SCM_SERVER);
        }
        return this._scmServer;
    }

    public ScmRepository as(String alias) {
        return new ScmRepository(DSL.name((String)alias), (Table<ScmRepositoryRecord>)this);
    }

    public ScmRepository as(Name alias) {
        return new ScmRepository(alias, (Table<ScmRepositoryRecord>)this);
    }

    public ScmRepository rename(String name) {
        return new ScmRepository(DSL.name((String)name), null);
    }

    public ScmRepository rename(Name name) {
        return new ScmRepository(name, null);
    }

    public Row6<Long, Long, String, String, String, String> fieldsRow() {
        return (Row6)super.fieldsRow();
    }
}

