/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.jooq.domain.tables;

import java.util.Arrays;
import java.util.List;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Index;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Row7;
import org.jooq.Schema;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableOptions;
import org.jooq.UniqueKey;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.TableImpl;
import org.squashtest.tm.jooq.domain.Indexes;
import org.squashtest.tm.jooq.domain.Keys;
import org.squashtest.tm.jooq.domain.Public;
import org.squashtest.tm.jooq.domain.tables.InfoListItem;
import org.squashtest.tm.jooq.domain.tables.Requirement;
import org.squashtest.tm.jooq.domain.tables.Resource;
import org.squashtest.tm.jooq.domain.tables.records.RequirementVersionRecord;

public class RequirementVersion
extends TableImpl<RequirementVersionRecord> {
    private static final long serialVersionUID = 1L;
    public static final RequirementVersion REQUIREMENT_VERSION = new RequirementVersion();
    public final TableField<RequirementVersionRecord, Long> RES_ID = RequirementVersion.createField((Name)DSL.name((String)"RES_ID"), (DataType)SQLDataType.BIGINT.nullable(false), (Table)this, (String)"shared key with RESOURCE table");
    public final TableField<RequirementVersionRecord, Long> REQUIREMENT_ID = RequirementVersion.createField((Name)DSL.name((String)"REQUIREMENT_ID"), (DataType)SQLDataType.BIGINT, (Table)this, (String)"FK to the requirement. Should not be null but is nullable because of cyclic association REQ - REQ_VER");
    public final TableField<RequirementVersionRecord, String> REFERENCE = RequirementVersion.createField((Name)DSL.name((String)"REFERENCE"), (DataType)SQLDataType.VARCHAR((int)50).nullable(false).defaultValue(DSL.field((String)"''", (DataType)SQLDataType.VARCHAR)), (Table)this, (String)"");
    public final TableField<RequirementVersionRecord, Integer> VERSION_NUMBER = RequirementVersion.createField((Name)DSL.name((String)"VERSION_NUMBER"), (DataType)SQLDataType.INTEGER.defaultValue(DSL.field((String)"1", (DataType)SQLDataType.INTEGER)), (Table)this, (String)"This requirement's version number");
    public final TableField<RequirementVersionRecord, String> CRITICALITY = RequirementVersion.createField((Name)DSL.name((String)"CRITICALITY"), (DataType)SQLDataType.VARCHAR((int)50).nullable(false).defaultValue(DSL.field((String)"'UNDEFINED'", (DataType)SQLDataType.VARCHAR)), (Table)this, (String)"Requirement criticality. Althought this field is a variable character, the data will be the text representation of an enumeration");
    public final TableField<RequirementVersionRecord, String> REQUIREMENT_STATUS = RequirementVersion.createField((Name)DSL.name((String)"REQUIREMENT_STATUS"), (DataType)SQLDataType.VARCHAR((int)50).nullable(false).defaultValue(DSL.field((String)"'WORK_IN_PROGRESS'", (DataType)SQLDataType.VARCHAR)), (Table)this, (String)"");
    public final TableField<RequirementVersionRecord, Long> CATEGORY = RequirementVersion.createField((Name)DSL.name((String)"CATEGORY"), (DataType)SQLDataType.BIGINT.nullable(false).defaultValue(DSL.field((String)"'1'", (DataType)SQLDataType.BIGINT)), (Table)this, (String)"foreign key to the info list item");
    private transient Resource _resource;
    private transient Requirement _requirement;
    private transient InfoListItem _infoListItem;

    public Class<RequirementVersionRecord> getRecordType() {
        return RequirementVersionRecord.class;
    }

    private RequirementVersion(Name alias, Table<RequirementVersionRecord> aliased) {
        this(alias, aliased, null);
    }

    private RequirementVersion(Name alias, Table<RequirementVersionRecord> aliased, Field<?>[] parameters) {
        super(alias, null, aliased, parameters, DSL.comment((String)""), TableOptions.table());
    }

    public RequirementVersion(String alias) {
        this(DSL.name((String)alias), (Table<RequirementVersionRecord>)REQUIREMENT_VERSION);
    }

    public RequirementVersion(Name alias) {
        this(alias, (Table<RequirementVersionRecord>)REQUIREMENT_VERSION);
    }

    public RequirementVersion() {
        this(DSL.name((String)"REQUIREMENT_VERSION"), null);
    }

    public <O extends Record> RequirementVersion(Table<O> child, ForeignKey<O, RequirementVersionRecord> key) {
        super(child, key, (Table)REQUIREMENT_VERSION);
    }

    public Schema getSchema() {
        return this.aliased() ? null : Public.PUBLIC;
    }

    public List<Index> getIndexes() {
        return Arrays.asList(Indexes.IDX_REQ_CRITICALITY, Indexes.IDX_REQ_REFERENCE, Indexes.IDX_REQ_STATUS);
    }

    public UniqueKey<RequirementVersionRecord> getPrimaryKey() {
        return Keys.PK_REQUIREMENT_VERSION;
    }

    public List<UniqueKey<RequirementVersionRecord>> getUniqueKeys() {
        return Arrays.asList(Keys.CU_VERSION_OF_REQUIREMENT);
    }

    public List<ForeignKey<RequirementVersionRecord, ?>> getReferences() {
        return Arrays.asList(Keys.FK_REQ_VERSION_RESOURCE, Keys.FK_REQUIREMENT_VERSION_REQUIREMENT, Keys.FK_REQ_NATURE);
    }

    public Resource resource() {
        if (this._resource == null) {
            this._resource = new Resource(this, Keys.FK_REQ_VERSION_RESOURCE);
        }
        return this._resource;
    }

    public Requirement requirement() {
        if (this._requirement == null) {
            this._requirement = new Requirement(this, Keys.FK_REQUIREMENT_VERSION_REQUIREMENT);
        }
        return this._requirement;
    }

    public InfoListItem infoListItem() {
        if (this._infoListItem == null) {
            this._infoListItem = new InfoListItem(this, Keys.FK_REQ_NATURE);
        }
        return this._infoListItem;
    }

    public RequirementVersion as(String alias) {
        return new RequirementVersion(DSL.name((String)alias), (Table<RequirementVersionRecord>)this);
    }

    public RequirementVersion as(Name alias) {
        return new RequirementVersion(alias, (Table<RequirementVersionRecord>)this);
    }

    public RequirementVersion rename(String name) {
        return new RequirementVersion(DSL.name((String)name), null);
    }

    public RequirementVersion rename(Name name) {
        return new RequirementVersion(name, null);
    }

    public Row7<Long, Long, String, Integer, String, String, Long> fieldsRow() {
        return (Row7)super.fieldsRow();
    }
}

