/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.jooq.domain.tables;

import java.util.Arrays;
import java.util.List;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Identity;
import org.jooq.Index;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Row5;
import org.jooq.Schema;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableOptions;
import org.jooq.UniqueKey;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.TableImpl;
import org.squashtest.tm.jooq.domain.Indexes;
import org.squashtest.tm.jooq.domain.Keys;
import org.squashtest.tm.jooq.domain.Public;
import org.squashtest.tm.jooq.domain.tables.Bugtracker;
import org.squashtest.tm.jooq.domain.tables.IssueList;
import org.squashtest.tm.jooq.domain.tables.records.IssueRecord;

public class Issue
extends TableImpl<IssueRecord> {
    private static final long serialVersionUID = 1L;
    public static final Issue ISSUE = new Issue();
    public final TableField<IssueRecord, Long> ISSUE_ID = Issue.createField((Name)DSL.name((String)"ISSUE_ID"), (DataType)SQLDataType.BIGINT.nullable(false).identity(true), (Table)this, (String)"");
    public final TableField<IssueRecord, String> REMOTE_ISSUE_ID = Issue.createField((Name)DSL.name((String)"REMOTE_ISSUE_ID"), (DataType)SQLDataType.VARCHAR((int)255).nullable(false), (Table)this, (String)"considering the different types    a bugtracker may use for its own primary keys, we use here a varchar type as it is generic enough");
    public final TableField<IssueRecord, Long> ISSUE_LIST_ID = Issue.createField((Name)DSL.name((String)"ISSUE_LIST_ID"), (DataType)SQLDataType.BIGINT.nullable(false), (Table)this, (String)"References the list of issue to which an issue belongs");
    public final TableField<IssueRecord, Long> BUGTRACKER_ID = Issue.createField((Name)DSL.name((String)"BUGTRACKER_ID"), (DataType)SQLDataType.BIGINT.nullable(false), (Table)this, (String)"Issue's bugtracker");
    public final TableField<IssueRecord, String> ADDITIONAL_DATA = Issue.createField((Name)DSL.name((String)"ADDITIONAL_DATA"), (DataType)SQLDataType.CLOB, (Table)this, (String)"Column for json info. Use it only when remote_key is not enough to fetch issue");
    private transient IssueList _issueList;
    private transient Bugtracker _bugtracker;

    public Class<IssueRecord> getRecordType() {
        return IssueRecord.class;
    }

    private Issue(Name alias, Table<IssueRecord> aliased) {
        this(alias, aliased, null);
    }

    private Issue(Name alias, Table<IssueRecord> aliased, Field<?>[] parameters) {
        super(alias, null, aliased, parameters, DSL.comment((String)""), TableOptions.table());
    }

    public Issue(String alias) {
        this(DSL.name((String)alias), (Table<IssueRecord>)ISSUE);
    }

    public Issue(Name alias) {
        this(alias, (Table<IssueRecord>)ISSUE);
    }

    public Issue() {
        this(DSL.name((String)"ISSUE"), null);
    }

    public <O extends Record> Issue(Table<O> child, ForeignKey<O, IssueRecord> key) {
        super(child, key, (Table)ISSUE);
    }

    public Schema getSchema() {
        return this.aliased() ? null : Public.PUBLIC;
    }

    public List<Index> getIndexes() {
        return Arrays.asList(Indexes.IDX_ISSUE, Indexes.ISSUE_REMOTE_ISSUE_ID_IDX);
    }

    public Identity<IssueRecord, Long> getIdentity() {
        return super.getIdentity();
    }

    public UniqueKey<IssueRecord> getPrimaryKey() {
        return Keys.PK_ISSUE;
    }

    public List<ForeignKey<IssueRecord, ?>> getReferences() {
        return Arrays.asList(Keys.FK_ISSUE_ISSUE_LIST, Keys.FK_ISSUE_BUGTRACKER);
    }

    public IssueList issueList() {
        if (this._issueList == null) {
            this._issueList = new IssueList(this, Keys.FK_ISSUE_ISSUE_LIST);
        }
        return this._issueList;
    }

    public Bugtracker bugtracker() {
        if (this._bugtracker == null) {
            this._bugtracker = new Bugtracker(this, Keys.FK_ISSUE_BUGTRACKER);
        }
        return this._bugtracker;
    }

    public Issue as(String alias) {
        return new Issue(DSL.name((String)alias), (Table<IssueRecord>)this);
    }

    public Issue as(Name alias) {
        return new Issue(alias, (Table<IssueRecord>)this);
    }

    public Issue rename(String name) {
        return new Issue(DSL.name((String)name), null);
    }

    public Issue rename(Name name) {
        return new Issue(name, null);
    }

    public Row5<Long, String, Long, Long, String> fieldsRow() {
        return (Row5)super.fieldsRow();
    }
}

