/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.jooq.domain.tables;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Identity;
import org.jooq.Index;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Row12;
import org.jooq.Schema;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableOptions;
import org.jooq.UniqueKey;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.TableImpl;
import org.squashtest.tm.jooq.domain.Indexes;
import org.squashtest.tm.jooq.domain.Keys;
import org.squashtest.tm.jooq.domain.Public;
import org.squashtest.tm.jooq.domain.tables.CoreUser;
import org.squashtest.tm.jooq.domain.tables.Project;
import org.squashtest.tm.jooq.domain.tables.TestCase;
import org.squashtest.tm.jooq.domain.tables.records.AutomationRequestRecord;

public class AutomationRequest
extends TableImpl<AutomationRequestRecord> {
    private static final long serialVersionUID = 1L;
    public static final AutomationRequest AUTOMATION_REQUEST = new AutomationRequest();
    public final TableField<AutomationRequestRecord, Long> AUTOMATION_REQUEST_ID = AutomationRequest.createField((Name)DSL.name((String)"AUTOMATION_REQUEST_ID"), (DataType)SQLDataType.BIGINT.nullable(false).identity(true), (Table)this, (String)"");
    public final TableField<AutomationRequestRecord, String> REQUEST_STATUS = AutomationRequest.createField((Name)DSL.name((String)"REQUEST_STATUS"), (DataType)SQLDataType.VARCHAR((int)25).nullable(false).defaultValue(DSL.field((String)"'WORK_IN_PROGRESS'", (DataType)SQLDataType.VARCHAR)), (Table)this, (String)"");
    public final TableField<AutomationRequestRecord, LocalDateTime> TRANSMITTED_ON = AutomationRequest.createField((Name)DSL.name((String)"TRANSMITTED_ON"), (DataType)SQLDataType.LOCALDATETIME((int)6), (Table)this, (String)"");
    public final TableField<AutomationRequestRecord, Long> ASSIGNED_TO = AutomationRequest.createField((Name)DSL.name((String)"ASSIGNED_TO"), (DataType)SQLDataType.BIGINT, (Table)this, (String)"");
    public final TableField<AutomationRequestRecord, Integer> AUTOMATION_PRIORITY = AutomationRequest.createField((Name)DSL.name((String)"AUTOMATION_PRIORITY"), (DataType)SQLDataType.INTEGER, (Table)this, (String)"");
    public final TableField<AutomationRequestRecord, LocalDateTime> ASSIGNED_ON = AutomationRequest.createField((Name)DSL.name((String)"ASSIGNED_ON"), (DataType)SQLDataType.LOCALDATETIME((int)6), (Table)this, (String)"");
    public final TableField<AutomationRequestRecord, Long> TEST_CASE_ID = AutomationRequest.createField((Name)DSL.name((String)"TEST_CASE_ID"), (DataType)SQLDataType.BIGINT, (Table)this, (String)"");
    public final TableField<AutomationRequestRecord, Long> CREATED_BY = AutomationRequest.createField((Name)DSL.name((String)"CREATED_BY"), (DataType)SQLDataType.BIGINT, (Table)this, (String)"");
    public final TableField<AutomationRequestRecord, Long> TRANSMITTED_BY = AutomationRequest.createField((Name)DSL.name((String)"TRANSMITTED_BY"), (DataType)SQLDataType.BIGINT, (Table)this, (String)"");
    public final TableField<AutomationRequestRecord, Long> PROJECT_ID = AutomationRequest.createField((Name)DSL.name((String)"PROJECT_ID"), (DataType)SQLDataType.BIGINT.nullable(false), (Table)this, (String)"fk to the host project");
    public final TableField<AutomationRequestRecord, String> CONFLICT_ASSOCIATION = AutomationRequest.createField((Name)DSL.name((String)"CONFLICT_ASSOCIATION"), (DataType)SQLDataType.CLOB.defaultValue(DSL.field((String)"NULL", (DataType)SQLDataType.CLOB)), (Table)this, (String)"");
    public final TableField<AutomationRequestRecord, Boolean> IS_MANUAL = AutomationRequest.createField((Name)DSL.name((String)"IS_MANUAL"), (DataType)SQLDataType.BOOLEAN.nullable(false).defaultValue(DSL.field((String)"FALSE", (DataType)SQLDataType.BOOLEAN)), (Table)this, (String)"");
    private transient CoreUser _fkAutomationRequestAutomationAssignedTo;
    private transient TestCase _testCase;
    private transient CoreUser _fkAutomationRequestCreatedBy;
    private transient CoreUser _fkAutomationRequestTransmittedBy;
    private transient Project _project;

    public Class<AutomationRequestRecord> getRecordType() {
        return AutomationRequestRecord.class;
    }

    private AutomationRequest(Name alias, Table<AutomationRequestRecord> aliased) {
        this(alias, aliased, null);
    }

    private AutomationRequest(Name alias, Table<AutomationRequestRecord> aliased, Field<?>[] parameters) {
        super(alias, null, aliased, parameters, DSL.comment((String)""), TableOptions.table());
    }

    public AutomationRequest(String alias) {
        this(DSL.name((String)alias), (Table<AutomationRequestRecord>)AUTOMATION_REQUEST);
    }

    public AutomationRequest(Name alias) {
        this(alias, (Table<AutomationRequestRecord>)AUTOMATION_REQUEST);
    }

    public AutomationRequest() {
        this(DSL.name((String)"AUTOMATION_REQUEST"), null);
    }

    public <O extends Record> AutomationRequest(Table<O> child, ForeignKey<O, AutomationRequestRecord> key) {
        super(child, key, (Table)AUTOMATION_REQUEST);
    }

    public Schema getSchema() {
        return this.aliased() ? null : Public.PUBLIC;
    }

    public List<Index> getIndexes() {
        return Arrays.asList(Indexes.AUTOMATION_REQUEST_ASSIGNED_TO_IDX, Indexes.AUTOMATION_REQUEST_CREATED_BY_IDX, Indexes.AUTOMATION_REQUEST_TEST_CASE_ID_IDX, Indexes.AUTOMATION_REQUEST_TRANSMITTED_BY_IDX);
    }

    public Identity<AutomationRequestRecord, Long> getIdentity() {
        return super.getIdentity();
    }

    public UniqueKey<AutomationRequestRecord> getPrimaryKey() {
        return Keys.PK_AUTOMATION_REQUEST;
    }

    public List<ForeignKey<AutomationRequestRecord, ?>> getReferences() {
        return Arrays.asList(Keys.FK_AUTOMATION_REQUEST_AUTOMATION_ASSIGNED_TO, Keys.FK_AUTOMATION_REQUEST_TEST_CASE, Keys.FK_AUTOMATION_REQUEST_CREATED_BY, Keys.FK_AUTOMATION_REQUEST_TRANSMITTED_BY, Keys.FK_AUTOMATION_REQUEST_PROJECT);
    }

    public CoreUser fkAutomationRequestAutomationAssignedTo() {
        if (this._fkAutomationRequestAutomationAssignedTo == null) {
            this._fkAutomationRequestAutomationAssignedTo = new CoreUser(this, Keys.FK_AUTOMATION_REQUEST_AUTOMATION_ASSIGNED_TO);
        }
        return this._fkAutomationRequestAutomationAssignedTo;
    }

    public TestCase testCase() {
        if (this._testCase == null) {
            this._testCase = new TestCase(this, Keys.FK_AUTOMATION_REQUEST_TEST_CASE);
        }
        return this._testCase;
    }

    public CoreUser fkAutomationRequestCreatedBy() {
        if (this._fkAutomationRequestCreatedBy == null) {
            this._fkAutomationRequestCreatedBy = new CoreUser(this, Keys.FK_AUTOMATION_REQUEST_CREATED_BY);
        }
        return this._fkAutomationRequestCreatedBy;
    }

    public CoreUser fkAutomationRequestTransmittedBy() {
        if (this._fkAutomationRequestTransmittedBy == null) {
            this._fkAutomationRequestTransmittedBy = new CoreUser(this, Keys.FK_AUTOMATION_REQUEST_TRANSMITTED_BY);
        }
        return this._fkAutomationRequestTransmittedBy;
    }

    public Project project() {
        if (this._project == null) {
            this._project = new Project(this, Keys.FK_AUTOMATION_REQUEST_PROJECT);
        }
        return this._project;
    }

    public AutomationRequest as(String alias) {
        return new AutomationRequest(DSL.name((String)alias), (Table<AutomationRequestRecord>)this);
    }

    public AutomationRequest as(Name alias) {
        return new AutomationRequest(alias, (Table<AutomationRequestRecord>)this);
    }

    public AutomationRequest rename(String name) {
        return new AutomationRequest(DSL.name((String)name), null);
    }

    public AutomationRequest rename(Name name) {
        return new AutomationRequest(name, null);
    }

    public Row12<Long, String, LocalDateTime, Long, Integer, LocalDateTime, Long, Long, Long, Long, String, Boolean> fieldsRow() {
        return (Row12)super.fieldsRow();
    }
}

