/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.infrastructure.hibernate;

import java.util.Iterator;
import org.hibernate.HibernateException;
import org.hibernate.boot.model.relational.internal.SqlStringGenerationContextImpl;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.access.NaturalIdDataAccess;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Table;
import org.hibernate.persister.entity.SingleTableEntityPersister;
import org.hibernate.persister.spi.PersisterCreationContext;

public class IterationTestPlanItemPersister
extends SingleTableEntityPersister {
    private static final String NONFORMATTED_TABLE_NAME = "ITEM_TEST_PLAN_LIST";
    private static final String NONFORMATTED_COLUMN_NAME = "ITEM_TEST_PLAN_ID";
    private String formattedTableName;
    private String[] formattedColumnName = new String[1];
    private int _cachedIndex = -1;

    public IterationTestPlanItemPersister(PersistentClass persistentClass, EntityDataAccess cacheAccessStrategy, NaturalIdDataAccess naturalIdRegionAccessStrategy, PersisterCreationContext creationContext) throws HibernateException {
        super(persistentClass, cacheAccessStrategy, naturalIdRegionAccessStrategy, creationContext);
        this.init(persistentClass, creationContext.getSessionFactory());
    }

    public String[] getSubclassTableKeyColumns(int j) {
        if (this.isTheJoinTable(j)) {
            return this.formattedColumnName;
        }
        return super.getSubclassTableKeyColumns(j);
    }

    public boolean isInverseTable(int j) {
        if (this.isTheJoinTable(j)) {
            return true;
        }
        return super.isInverseTable(j);
    }

    private boolean isTheJoinTable(int index) {
        if (this._cachedIndex == -1) {
            boolean isTheOne = this.getSubclassTableName(index).equals(this.formattedTableName);
            if (isTheOne) {
                this._cachedIndex = index;
            }
            return isTheOne;
        }
        return this._cachedIndex == index;
    }

    private void init(PersistentClass persistentClass, SessionFactoryImplementor factory) {
        this.createTableNamePattern(persistentClass, factory);
        this.createColumnName(factory);
    }

    private void createTableNamePattern(PersistentClass persistentClass, SessionFactoryImplementor factory) {
        Iterator joinIter = persistentClass.getJoinClosureIterator();
        while (joinIter.hasNext()) {
            Table tab = ((Join)joinIter.next()).getTable();
            if (!tab.getName().equalsIgnoreCase(NONFORMATTED_TABLE_NAME)) continue;
            this.formattedTableName = tab.getQualifiedName(SqlStringGenerationContextImpl.forBackwardsCompatibility((Dialect)factory.getDialect(), (String)factory.getSettings().getDefaultCatalogName(), (String)factory.getSettings().getDefaultSchemaName()));
            return;
        }
        throw new IllegalArgumentException("FixIterationToItemPersister : could not find the join table ITEM_TEST_PLAN_LIST");
    }

    private void createColumnName(SessionFactoryImplementor factory) {
        Column column = new Column(NONFORMATTED_COLUMN_NAME);
        this.formattedColumnName[0] = column.getQuotedName(factory.getDialect());
    }
}

