/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.users;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Entity
@Table(name="CORE_GROUP")
public class UsersGroup {
    public static final String USER = "squashtest.authz.group.tm.User";
    public static final String ADMIN = "squashtest.authz.group.core.Admin";
    public static final String TEST_AUTOMATION_SERVER = "squashtest.authz.group.tm.TestAutomationServer";
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="core_group_id_seq")
    @SequenceGenerator(name="core_group_id_seq", sequenceName="core_group_id_seq", allocationSize=1)
    private Long id;
    private String qualifiedName;
    private transient String simpleName;

    public UsersGroup(String qualifiedName) {
        this.qualifiedName = qualifiedName;
    }

    public UsersGroup() {
        if (this.qualifiedName != null) {
            this.calculateSimpleName();
        }
    }

    public String getSimpleName() {
        this.calculateSimpleName();
        return this.simpleName;
    }

    private void calculateSimpleName() {
        this.simpleName = this.qualifiedName.substring(this.qualifiedName.lastIndexOf(46) + 1);
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public void setQualifiedName(String qualifiedName) {
        this.qualifiedName = qualifiedName;
    }

    public Long getId() {
        return this.id;
    }
}

