/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.users;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.ManyToMany;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.domain.audit.Auditable;
import org.squashtest.tm.domain.audit.AuditableSupport;
import org.squashtest.tm.domain.users.Party;
import org.squashtest.tm.domain.users.PartyVisitor;
import org.squashtest.tm.domain.users.Team;

@Entity
@Auditable
@Table(name="CORE_USER")
@PrimaryKeyJoinColumn(name="PARTY_ID")
public class User
extends Party {
    private static final String TYPE = "USER";
    public static final int NAME_MAX_LENGTH = 50;
    @Transient
    public static final Long NO_USER_ID = 0L;
    @NotNull
    @Size(min=0, max=50)
    private @NotNull @Size(min=0, max=50) String firstName = "";
    @NotBlank
    @Size(min=0, max=50)
    private @NotBlank @Size(min=0, max=50) String lastName;
    @NotBlank
    @Size(min=0, max=50)
    private @NotBlank @Size(min=0, max=50) String login;
    @NotNull
    @Size(min=0, max=255)
    private @NotNull @Size(min=0, max=255) String email = "";
    private Boolean active = true;
    @Column(insertable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastConnectedOn;
    @NotNull
    @ManyToMany(mappedBy="members")
    private final Set<Team> teams = new HashSet<Team>();
    @Embedded
    private AuditableSupport audit = new AuditableSupport();
    @NotNull
    private boolean canDeleteFromFront = true;

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login.trim();
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public void setLastConnectedOn(Date lastConnectedOn) {
        this.lastConnectedOn = lastConnectedOn;
    }

    public Date getLastConnectedOn() {
        return this.lastConnectedOn;
    }

    @Override
    public Date getCreatedOn() {
        return this.audit.getCreatedOn();
    }

    @Override
    public String getCreatedBy() {
        return this.audit.getCreatedBy();
    }

    @Override
    public Date getLastModifiedOn() {
        return this.audit.getLastModifiedOn();
    }

    @Override
    public String getLastModifiedBy() {
        return this.audit.getLastModifiedBy();
    }

    @Override
    public boolean isSkipModifyAudit() {
        return this.audit.isSkipModifyAudit();
    }

    @Override
    public void setCreatedBy(String createdBy) {
        this.audit.setCreatedBy(createdBy);
    }

    @Override
    public void setCreatedOn(Date createdOn) {
        this.audit.setCreatedOn(createdOn);
    }

    @Override
    public void setLastModifiedBy(String lastModifiedBy) {
        this.audit.setLastModifiedBy(lastModifiedBy);
    }

    @Override
    public void setLastModifiedOn(Date lastModifiedOn) {
        this.audit.setLastModifiedOn(lastModifiedOn);
    }

    @Override
    public void setSkipModifyAudit(boolean skipModifyAudit) {
        this.audit.setSkipModifyAudit(skipModifyAudit);
    }

    public Set<Team> getTeams() {
        return this.teams;
    }

    public void addTeam(Team team) {
        this.teams.add(team);
    }

    public void removeTeams(Collection<Long> teamIds) {
        Iterator<Team> iterator = this.teams.iterator();
        while (iterator.hasNext()) {
            Team team = iterator.next();
            if (!teamIds.contains(team.getId())) continue;
            team.removeMember(this);
            iterator.remove();
        }
    }

    @Override
    public String getName() {
        return this.appendFullName(new StringBuilder()).append(" (").append(this.login).append(")").toString();
    }

    private StringBuilder appendFullName(StringBuilder builder) {
        if (StringUtils.isNotBlank((CharSequence)this.firstName)) {
            builder.append(this.firstName).append(' ');
        }
        builder.append(this.lastName);
        return builder;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void accept(PartyVisitor visitor) {
        visitor.visit(this);
    }

    public static User createFromLogin(@NotNull String login) {
        String string = login;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)string);
        User user = new User();
        user.login = login;
        user.normalize();
        return user;
    }

    public boolean loginIs(String candidate) {
        return StringUtils.equals((CharSequence)this.login, (CharSequence)candidate);
    }

    public void normalize() {
        if (StringUtils.isBlank((CharSequence)this.lastName)) {
            this.lastName = this.login;
        }
        this.firstName = this.firstName != null ? this.firstName : "";
        this.email = this.email != null ? this.email : "";
        this.active = this.active != null ? this.active : true;
    }

    public boolean isCanDeleteFromFront() {
        return this.canDeleteFromFront;
    }

    public void setCanDeleteFromFront(boolean canDeleteFromFront) {
        this.canDeleteFromFront = canDeleteFromFront;
    }
}

