/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.testcase;

import java.util.Arrays;
import java.util.List;
import org.squashtest.tm.core.foundation.i18n.Abbreviated;
import org.squashtest.tm.domain.Level;
import org.squashtest.tm.domain.LevelComparator;
import org.squashtest.tm.domain.requirement.RequirementCriticality;

public enum TestCaseImportance implements Level,
Abbreviated
{
    VERY_HIGH(1),
    HIGH(2),
    MEDIUM(3),
    LOW(4);

    private static final String I18N_KEY_ROOT = "test-case.importance.";
    private static final LevelComparator LEVEL_COMPARATOR;
    private static final String ABBR_SUFIX = ".short";
    private final int level;

    static {
        LEVEL_COMPARATOR = LevelComparator.getInstance();
    }

    private TestCaseImportance(int value) {
        this.level = value;
    }

    public String getI18nKey() {
        return I18N_KEY_ROOT + this.name();
    }

    public String getAbbreviatedI18nKey() {
        return I18N_KEY_ROOT + this.name() + ABBR_SUFIX;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    public static TestCaseImportance defaultValue() {
        return LOW;
    }

    public static TestCaseImportance deduceTestCaseImportance(List<RequirementCriticality> rCriticalities) {
        TestCaseImportance importance = LOW;
        if (!rCriticalities.isEmpty()) {
            if (rCriticalities.contains(RequirementCriticality.CRITICAL)) {
                importance = HIGH;
            } else if (rCriticalities.contains(RequirementCriticality.MAJOR)) {
                importance = MEDIUM;
            }
        }
        return importance;
    }

    public TestCaseImportance deduceNewImporanceWhenAddCriticality(RequirementCriticality newCriticality) {
        TestCaseImportance importance = TestCaseImportance.deduceTestCaseImportance(Arrays.asList(newCriticality));
        TestCaseImportance newImportance = this;
        if (LEVEL_COMPARATOR.compare(importance, this) < 0) {
            newImportance = importance;
        }
        return newImportance;
    }

    public boolean changeOfCriticalityCanChangeImportanceAuto(RequirementCriticality oldRequirementCriticality, RequirementCriticality newCriticality) {
        TestCaseImportance oldCriticalityImp = TestCaseImportance.deduceTestCaseImportance(Arrays.asList(oldRequirementCriticality));
        TestCaseImportance newCriticaltyImp = TestCaseImportance.deduceTestCaseImportance(Arrays.asList(newCriticality));
        boolean canChange = true;
        if (LEVEL_COMPARATOR.compare(this, oldCriticalityImp) < 0 && LEVEL_COMPARATOR.compare(this, newCriticaltyImp) <= 0) {
            canChange = false;
        }
        return canChange;
    }
}

