/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.testcase;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.OrderColumn;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.attachment.Attachment;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.library.NodeVisitor;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.milestone.MilestoneHolder;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.scm.ScmRepository;
import org.squashtest.tm.domain.testautomation.AutomatedTest;
import org.squashtest.tm.domain.testautomation.AutomatedTestTechnology;
import org.squashtest.tm.domain.testautomation.TestAutomationServerKind;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.CallTestStep;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.DatasetParamValue;
import org.squashtest.tm.domain.testcase.KeywordTestStep;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.domain.testcase.RequirementVersionCoverage;
import org.squashtest.tm.domain.testcase.TestCaseAutomatable;
import org.squashtest.tm.domain.testcase.TestCaseExecutionMode;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNodeVisitor;
import org.squashtest.tm.domain.testcase.TestCaseStatus;
import org.squashtest.tm.domain.testcase.TestCaseVisitor;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.domain.testcase.TestStepVisitor;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequest;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequestStatus;
import org.squashtest.tm.exception.NameAlreadyInUseException;
import org.squashtest.tm.exception.UnallowedTestAssociationException;
import org.squashtest.tm.exception.UnknownEntityException;
import org.squashtest.tm.exception.requirement.RequirementAlreadyVerifiedException;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@PrimaryKeyJoinColumn(name="TCLN_ID")
public class TestCase
extends TestCaseLibraryNode
implements AttachmentHolder,
BoundEntity,
MilestoneHolder {
    public static final String CLASS_NAME = "org.squashtest.tm.domain.testcase.TestCase";
    private static final Logger LOGGER = LoggerFactory.getLogger(TestCaseLibraryNode.class);
    private static final String SIMPLE_CLASS_NAME = "TestCase";
    public static final int MAX_REF_SIZE = 50;
    @NotNull
    @Size(min=0, max=50)
    protected @NotNull @Size(min=0, max=50) String reference = "";
    @Lob
    @Type(type="org.hibernate.type.TextType")
    protected String prerequisite = "";
    @NotNull
    @OneToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.DETACH})
    @OrderColumn(name="STEP_ORDER")
    @JoinTable(name="TEST_CASE_STEPS", joinColumns={@JoinColumn(name="TEST_CASE_ID")}, inverseJoinColumns={@JoinColumn(name="STEP_ID")})
    private List<TestStep> steps = new ArrayList<TestStep>();
    @NotNull
    @OneToMany(cascade={CascadeType.REMOVE, CascadeType.REFRESH, CascadeType.MERGE, CascadeType.DETACH})
    @JoinColumn(name="VERIFYING_TEST_CASE_ID")
    private Set<RequirementVersionCoverage> requirementVersionCoverages = new HashSet<RequirementVersionCoverage>(0);
    @NotNull
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="testCase")
    @OrderBy(value="name")
    private Set<Parameter> parameters = new HashSet<Parameter>(0);
    @NotNull
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="testCase")
    @OrderBy(value="name")
    private Set<Dataset> datasets = new HashSet<Dataset>(0);
    @NotNull
    @Enumerated(value=EnumType.STRING)
    protected TestCaseImportance importance = TestCaseImportance.LOW;
    @NotNull
    @ManyToOne
    @JoinColumn(name="TC_NATURE")
    protected InfoListItem nature = null;
    @NotNull
    @ManyToOne
    @JoinColumn(name="TC_TYPE")
    protected InfoListItem type = null;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="SCM_REPOSITORY_ID")
    private ScmRepository scmRepository = null;
    @Column(name="AUTOMATED_TEST_REFERENCE")
    private String automatedTestReference = null;
    @ManyToOne
    @JoinColumn(name="AUTOMATED_TEST_TECHNOLOGY")
    private AutomatedTestTechnology automatedTestTechnology = null;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    @Column(name="TC_STATUS")
    protected TestCaseStatus status = TestCaseStatus.WORK_IN_PROGRESS;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private TestCaseExecutionMode executionMode = TestCaseExecutionMode.MANUAL;
    @NotNull
    protected Boolean importanceAuto = Boolean.FALSE;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="TA_TEST")
    protected AutomatedTest automatedTest;
    @ManyToMany
    @JoinTable(name="MILESTONE_TEST_CASE", joinColumns={@JoinColumn(name="TEST_CASE_ID")}, inverseJoinColumns={@JoinColumn(name="MILESTONE_ID")})
    private Set<Milestone> milestones = new HashSet<Milestone>();
    @OneToOne(mappedBy="testCase", optional=true, fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    protected AutomationRequest automationRequest;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    protected TestCaseAutomatable automatable = TestCaseAutomatable.M;
    @NotNull
    @Column(name="UUID")
    @Pattern(regexp="[0-9a-fA-F]{8}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{12}")
    protected @NotNull @Pattern(regexp="[0-9a-fA-F]{8}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{12}") String uuid;

    public TestCase(Date createdOn, String createdBy) {
        TestCase audit = this;
        audit.setCreatedOn(createdOn);
        audit.setCreatedBy(createdBy);
    }

    public TestCase() {
        UUID uuid = UUID.randomUUID();
        this.setUuid(uuid.toString());
    }

    public String getReference() {
        return this.reference;
    }

    public String getFullName() {
        if (StringUtils.isBlank((CharSequence)this.reference)) {
            return this.getName();
        }
        return String.valueOf(this.getReference()) + " - " + this.getName();
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getPrerequisite() {
        return this.prerequisite;
    }

    public TestCaseExecutionMode getExecutionMode() {
        return this.executionMode;
    }

    public void setExecutionMode(@NotNull TestCaseExecutionMode executionMode) {
        TestCaseExecutionMode testCaseExecutionMode = executionMode;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)testCaseExecutionMode);
        this.executionMode = executionMode;
    }

    public List<TestStep> getSteps() {
        return this.steps;
    }

    private void notifyStepBelongsToMe(TestStep step) {
        step.setTestCase(this);
    }

    public void addStep(@NotNull TestStep step) {
        TestStep testStep = step;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)testStep);
        this.getSteps().add(step);
        this.notifyStepBelongsToMe(step);
    }

    public void addStep(int index, @NotNull TestStep step) {
        TestStep testStep = step;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)testStep);
        this.getSteps().add(index, step);
        this.notifyStepBelongsToMe(step);
    }

    public void moveStep(int stepIndex, int newIndex) {
        if (stepIndex == newIndex) {
            return;
        }
        TestStep step = this.getSteps().get(stepIndex);
        this.getSteps().remove(stepIndex);
        this.getSteps().add(newIndex, step);
    }

    public void moveSteps(int newIndex, List<TestStep> movedSteps) {
        if (!this.steps.isEmpty()) {
            this.steps.removeAll(movedSteps);
            this.steps.addAll(newIndex, movedSteps);
        }
    }

    @Override
    public void accept(TestCaseLibraryNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public TestCase createCopy() {
        TestCase copy = new TestCase();
        this.populateCopiedTestCaseAttributes(copy);
        return copy;
    }

    public void accept(TestCaseVisitor visitor) {
        visitor.visit(this);
    }

    protected void populateCopiedTestCaseAttributes(TestCase copy) {
        copy.setSimplePropertiesUsing(this);
        copy.addCopiesOfSteps(this);
        copy.addCopiesOfAttachments(this);
        copy.addCopiesOfParametersAndDatasets(this);
        copy.notifyAssociatedWithProject(this.getProject());
        copy.addCopiesOfAutomationParameters(this);
        copy.bindSameMilestones(this);
        if (this.automatedTest != null) {
            try {
                copy.setAutomatedTest(this.automatedTest);
            }
            catch (UnallowedTestAssociationException e) {
                LOGGER.error("data inconsistancy : this test case (#{}) has a script even if it's project isn't test automation enabled", (Object)this.getId(), (Object)e);
            }
        }
    }

    private void addCopiesOfParametersAndDatasets(TestCase source) {
        HashMap<Parameter, Parameter> copyByOriginalParam = new HashMap<Parameter, Parameter>(source.getParameters().size());
        for (Parameter parameter : source.getParameters()) {
            Parameter paramCopy = parameter.detachedCopy();
            paramCopy.setTestCase(this);
            copyByOriginalParam.put(parameter, paramCopy);
        }
        this.addCopiesOfDatasets(source, copyByOriginalParam);
    }

    private void addCopiesOfAutomationParameters(TestCase source) {
        this.setAutomatedTestTechnology(source.getAutomatedTestTechnology());
        this.setAutomatedTestReference(source.getAutomatedTestReference());
        this.setScmRepository(source.getScmRepository());
    }

    private void addCopiesOfDatasets(TestCase source, Map<Parameter, Parameter> copyByOriginalParam) {
        for (Dataset dataset : source.getDatasets()) {
            Dataset datasetCopy = new Dataset(dataset.getName(), this);
            for (DatasetParamValue datasetParamValue : dataset.getParameterValues()) {
                Parameter datasetParamValueCopyParam = this.getParameterToLinkedTheCopiedDatasetParamValueTo(source, copyByOriginalParam, datasetParamValue);
                String datasetParamValueCopyParamValue = datasetParamValue.getParamValue();
                new DatasetParamValue(datasetParamValueCopyParam, datasetCopy, datasetParamValueCopyParamValue);
            }
        }
    }

    private Parameter getParameterToLinkedTheCopiedDatasetParamValueTo(TestCase source, Map<Parameter, Parameter> copyByOriginalParam, DatasetParamValue datasetParamValue) {
        Parameter datasetParamValueCopyParam = datasetParamValue.getParameter().getTestCase().getId().equals(source.getId()) ? copyByOriginalParam.get(datasetParamValue.getParameter()) : datasetParamValue.getParameter();
        return datasetParamValueCopyParam;
    }

    private void addCopiesOfAttachments(TestCase source) {
        for (Attachment tcAttach : source.getAttachmentList().getAllAttachments()) {
            Attachment atCopy = tcAttach.shallowCopy();
            this.getAttachmentList().addAttachment(atCopy);
        }
    }

    private void addCopiesOfSteps(TestCase source) {
        for (TestStep testStep : source.getSteps()) {
            this.addStep(testStep.createCopy());
        }
    }

    private void bindSameMilestones(TestCase src) {
        for (Milestone m : src.getMilestones()) {
            this.bindMilestone(m);
        }
    }

    private void setSimplePropertiesUsing(TestCase source) {
        this.setName(source.getName());
        this.setDescription(source.getDescription());
        this.setPrerequisite(source.getPrerequisite());
        this.executionMode = source.getExecutionMode();
        this.importance = source.getImportance();
        this.nature = source.getNature();
        this.type = source.getType();
        this.status = source.getStatus();
        this.reference = source.getReference();
        this.importanceAuto = source.isImportanceAuto();
    }

    public int getPositionOfStep(long stepId) throws UnknownEntityException {
        int i = 0;
        while (i < this.getSteps().size()) {
            if (this.getSteps().get(i).getId() == stepId) {
                return i;
            }
            ++i;
        }
        throw new UnknownEntityException(stepId, TestStep.class);
    }

    @Override
    public String getClassSimpleName() {
        return SIMPLE_CLASS_NAME;
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    public TestCaseImportance getImportance() {
        return this.importance;
    }

    public void setImportance(@NotNull TestCaseImportance weight) {
        TestCaseImportance testCaseImportance = weight;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)testCaseImportance);
        this.importance = weight;
    }

    public InfoListItem getNature() {
        return this.nature;
    }

    public void setNature(@NotNull InfoListItem nature) {
        InfoListItem infoListItem = nature;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)infoListItem);
        this.nature = nature;
    }

    public InfoListItem getType() {
        return this.type;
    }

    public void setType(@NotNull InfoListItem type) {
        InfoListItem infoListItem = type;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)infoListItem);
        this.type = type;
    }

    public TestCaseStatus getStatus() {
        return this.status;
    }

    public void setStatus(@NotNull TestCaseStatus status) {
        TestCaseStatus testCaseStatus = status;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)testCaseStatus);
        this.status = status;
    }

    public void setPrerequisite(@NotNull String prerequisite) {
        String string = prerequisite;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)string);
        this.prerequisite = prerequisite;
    }

    public Boolean isImportanceAuto() {
        return this.importanceAuto;
    }

    public void setImportanceAuto(@NotNull Boolean importanceAuto) {
        Boolean bl = importanceAuto;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)bl);
        this.importanceAuto = importanceAuto;
    }

    public AutomatedTest getAutomatedTest() {
        return this.automatedTest;
    }

    public void setAutomatedTest(AutomatedTest testAutomationTest) {
        if (!this.getProject().isBoundToTestAutomationProject(testAutomationTest.getProject())) {
            throw new UnallowedTestAssociationException();
        }
        this.automatedTest = testAutomationTest;
    }

    public void removeAutomatedScript() {
        this.automatedTest = null;
    }

    public boolean isAutomated() {
        if (this.getProject().isAllowAutomationWorkflow()) {
            return this.isAutomatedInWorkflow();
        }
        return this.isActuallyAutomated();
    }

    protected boolean isAutomatedInWorkflow() {
        return this.isActuallyAutomated() && this.hasAutomatedStatus();
    }

    protected boolean isActuallyAutomated() {
        return this.isSquashTFAutomated() || this.isSquashAutomAutomated();
    }

    public boolean isSquashTFAutomated() {
        return this.getProject().isTestAutomationEnabled() && this.getProject().getTestAutomationServer().getKind().equals((Object)TestAutomationServerKind.jenkins) && this.automatedTest != null;
    }

    public boolean isSquashAutomAutomated() {
        return this.getProject().isTestAutomationEnabled() && this.getProject().getTestAutomationServer().getKind().equals((Object)TestAutomationServerKind.squashAutom) && this.hasSquashAutomFieldsFilled();
    }

    private boolean hasSquashAutomFieldsFilled() {
        return this.automatedTestTechnology != null && !StringUtils.isEmpty((CharSequence)this.automatedTestReference) && this.scmRepository != null;
    }

    public boolean hasAutomatedStatus() {
        return TestCaseAutomatable.Y.equals(this.automatable) && AutomationRequestStatus.AUTOMATED.equals(this.automationRequest.getRequestStatus());
    }

    @Override
    public Long getBoundEntityId() {
        return this.getId();
    }

    @Override
    public BindableEntity getBoundEntityType() {
        return BindableEntity.TEST_CASE;
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    public List<ActionTestStep> getActionSteps() {
        ArrayList<ActionTestStep> result = new ArrayList<ActionTestStep>();
        ActionStepRetreiver retriever = new ActionStepRetreiver(result);
        for (TestStep step : this.getSteps()) {
            step.accept(retriever);
        }
        return retriever.getResult();
    }

    public List<CallTestStep> getCallSteps() {
        return this.getSteps().stream().filter(testStep -> testStep instanceof CallTestStep).map(testStep -> (CallTestStep)testStep).collect(Collectors.toList());
    }

    public Set<RequirementVersion> getVerifiedRequirementVersions() {
        HashSet<RequirementVersion> verified = new HashSet<RequirementVersion>();
        for (RequirementVersionCoverage coverage : this.requirementVersionCoverages) {
            verified.add(coverage.getVerifiedRequirementVersion());
        }
        return Collections.unmodifiableSet(verified);
    }

    public void checkRequirementNotVerified(RequirementVersionCoverage requirementVersionCoverage, RequirementVersion version) throws RequirementAlreadyVerifiedException {
        Requirement req = version.getRequirement();
        for (RequirementVersionCoverage coverage : this.requirementVersionCoverages) {
            RequirementVersion verified;
            if (coverage.equals(requirementVersionCoverage) || (verified = coverage.getVerifiedRequirementVersion()) == null || !req.equals(verified.getRequirement()) || version.getVersionNumber() != verified.getVersionNumber()) continue;
            throw new RequirementAlreadyVerifiedException(version, this);
        }
    }

    public void addRequirementCoverage(RequirementVersionCoverage requirementVersionCoverage) {
        this.requirementVersionCoverages.add(requirementVersionCoverage);
    }

    public List<RequirementVersionCoverage> createRequirementVersionCoveragesForCopy(TestCase copy) {
        ArrayList<RequirementVersionCoverage> createdCoverages = new ArrayList<RequirementVersionCoverage>();
        for (RequirementVersionCoverage coverage : this.requirementVersionCoverages) {
            RequirementVersionCoverage covCopy = coverage.copyForTestCase(copy);
            if (covCopy == null) continue;
            createdCoverages.add(covCopy);
        }
        return createdCoverages;
    }

    public boolean hasStep(TestStep step) {
        for (TestStep step2 : this.steps) {
            if (!step2.getId().equals(step.getId())) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public void removeRequirementVersionCoverage(RequirementVersionCoverage requirementVersionCoverage) {
        this.requirementVersionCoverages.remove(requirementVersionCoverage);
    }

    public Set<RequirementVersionCoverage> getRequirementVersionCoverages() {
        return this.requirementVersionCoverages;
    }

    public boolean verifies(RequirementVersion rVersion) {
        for (RequirementVersionCoverage coverage : this.requirementVersionCoverages) {
            if (!coverage.getVerifiedRequirementVersion().getId().equals(rVersion.getId())) continue;
            return true;
        }
        return false;
    }

    public void checkRequirementNotVerified(RequirementVersion version) throws RequirementAlreadyVerifiedException {
        Requirement req = version.getRequirement();
        for (RequirementVersion verified : this.getVerifiedRequirementVersions()) {
            if (verified == null || !req.equals(verified.getRequirement())) continue;
            throw new RequirementAlreadyVerifiedException(version, this);
        }
    }

    public Set<Parameter> getParameters() {
        return this.parameters;
    }

    protected void addParameter(@NotNull Parameter parameter) {
        Parameter parameter2 = parameter;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)parameter2);
        Parameter homonyme = this.findParameterByName(parameter.getName());
        if (homonyme != null && !homonyme.equals(parameter)) {
            throw new NameAlreadyInUseException(Parameter.class.getSimpleName(), parameter.getName());
        }
        this.parameters.add(parameter);
    }

    public Set<Dataset> getDatasets() {
        return this.datasets;
    }

    public void addDataset(@NotNull Dataset dataset) {
        Dataset dataset2 = dataset;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)dataset2);
        this.datasets.add(dataset);
    }

    public void removeDataset(@NotNull Dataset dataset) {
        Dataset dataset2 = dataset;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)dataset2);
        this.datasets.remove(dataset);
    }

    @Override
    public Set<Milestone> getMilestones() {
        return this.milestones;
    }

    public Set<Milestone> getAllMilestones() {
        HashSet<Milestone> allMilestones = new HashSet<Milestone>();
        allMilestones.addAll(this.milestones);
        for (RequirementVersionCoverage coverage : this.requirementVersionCoverages) {
            allMilestones.addAll(coverage.getVerifiedRequirementVersion().getMilestones());
        }
        return allMilestones;
    }

    @Override
    public void bindMilestone(Milestone milestone) {
        if (this.isMilestoneBindable(milestone)) {
            this.milestones.add(milestone);
        }
    }

    private boolean isMilestoneBindable(Milestone milestone) {
        return milestone.isBindableToObject() && this.getProject().isBoundToMilestone(milestone);
    }

    @Override
    public void unbindMilestone(Milestone milestone) {
        this.unbindMilestone(milestone.getId());
    }

    @Override
    public void unbindMilestone(Long milestoneId) {
        Iterator<Milestone> iter = this.milestones.iterator();
        while (iter.hasNext()) {
            Milestone m = iter.next();
            if (!m.getId().equals(milestoneId)) continue;
            iter.remove();
            break;
        }
    }

    public void clearMilestones() {
        this.milestones.clear();
    }

    @Override
    public boolean isMemberOf(Milestone milestone) {
        return this.milestones.contains(milestone);
    }

    public Parameter findParameterByName(String name) {
        for (Parameter parameter : this.parameters) {
            if (!parameter.getName().equals(name)) continue;
            return parameter;
        }
        return null;
    }

    public Set<String> findUsedParamsNamesInSteps() {
        HashSet<String> result = new HashSet<String>();
        for (ActionTestStep step : this.getActionSteps()) {
            result.addAll(step.findUsedParametersNames());
        }
        return result;
    }

    public List<String> findUsedParamsNamesInPrerequisite() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(Parameter.findUsedParameterNamesInString(this.prerequisite));
        return result;
    }

    public static TestCase createBlankTestCase() {
        TestCase res = new TestCase();
        TestCase.setAttributesAsNullForBlankTestCase(res);
        return res;
    }

    protected static void setAttributesAsNullForBlankTestCase(TestCase res) {
        res.importanceAuto = null;
        res.prerequisite = null;
        res.reference = null;
        res.nature = null;
        res.type = null;
        res.importance = null;
        res.status = null;
        res.automatable = null;
        res.uuid = null;
    }

    public Boolean getImportanceAuto() {
        return this.isImportanceAuto();
    }

    @Override
    public void unbindAllMilestones() {
        this.milestones.clear();
    }

    public boolean isModifiable() {
        return this.milestonesAllowEdit();
    }

    private boolean milestonesAllowEdit() {
        for (Milestone m : this.getAllMilestones()) {
            if (m.getStatus().isAllowObjectModification()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Boolean doMilestonesAllowCreation() {
        return Milestone.allowsCreationOrDeletion(this.getAllMilestones());
    }

    @Override
    public Boolean doMilestonesAllowEdition() {
        return Milestone.allowsEdition(this.getAllMilestones());
    }

    public void bindAllMilsetones(List<Milestone> ms) {
        this.milestones.addAll(ms);
    }

    @Override
    public EntityReference toEntityReference() {
        return new EntityReference(EntityType.TEST_CASE, this.getId());
    }

    public AutomationRequest getAutomationRequest() {
        return this.automationRequest;
    }

    public void setAutomationRequest(AutomationRequest automationRequest) {
        this.automationRequest = automationRequest;
    }

    public TestCaseAutomatable getAutomatable() {
        return this.automatable;
    }

    public void setAutomatable(@NotNull TestCaseAutomatable automatable) {
        TestCaseAutomatable testCaseAutomatable = automatable;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)testCaseAutomatable);
        this.automatable = automatable;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public ScmRepository getScmRepository() {
        return this.scmRepository;
    }

    public void setScmRepository(ScmRepository scmRepository) {
        this.scmRepository = scmRepository;
    }

    public String getAutomatedTestReference() {
        return this.automatedTestReference;
    }

    public void setAutomatedTestReference(String automatedTestReference) {
        this.automatedTestReference = automatedTestReference;
    }

    public AutomatedTestTechnology getAutomatedTestTechnology() {
        return this.automatedTestTechnology;
    }

    public void setAutomatedTestTechnology(AutomatedTestTechnology automatedTestTechnology) {
        this.automatedTestTechnology = automatedTestTechnology;
    }

    private static final class ActionStepRetreiver
    implements TestStepVisitor {
        private List<ActionTestStep> result;

        private ActionStepRetreiver(List<ActionTestStep> result) {
            this.result = result;
        }

        private List<ActionTestStep> getResult() {
            return this.result;
        }

        @Override
        public void visit(ActionTestStep visited) {
            this.result.add(visited);
        }

        @Override
        public void visit(CallTestStep visited) {
        }

        @Override
        public void visit(KeywordTestStep visited) {
        }
    }
}

