/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.testcase;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.Type;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.core.foundation.lang.Wrapped;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.RelatedToAuditable;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.testcase.DatasetParamValue;
import org.squashtest.tm.domain.testcase.KeywordTestCase;
import org.squashtest.tm.domain.testcase.ParameterNameInStepUpdater;
import org.squashtest.tm.domain.testcase.ScriptedTestCase;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseVisitor;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.exception.DuplicateNameException;
import org.squashtest.tm.exception.testcase.InvalidParameterNameException;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"NAME", "TEST_CASE_ID"})})
public class Parameter
implements Identified,
RelatedToAuditable {
    private static final String PARAM_REGEXP = "[A-Za-z0-9_-]{1,255}";
    public static final String NAME_REGEXP = "^[A-Za-z0-9_-]{1,255}$";
    public static final int MIN_NAME_SIZE = 1;
    public static final int MAX_NAME_SIZE = 255;
    public static final String USAGE_PREFIX = "${";
    public static final String USAGE_SUFFIX = "}";
    public static final String USAGE_PATTERN = "\\Q${\\E([A-Za-z0-9_-]{1,255})\\Q}\\E";
    public static final String LOOSE_PATTERN = "\\Q${\\E([^}]+)\\Q}\\E";
    @Id
    @Column(name="PARAM_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="parameter_param_id_seq")
    @SequenceGenerator(name="parameter_param_id_seq", sequenceName="parameter_param_id_seq", allocationSize=1)
    private Long id;
    @NotBlank
    @Pattern(regexp="^[A-Za-z0-9_-]{1,255}$")
    @Size(min=1, max=255)
    private @NotBlank @Pattern(regexp="^[A-Za-z0-9_-]{1,255}$") @Size(min=1, max=255) String name;
    @Lob
    @Type(type="org.hibernate.type.TextType")
    private String description = "";
    @ManyToOne
    @JoinColumn(name="TEST_CASE_ID", referencedColumnName="TCLN_ID")
    private TestCase testCase;
    @OneToMany(mappedBy="parameter", cascade={CascadeType.REMOVE})
    private List<DatasetParamValue> datasetParamValues = new ArrayList<DatasetParamValue>();

    public Parameter() {
    }

    public Parameter(String name) {
        this();
        this.name = name;
    }

    public Parameter(String name, @NotNull TestCase testCase) {
        this(name);
        this.testCase = testCase;
        this.testCase.addParameter(this);
    }

    public Parameter detachedCopy() {
        Parameter p = new Parameter(this.name);
        p.setDescription(this.description);
        return p;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        if (this.name != null) {
            this.setNotNullName(newName);
        } else {
            this.name = newName;
        }
    }

    private void setNotNullName(String newName) {
        if (!this.name.equals(newName)) {
            TestCase thisTestCase = this.testCase;
            if (thisTestCase != null) {
                this.checkForHomonymes(newName, thisTestCase);
                this.updateParamNameInSteps(newName, thisTestCase);
                this.updateParamNameInPrerequisite(newName, thisTestCase);
            }
            this.name = newName;
        }
    }

    private void checkForHomonymes(String newName, TestCase thisTestCase) {
        Parameter homonyme = thisTestCase.findParameterByName(newName);
        if (homonyme != null) {
            throw new DuplicateNameException(this.name, newName);
        }
    }

    private void updateParamNameInSteps(String newName, TestCase thisTestCase) {
        for (TestStep step : thisTestCase.getSteps()) {
            step.accept(new ParameterNameInStepUpdater(this.name, newName));
        }
    }

    private void updateParamNameInPrerequisite(String newName, TestCase thisTestCase) {
        String prerequisite = thisTestCase.getPrerequisite();
        String oldParamPattern = Parameter.getParamStringAsUsedInStandardTestCase(this.name);
        String newParamPattern = Parameter.getParamStringAsUsedInStandardTestCase(newName);
        String newPrerequisite = prerequisite.replace(oldParamPattern, newParamPattern);
        this.testCase.setPrerequisite(newPrerequisite);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(@NotNull String description) {
        String string = description;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)string);
        this.description = description;
    }

    public TestCase getTestCase() {
        return this.testCase;
    }

    public void setTestCase(@NotNull TestCase testCase) {
        TestCase testCase2 = testCase;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)testCase2);
        this.testCase = testCase;
        this.testCase.addParameter(this);
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public String getParamStringAsUsedInStep() {
        final Wrapped paramStringAsUsedInStep = new Wrapped();
        TestCaseVisitor visitor = new TestCaseVisitor(){

            @Override
            public void visit(TestCase testCase) {
                paramStringAsUsedInStep.setValue((Object)Parameter.getParamStringAsUsedInStandardTestCase(Parameter.this.name));
            }

            @Override
            public void visit(KeywordTestCase keywordTestCase) {
                paramStringAsUsedInStep.setValue((Object)Parameter.getParamStringAsUsedInKeywordTestCase(Parameter.this.name));
            }

            @Override
            public void visit(ScriptedTestCase scriptedTestCase) {
                throw new IllegalArgumentException("Scripted Test Case doesn't have any parameter.");
            }
        };
        this.testCase.accept(visitor);
        return (String)paramStringAsUsedInStep.getValue();
    }

    protected static String getParamStringAsUsedInStandardTestCase(String parameterName) {
        return USAGE_PREFIX + parameterName + USAGE_SUFFIX;
    }

    protected static String getParamStringAsUsedInKeywordTestCase(String parameterName) {
        return "<" + parameterName + ">";
    }

    public static List<String> findUsedParameterNamesInString(String content) {
        ArrayList<String> paramNames = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)content)) {
            return paramNames;
        }
        java.util.regex.Pattern pattern = java.util.regex.Pattern.compile(LOOSE_PATTERN);
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            String paramName = matcher.group(1);
            if (paramName.matches(PARAM_REGEXP)) {
                paramNames.add(paramName);
                continue;
            }
            throw new InvalidParameterNameException("invalid parameter name " + paramName);
        }
        return paramNames;
    }

    public static boolean hasInvalidParameterNamesInString(String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return false;
        }
        java.util.regex.Pattern pattern = java.util.regex.Pattern.compile(LOOSE_PATTERN);
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            String paramName = matcher.group(1);
            if (paramName.matches(PARAM_REGEXP)) continue;
            return true;
        }
        return false;
    }

    public static Parameter createBlankParameter() {
        Parameter res = new Parameter();
        res.name = null;
        res.description = null;
        return res;
    }

    @Override
    public List<AuditableMixin> getAssociatedAuditableList() {
        return Collections.singletonList(this.testCase);
    }
}

