/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.testcase;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;
import org.springframework.context.MessageSource;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.domain.attachment.Attachment;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.attachment.AttachmentList;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.KeywordTestCase;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.domain.testcase.RequirementVersionCoverage;
import org.squashtest.tm.domain.testcase.ScriptedTestCase;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseVisitor;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.domain.testcase.TestStepVisitor;

@Entity
@PrimaryKeyJoinColumn(name="TEST_STEP_ID")
@NamedQueries(value={@NamedQuery(name="ActionTestSteps.fetchWithAttachmentReferences", query="select distinct step from ActionTestStep step inner join fetch step.attachmentList attachmentList left join fetch attachmentList.attachments attachements where step.testCase.id in (:testCaseIds)")})
public class ActionTestStep
extends TestStep
implements BoundEntity,
AttachmentHolder {
    @Lob
    @Type(type="org.hibernate.type.TextType")
    private String action = "";
    @Lob
    @Type(type="org.hibernate.type.TextType")
    private String expectedResult = "";
    @OneToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.DETACH, CascadeType.REMOVE})
    @JoinColumn(name="ATTACHMENT_LIST_ID")
    private final AttachmentList attachmentList = new AttachmentList();
    @ManyToMany(cascade={CascadeType.REFRESH, CascadeType.DETACH})
    @JoinTable(name="VERIFYING_STEPS", joinColumns={@JoinColumn(name="TEST_STEP_ID", updatable=false, insertable=false)}, inverseJoinColumns={@JoinColumn(name="REQUIREMENT_VERSION_COVERAGE_ID", updatable=false, insertable=false)})
    private Set<RequirementVersionCoverage> requirementVersionCoverages = new HashSet<RequirementVersionCoverage>();

    public ActionTestStep() {
    }

    public ActionTestStep(String action, String expectedResult) {
        this.action = action;
        this.expectedResult = expectedResult;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getAction() {
        return this.action;
    }

    public void setExpectedResult(String expectedResult) {
        this.expectedResult = expectedResult;
    }

    public String getExpectedResult() {
        return this.expectedResult;
    }

    @Override
    public ActionTestStep createCopy() {
        ActionTestStep newTestStep = new ActionTestStep();
        newTestStep.action = this.action;
        newTestStep.expectedResult = this.expectedResult;
        newTestStep.setTestCase(this.getTestCase());
        for (Attachment tcAttach : this.getAttachmentList().getAllAttachments()) {
            Attachment clone = tcAttach.shallowCopy();
            newTestStep.getAttachmentList().addAttachment(clone);
        }
        return newTestStep;
    }

    @Override
    public void accept(TestStepVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void setTestCase(@NotNull TestCase testCase) {
        TestCase testCase2 = testCase;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)testCase2);
        TestCaseVisitor testCaseVisitor = new TestCaseVisitor(){

            @Override
            public void visit(TestCase testCase) {
            }

            @Override
            public void visit(KeywordTestCase keywordTestCase) {
                throw new IllegalArgumentException("Cannot add an Action Test Step outside a Test Case");
            }

            @Override
            public void visit(ScriptedTestCase scriptedTestCase) {
                throw new IllegalArgumentException("Cannot add an Action Test Step outside a Test Case");
            }
        };
        testCase.accept(testCaseVisitor);
        super.setTestCase(testCase);
    }

    @Override
    public AttachmentList getAttachmentList() {
        return this.attachmentList;
    }

    @Override
    public List<ExecutionStep> createExecutionSteps(Dataset dataset, MessageSource messageSource, Locale locale) {
        ArrayList<ExecutionStep> returnList = new ArrayList<ExecutionStep>(1);
        ExecutionStep exec = new ExecutionStep(this, dataset);
        returnList.add(exec);
        return returnList;
    }

    public Set<Attachment> getAllAttachments() {
        return this.attachmentList.getAllAttachments();
    }

    @Override
    public Long getBoundEntityId() {
        return this.getId();
    }

    @Override
    public BindableEntity getBoundEntityType() {
        return BindableEntity.TEST_STEP;
    }

    @Override
    public Project getProject() {
        return this.getTestCase().getProject();
    }

    public void removeRequirementVersionCoverage(RequirementVersionCoverage requirementVersionCoverage) {
        this.requirementVersionCoverages.remove(requirementVersionCoverage);
    }

    public Set<RequirementVersionCoverage> getRequirementVersionCoverages() {
        return Collections.unmodifiableSet(this.requirementVersionCoverages);
    }

    public void addRequirementVersionCoverage(RequirementVersionCoverage requirementVersionCoverage) {
        this.requirementVersionCoverages.add(requirementVersionCoverage);
    }

    public Set<RequirementVersion> getVerifiedRequirementVersions() {
        HashSet<RequirementVersion> verified = new HashSet<RequirementVersion>();
        for (RequirementVersionCoverage coverage : this.requirementVersionCoverages) {
            verified.add(coverage.getVerifiedRequirementVersion());
        }
        return Collections.unmodifiableSet(verified);
    }

    public Set<String> findUsedParametersNames() {
        HashSet<String> result = new HashSet<String>();
        if (this.action != null) {
            result.addAll(Parameter.findUsedParameterNamesInString(this.action));
        }
        if (this.expectedResult != null) {
            result.addAll(Parameter.findUsedParameterNamesInString(this.expectedResult));
        }
        return result;
    }

    public static ActionTestStep createBlankActionStep() {
        return new ActionTestStep(null, null);
    }
}

