/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.testautomation;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Where;
import org.hibernate.validator.constraints.URL;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.audit.Auditable;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.audit.AuditableSupport;
import org.squashtest.tm.domain.environmenttag.AutomationEnvironmentTag;
import org.squashtest.tm.domain.servers.ThirdPartyServer;
import org.squashtest.tm.domain.testautomation.TestAutomationServerKind;

@NamedQueries(value={@NamedQuery(name="TestAutomationServer.findByUrlAndLogin", query="from TestAutomationServer where baseURL = :url and login = :login"), @NamedQuery(name="testAutomationServer.findAllHostedProjects", query="select p from TestAutomationProject p join p.server s where s.id = :serverId"), @NamedQuery(name="testAutomationServer.hasBoundProjects", query="select count(*) from TestAutomationProject where server.id = :serverId"), @NamedQuery(name="testAutomationServer.dereferenceProjects", query="update GenericProject set testAutomationServer = null where testAutomationServer.id = :serverId"), @NamedQuery(name="testAutomationServer.deleteServer", query="delete from TestAutomationServer serv where serv.id = :serverId")})
@Entity
@Auditable
@PrimaryKeyJoinColumn(name="SERVER_ID")
public class TestAutomationServer
extends ThirdPartyServer
implements Identified,
AuditableMixin {
    private static final TestAutomationServerKind DEFAULT_KIND = TestAutomationServerKind.jenkins;
    @Column
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private TestAutomationServerKind kind = DEFAULT_KIND;
    @Column(name="MANUAL_SLAVE_SELECTION")
    private boolean manualSlaveSelection = false;
    @Column(name="DESCRIPTION")
    private String description = "";
    @ElementCollection
    @CollectionTable(name="AUTOMATION_ENVIRONMENT_TAG", joinColumns={@JoinColumn(name="ENTITY_ID")})
    @Where(clause="ENTITY_TYPE = 'TEST_AUTOMATION_SERVER'")
    private List<AutomationEnvironmentTag> environmentTags = new ArrayList<AutomationEnvironmentTag>();
    @Embedded
    private AuditableSupport audit = new AuditableSupport();
    @URL
    @Size(max=255)
    @Column(name="OBSERVER_URL")
    private @URL @Size(max=255) String observerUrl;
    @URL
    @Size(max=255)
    @Column(name="EVENT_BUS_URL")
    private @URL @Size(max=255) String eventBusUrl;

    public TestAutomationServer() {
    }

    public TestAutomationServerKind getKind() {
        return this.kind;
    }

    public TestAutomationServer(TestAutomationServerKind kind) {
        this.kind = kind;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("TestAutomationServer{");
        sb.append("id=").append(this.getId());
        sb.append(", name='").append(this.getName()).append('\'');
        sb.append(", url='").append(this.getUrl()).append('\'');
        sb.append(", kind='").append((Object)this.kind).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public boolean isManualSlaveSelection() {
        return this.manualSlaveSelection;
    }

    public void setManualSlaveSelection(boolean manualSlaveSelection) {
        this.manualSlaveSelection = manualSlaveSelection;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Date getCreatedOn() {
        return this.audit.getCreatedOn();
    }

    @Override
    public String getCreatedBy() {
        return this.audit.getCreatedBy();
    }

    @Override
    public Date getLastModifiedOn() {
        return this.audit.getLastModifiedOn();
    }

    @Override
    public String getLastModifiedBy() {
        return this.audit.getLastModifiedBy();
    }

    @Override
    public boolean isSkipModifyAudit() {
        return this.audit.isSkipModifyAudit();
    }

    @Override
    public void setCreatedBy(String createdBy) {
        this.audit.setCreatedBy(createdBy);
    }

    @Override
    public void setCreatedOn(Date createdOn) {
        this.audit.setCreatedOn(createdOn);
    }

    @Override
    public void setLastModifiedBy(String lastModifiedBy) {
        this.audit.setLastModifiedBy(lastModifiedBy);
    }

    @Override
    public void setLastModifiedOn(Date lastModifiedOn) {
        this.audit.setLastModifiedOn(lastModifiedOn);
    }

    @Override
    public void setSkipModifyAudit(boolean skipModifyAudit) {
        this.audit.setSkipModifyAudit(skipModifyAudit);
    }

    public TestAutomationServer createCopy() {
        TestAutomationServer testAutomationServerCopy = new TestAutomationServer(this.getKind());
        testAutomationServerCopy.setName(this.getName());
        testAutomationServerCopy.setUrl(this.getUrl());
        testAutomationServerCopy.setDescription(this.getDescription());
        testAutomationServerCopy.setManualSlaveSelection(this.isManualSlaveSelection());
        return testAutomationServerCopy;
    }

    public List<AutomationEnvironmentTag> getEnvironmentTags() {
        return this.environmentTags;
    }

    public void setEnvironmentTags(List<AutomationEnvironmentTag> environmentTags) {
        this.environmentTags = environmentTags;
    }

    public String getObserverUrl() {
        return this.observerUrl;
    }

    public void setObserverUrl(String observerUrl) {
        this.observerUrl = observerUrl;
    }

    public String getEventBusUrl() {
        return this.eventBusUrl;
    }

    public void setEventBusUrl(String eventBusUrl) {
        this.eventBusUrl = eventBusUrl;
    }
}

