/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.requirement;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.attachment.Attachment;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.event.RequirementModificationEventPublisherAspect;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.milestone.MilestoneHolder;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementCriticality;
import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.domain.requirement.RequirementVersionImportMemento;
import org.squashtest.tm.domain.requirement.RequirementVersionLink;
import org.squashtest.tm.domain.resource.Resource;
import org.squashtest.tm.domain.testcase.RequirementVersionCoverage;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.exception.requirement.IllegalRequirementModificationException;
import org.squashtest.tm.exception.requirement.MilestoneForbidModificationException;
import org.squashtest.tm.exception.requirement.RequirementVersionNotLinkableException;
import org.squashtest.tm.security.annotation.InheritsAcls;

@Entity
@PrimaryKeyJoinColumn(name="RES_ID")
@InheritsAcls(constrainedClass=Requirement.class, collectionName="versions")
public class RequirementVersion
extends Resource
implements BoundEntity,
MilestoneHolder {
    public static final int MAX_REF_SIZE = 50;
    @NotNull
    @OneToMany(cascade={CascadeType.REMOVE, CascadeType.REFRESH, CascadeType.DETACH}, mappedBy="requirementVersion", fetch=FetchType.LAZY)
    private Set<RequirementVersionLink> requirementVersionLinks = new HashSet<RequirementVersionLink>();
    @NotNull
    @OneToMany(cascade={CascadeType.REMOVE, CascadeType.REFRESH, CascadeType.MERGE, CascadeType.DETACH}, mappedBy="verifiedRequirementVersion", fetch=FetchType.LAZY)
    private Set<RequirementVersionCoverage> requirementVersionCoverages = new HashSet<RequirementVersionCoverage>();
    @NotNull
    @Size(min=0, max=50)
    private @NotNull @Size(min=0, max=50) String reference = "";
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private RequirementCriticality criticality = RequirementCriticality.UNDEFINED;
    @NotNull
    @ManyToOne
    @JoinColumn(name="CATEGORY")
    private InfoListItem category;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    @Column(name="REQUIREMENT_STATUS")
    private RequirementStatus status = RequirementStatus.WORK_IN_PROGRESS;
    @NotNull
    @ManyToOne
    @JoinColumn(name="REQUIREMENT_ID")
    private Requirement requirement;
    private int versionNumber = 1;
    @ManyToMany
    @JoinTable(name="MILESTONE_REQ_VERSION", joinColumns={@JoinColumn(name="REQ_VERSION_ID")}, inverseJoinColumns={@JoinColumn(name="MILESTONE_ID")})
    private Set<Milestone> milestones = new HashSet<Milestone>();
    @Transient
    private PropertiesSetter propertiesSetter = new PropertiesSetter();
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    @Override
    public void setName(String name) {
        String string = name;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        RequirementVersion.setName_aroundBody1$advice(this, string, joinPoint, RequirementModificationEventPublisherAspect.aspectOf(), (ProceedingJoinPoint)joinPoint, this, string);
    }

    @Override
    public void setDescription(String description) {
        String string = description;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        RequirementVersion.setDescription_aroundBody3$advice(this, string, joinPoint, RequirementModificationEventPublisherAspect.aspectOf(), (ProceedingJoinPoint)joinPoint, this, string);
    }

    public Set<TestCase> getVerifyingTestCases() {
        HashSet<TestCase> testCases = new HashSet<TestCase>();
        for (RequirementVersionCoverage coverage : this.requirementVersionCoverages) {
            testCases.add(coverage.getVerifyingTestCase());
        }
        return Collections.unmodifiableSet(testCases);
    }

    public void checkLinkable() {
        if (!this.status.isRequirementLinkable()) {
            throw new RequirementVersionNotLinkableException(this);
        }
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        String string = reference;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string);
        RequirementVersion.setReference_aroundBody5$advice(this, string, joinPoint, RequirementModificationEventPublisherAspect.aspectOf(), (ProceedingJoinPoint)joinPoint, this, string);
    }

    public String getFullName() {
        if (StringUtils.isBlank((CharSequence)this.reference)) {
            return this.getName();
        }
        return String.valueOf(this.getReference()) + " - " + this.getName();
    }

    public RequirementCriticality getCriticality() {
        return this.criticality;
    }

    public void setCriticality(RequirementCriticality criticality) {
        RequirementCriticality requirementCriticality = criticality;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)requirementCriticality);
        RequirementVersion.setCriticality_aroundBody7$advice(this, requirementCriticality, joinPoint, RequirementModificationEventPublisherAspect.aspectOf(), (ProceedingJoinPoint)joinPoint, this, requirementCriticality);
    }

    public InfoListItem getCategory() {
        return this.category;
    }

    public void setCategory(InfoListItem category) {
        InfoListItem infoListItem = category;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)infoListItem);
        RequirementVersion.setCategory_aroundBody9$advice(this, infoListItem, joinPoint, RequirementModificationEventPublisherAspect.aspectOf(), (ProceedingJoinPoint)joinPoint, this, infoListItem);
    }

    public void updateCategoryWhithoutCheck(InfoListItem category) {
        this.category = category;
    }

    public void setStatus(RequirementStatus status) {
        RequirementStatus requirementStatus = status;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)requirementStatus);
        RequirementVersion.setStatus_aroundBody11$advice(this, requirementStatus, joinPoint, RequirementModificationEventPublisherAspect.aspectOf(), (ProceedingJoinPoint)joinPoint, this, requirementStatus);
    }

    public RequirementStatus getStatus() {
        return this.status;
    }

    private void checkModifiable() {
        if (!this.milestonesAllowEdit()) {
            throw new MilestoneForbidModificationException();
        }
        if (!this.isModifiable()) {
            throw new IllegalRequirementModificationException();
        }
    }

    private void checkStatusAccess(RequirementStatus newStatus) {
        if (!this.status.getAllowsStatusUpdate() || !this.status.isTransitionLegal(newStatus)) {
            throw new IllegalRequirementModificationException();
        }
    }

    public boolean isLinkable() {
        return this.getStatus().isRequirementLinkable();
    }

    public boolean isModifiable() {
        return this.getStatus().isRequirementModifiable() && this.milestonesAllowEdit();
    }

    public Requirement getRequirement() {
        return this.requirement;
    }

    public int getVersionNumber() {
        return this.versionNumber;
    }

    public void setVersionNumber(int versionNumber) {
        int n = versionNumber;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        RequirementVersion.setVersionNumber_aroundBody13$advice(this, n, joinPoint, RequirementModificationEventPublisherAspect.aspectOf(), (ProceedingJoinPoint)joinPoint, this, Conversions.intObject((int)n));
    }

    void setRequirement(Requirement requirement) {
        this.requirement = requirement;
    }

    public RequirementVersion createPastableCopy() {
        return this.createPastableCopy(null);
    }

    public RequirementVersion createPastableCopy(Requirement requirement) {
        RequirementVersion copy = this.createBaselineCopy();
        copy.status = this.status;
        copy.versionNumber = this.versionNumber;
        copy.requirement = requirement;
        this.attachCopiesOfAttachmentsTo(copy);
        copy.bindSameMilestones(this);
        return copy;
    }

    private void attachCopiesOfAttachmentsTo(RequirementVersion copy) {
        for (Attachment attachment : this.getAttachmentList().getAllAttachments()) {
            copy.getAttachmentList().addAttachment(attachment.shallowCopy());
        }
    }

    private RequirementVersion createBaselineCopy() {
        RequirementVersion copy = new RequirementVersion();
        copy.setName(this.getName());
        copy.setDescription(this.getDescription());
        copy.criticality = this.criticality;
        copy.category = this.category;
        copy.reference = this.reference;
        return copy;
    }

    private void bindSameMilestones(RequirementVersion src) {
        for (Milestone m : src.getMilestones()) {
            this.bindMilestone(m);
        }
    }

    public boolean isNotObsolete() {
        return RequirementStatus.OBSOLETE != this.status;
    }

    RequirementVersion createNextVersion() {
        RequirementVersion nextVersion = this.createBaselineCopy();
        nextVersion.status = RequirementStatus.WORK_IN_PROGRESS;
        nextVersion.versionNumber = this.versionNumber + 1;
        nextVersion.requirement = null;
        this.attachCopiesOfAttachmentsTo(nextVersion);
        return nextVersion;
    }

    public static RequirementVersion createFromMemento(@NotNull RequirementVersionImportMemento memento) {
        RequirementVersionImportMemento requirementVersionImportMemento = memento;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)requirementVersionImportMemento);
        RequirementVersion res = new RequirementVersion();
        res.setName(memento.getName());
        res.setDescription(memento.getDescription());
        res.criticality = memento.getCriticality();
        res.category = memento.formatCategory();
        res.milestones = memento.getMilestones();
        res.reference = memento.getReference();
        res.status = memento.getStatus();
        RequirementVersion audit = res;
        audit.setCreatedOn(memento.getCreatedOn());
        audit.setCreatedBy(memento.getCreatedBy());
        return res;
    }

    @Override
    public Long getBoundEntityId() {
        return this.getId();
    }

    @Override
    public BindableEntity getBoundEntityType() {
        return BindableEntity.REQUIREMENT_VERSION;
    }

    @Override
    public Project getProject() {
        if (this.requirement != null) {
            return this.requirement.getProject();
        }
        return null;
    }

    public void addRequirementCoverage(RequirementVersionCoverage coverage) {
        this.requirementVersionCoverages.add(coverage);
    }

    public RequirementVersionCoverage getRequirementVersionCoverageOrNullFor(TestCase testCase) {
        for (RequirementVersionCoverage coverage : this.requirementVersionCoverages) {
            if (!coverage.getVerifyingTestCase().getId().equals(testCase.getId())) continue;
            return coverage;
        }
        return null;
    }

    public void removeRequirementVersionCoverage(RequirementVersionCoverage requirementVersionCoverage) {
        this.checkLinkable();
        this.requirementVersionCoverages.remove(requirementVersionCoverage);
    }

    public List<RequirementVersionCoverage> createRequirementVersionCoveragesForCopy(RequirementVersion copyVersion) {
        ArrayList<RequirementVersionCoverage> copies = new ArrayList<RequirementVersionCoverage>();
        for (RequirementVersionCoverage coverage : this.requirementVersionCoverages) {
            RequirementVersionCoverage verifyingCopy = coverage.copyForRequirementVersion(copyVersion);
            copies.add(verifyingCopy);
        }
        return copies;
    }

    public List<RequirementVersionLink> createRequirementVersionLinksForCopy(RequirementVersion copyVersion) {
        ArrayList<RequirementVersionLink> copies = new ArrayList<RequirementVersionLink>();
        for (RequirementVersionLink link : this.requirementVersionLinks) {
            RequirementVersionLink linkCopy = link.copyForRequirementVersion(copyVersion);
            copies.add(linkCopy);
        }
        return copies;
    }

    public Set<RequirementVersionCoverage> getRequirementVersionCoverages() {
        return Collections.unmodifiableSet(this.requirementVersionCoverages);
    }

    public Set<RequirementVersionLink> getRequirementVersionLinks() {
        return Collections.unmodifiableSet(this.requirementVersionLinks);
    }

    @Override
    public Set<Milestone> getMilestones() {
        return this.milestones;
    }

    @Override
    public boolean isMemberOf(Milestone milestone) {
        return this.milestones.contains(milestone);
    }

    @Override
    public void bindMilestone(Milestone milestone) {
        if (this.isMilestoneBindable(milestone)) {
            this.milestones.add(milestone);
        }
    }

    private boolean isMilestoneBindable(Milestone milestone) {
        return milestone.isBindableToObject() && this.getProject().isBoundToMilestone(milestone);
    }

    @Override
    public void unbindMilestone(Milestone milestone) {
        this.unbindMilestone(milestone.getId());
    }

    @Override
    public void unbindMilestone(Long milestoneId) {
        Iterator<Milestone> iter = this.milestones.iterator();
        while (iter.hasNext()) {
            Milestone m = iter.next();
            if (!m.getId().equals(milestoneId)) continue;
            iter.remove();
            break;
        }
    }

    private boolean milestonesAllowEdit() {
        for (Milestone m : this.milestones) {
            if (m.getStatus().isAllowObjectModification()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void unbindAllMilestones() {
        this.milestones.clear();
    }

    @Override
    public Boolean doMilestonesAllowCreation() {
        Boolean allowed = Boolean.TRUE;
        for (Milestone m : this.getMilestones()) {
            if (m.getStatus().isAllowObjectCreateAndDelete()) continue;
            allowed = Boolean.FALSE;
            break;
        }
        return allowed;
    }

    @Override
    public Boolean doMilestonesAllowEdition() {
        Boolean allowed = Boolean.TRUE;
        for (Milestone m : this.getMilestones()) {
            if (m.getStatus().isAllowObjectModification()) continue;
            allowed = Boolean.FALSE;
            break;
        }
        return allowed;
    }

    @Override
    public EntityReference toEntityReference() {
        return new EntityReference(EntityType.REQUIREMENT_VERSION, this.getId());
    }

    public PropertiesSetter getPropertySetter() {
        return this.propertiesSetter;
    }

    static {
        RequirementVersion.ajc$preClinit();
    }

    private static final /* synthetic */ void setName_aroundBody0(RequirementVersion ajc$this, String name, JoinPoint joinPoint) {
        super.setName(name);
    }

    private static final /* synthetic */ void setName_aroundBody1$advice(RequirementVersion ajc$this, String name, JoinPoint thisJoinPoint, RequirementModificationEventPublisherAspect ajc$aspectInstance, ProceedingJoinPoint joinPoint, RequirementVersion req, Object newValue) {
        if (RequirementModificationEventPublisherAspect.ajc$inlineAccessMethod$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$eventsAreEnabled(ajc$aspectInstance, req)) {
            String propertyName = RequirementModificationEventPublisherAspect.ajc$inlineAccessMethod$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$extractModifiedPropertyName(ajc$aspectInstance, (JoinPoint)joinPoint);
            Object oldValue = RequirementModificationEventPublisherAspect.ajc$inlineAccessMethod$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$readOldValue(ajc$aspectInstance, req, propertyName);
            Object[] objectArray = new Object[]{req, newValue};
            ProceedingJoinPoint proceedingJoinPoint = joinPoint;
            RequirementVersion.setName_aroundBody0((RequirementVersion)objectArray[0], (String)objectArray[1], (JoinPoint)proceedingJoinPoint);
            if (RequirementModificationEventPublisherAspect.ajc$inlineAccessMethod$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$requirementWasModified(ajc$aspectInstance, oldValue, newValue)) {
                RequirementModificationEventPublisherAspect.ajc$inlineAccessMethod$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$raiseSimplePropertyEvent(ajc$aspectInstance, req, propertyName, oldValue, newValue);
            }
        } else {
            Object[] objectArray = new Object[]{req, newValue};
            ProceedingJoinPoint proceedingJoinPoint = joinPoint;
            RequirementVersion.setName_aroundBody0((RequirementVersion)objectArray[0], (String)objectArray[1], (JoinPoint)proceedingJoinPoint);
        }
    }

    private static final /* synthetic */ void setDescription_aroundBody2(RequirementVersion ajc$this, String description, JoinPoint joinPoint) {
        ajc$this.checkModifiable();
        super.setDescription(description);
    }

    private static final /* synthetic */ void setDescription_aroundBody3$advice(RequirementVersion ajc$this, String description, JoinPoint thisJoinPoint, RequirementModificationEventPublisherAspect ajc$aspectInstance, ProceedingJoinPoint joinPoint, RequirementVersion req, Object newValue) {
        if (RequirementModificationEventPublisherAspect.ajc$inlineAccessMethod$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$eventsAreEnabled(ajc$aspectInstance, req)) {
            String propertyName = RequirementModificationEventPublisherAspect.ajc$inlineAccessMethod$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$extractModifiedPropertyName(ajc$aspectInstance, (JoinPoint)joinPoint);
            Object oldValue = RequirementModificationEventPublisherAspect.ajc$inlineAccessMethod$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$readOldValue(ajc$aspectInstance, req, propertyName);
            Object[] objectArray = new Object[]{req, newValue};
            ProceedingJoinPoint proceedingJoinPoint = joinPoint;
            RequirementVersion.setDescription_aroundBody2((RequirementVersion)objectArray[0], (String)objectArray[1], (JoinPoint)proceedingJoinPoint);
            if (RequirementModificationEventPublisherAspect.ajc$inlineAccessMethod$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$requirementWasModified(ajc$aspectInstance, oldValue, newValue)) {
                RequirementModificationEventPublisherAspect.ajc$inlineAccessMethod$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$raiseLargePropertyEvent(ajc$aspectInstance, req, propertyName, oldValue, newValue);
            }
        } else {
            Object[] objectArray = new Object[]{req, newValue};
            ProceedingJoinPoint proceedingJoinPoint = joinPoint;
            RequirementVersion.setDescription_aroundBody2((RequirementVersion)objectArray[0], (String)objectArray[1], (JoinPoint)proceedingJoinPoint);
        }
    }

    private static final /* synthetic */ void setReference_aroundBody4(RequirementVersion ajc$this, String reference, JoinPoint joinPoint) {
        ajc$this.checkModifiable();
        ajc$this.reference = reference;
    }

    private static final /* synthetic */ void setReference_aroundBody5$advice(RequirementVersion ajc$this, String reference, JoinPoint thisJoinPoint, RequirementModificationEventPublisherAspect ajc$aspectInstance, ProceedingJoinPoint joinPoint, RequirementVersion req, Object newValue) {
        if (RequirementModificationEventPublisherAspect.ajc$inlineAccessMethod$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$eventsAreEnabled(ajc$aspectInstance, req)) {
            String propertyName = RequirementModificationEventPublisherAspect.ajc$inlineAccessMethod$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$extractModifiedPropertyName(ajc$aspectInstance, (JoinPoint)joinPoint);
            Object oldValue = RequirementModificationEventPublisherAspect.ajc$inlineAccessMethod$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$readOldValue(ajc$aspectInstance, req, propertyName);
            Object[] objectArray = new Object[]{req, newValue};
            ProceedingJoinPoint proceedingJoinPoint = joinPoint;
            RequirementVersion.setReference_aroundBody4((RequirementVersion)objectArray[0], (String)objectArray[1], (JoinPoint)proceedingJoinPoint);
            if (RequirementModificationEventPublisherAspect.ajc$inlineAccessMethod$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$requirementWasModified(ajc$aspectInstance, oldValue, newValue)) {
                RequirementModificationEventPublisherAspect.ajc$inlineAccessMethod$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$raiseSimplePropertyEvent(ajc$aspectInstance, req, propertyName, oldValue, newValue);
            }
        } else {
            Object[] objectArray = new Object[]{req, newValue};
            ProceedingJoinPoint proceedingJoinPoint = joinPoint;
            RequirementVersion.setReference_aroundBody4((RequirementVersion)objectArray[0], (String)objectArray[1], (JoinPoint)proceedingJoinPoint);
        }
    }

    private static final /* synthetic */ void setCriticality_aroundBody6(RequirementVersion ajc$this, RequirementCriticality criticality, JoinPoint joinPoint) {
        ajc$this.checkModifiable();
        ajc$this.criticality = criticality;
    }

    private static final /* synthetic */ void setCriticality_aroundBody7$advice(RequirementVersion ajc$this, RequirementCriticality criticality, JoinPoint thisJoinPoint, RequirementModificationEventPublisherAspect ajc$aspectInstance, ProceedingJoinPoint joinPoint, RequirementVersion req, Object newValue) {
        if (RequirementModificationEventPublisherAspect.ajc$inlineAccessMethod$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$eventsAreEnabled(ajc$aspectInstance, req)) {
            String propertyName = RequirementModificationEventPublisherAspect.ajc$inlineAccessMethod$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$extractModifiedPropertyName(ajc$aspectInstance, (JoinPoint)joinPoint);
            Object oldValue = RequirementModificationEventPublisherAspect.ajc$inlineAccessMethod$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$readOldValue(ajc$aspectInstance, req, propertyName);
            Object[] objectArray = new Object[]{req, newValue};
            ProceedingJoinPoint proceedingJoinPoint = joinPoint;
            RequirementVersion.setCriticality_aroundBody6((RequirementVersion)objectArray[0], (RequirementCriticality)objectArray[1], (JoinPoint)proceedingJoinPoint);
            if (RequirementModificationEventPublisherAspect.ajc$inlineAccessMethod$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$requirementWasModified(ajc$aspectInstance, oldValue, newValue)) {
                RequirementModificationEventPublisherAspect.ajc$inlineAccessMethod$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$raiseSimplePropertyEvent(ajc$aspectInstance, req, propertyName, oldValue, newValue);
            }
        } else {
            Object[] objectArray = new Object[]{req, newValue};
            ProceedingJoinPoint proceedingJoinPoint = joinPoint;
            RequirementVersion.setCriticality_aroundBody6((RequirementVersion)objectArray[0], (RequirementCriticality)objectArray[1], (JoinPoint)proceedingJoinPoint);
        }
    }

    private static final /* synthetic */ void setCategory_aroundBody8(RequirementVersion ajc$this, InfoListItem category, JoinPoint joinPoint) {
        ajc$this.checkModifiable();
        ajc$this.category = category;
    }

    private static final /* synthetic */ void setCategory_aroundBody9$advice(RequirementVersion ajc$this, InfoListItem category, JoinPoint thisJoinPoint, RequirementModificationEventPublisherAspect ajc$aspectInstance, ProceedingJoinPoint joinPoint, RequirementVersion req, Object newValue) {
        if (RequirementModificationEventPublisherAspect.ajc$inlineAccessMethod$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$eventsAreEnabled(ajc$aspectInstance, req)) {
            String propertyName = RequirementModificationEventPublisherAspect.ajc$inlineAccessMethod$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$extractModifiedPropertyName(ajc$aspectInstance, (JoinPoint)joinPoint);
            Object oldValue = RequirementModificationEventPublisherAspect.ajc$inlineAccessMethod$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$readOldValue(ajc$aspectInstance, req, propertyName);
            Object[] objectArray = new Object[]{req, newValue};
            ProceedingJoinPoint proceedingJoinPoint = joinPoint;
            RequirementVersion.setCategory_aroundBody8((RequirementVersion)objectArray[0], (InfoListItem)objectArray[1], (JoinPoint)proceedingJoinPoint);
            if (RequirementModificationEventPublisherAspect.ajc$inlineAccessMethod$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$requirementWasModified(ajc$aspectInstance, oldValue, newValue)) {
                RequirementModificationEventPublisherAspect.ajc$inlineAccessMethod$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$raiseSimplePropertyEvent(ajc$aspectInstance, req, propertyName, oldValue, newValue);
            }
        } else {
            Object[] objectArray = new Object[]{req, newValue};
            ProceedingJoinPoint proceedingJoinPoint = joinPoint;
            RequirementVersion.setCategory_aroundBody8((RequirementVersion)objectArray[0], (InfoListItem)objectArray[1], (JoinPoint)proceedingJoinPoint);
        }
    }

    private static final /* synthetic */ void setStatus_aroundBody10(RequirementVersion ajc$this, RequirementStatus status, JoinPoint joinPoint) {
        ajc$this.checkStatusAccess(status);
        ajc$this.status = status;
    }

    private static final /* synthetic */ void setStatus_aroundBody11$advice(RequirementVersion ajc$this, RequirementStatus status, JoinPoint thisJoinPoint, RequirementModificationEventPublisherAspect ajc$aspectInstance, ProceedingJoinPoint joinPoint, RequirementVersion req, Object newValue) {
        if (RequirementModificationEventPublisherAspect.ajc$inlineAccessMethod$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$eventsAreEnabled(ajc$aspectInstance, req)) {
            String propertyName = RequirementModificationEventPublisherAspect.ajc$inlineAccessMethod$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$extractModifiedPropertyName(ajc$aspectInstance, (JoinPoint)joinPoint);
            Object oldValue = RequirementModificationEventPublisherAspect.ajc$inlineAccessMethod$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$readOldValue(ajc$aspectInstance, req, propertyName);
            Object[] objectArray = new Object[]{req, newValue};
            ProceedingJoinPoint proceedingJoinPoint = joinPoint;
            RequirementVersion.setStatus_aroundBody10((RequirementVersion)objectArray[0], (RequirementStatus)objectArray[1], (JoinPoint)proceedingJoinPoint);
            if (RequirementModificationEventPublisherAspect.ajc$inlineAccessMethod$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$requirementWasModified(ajc$aspectInstance, oldValue, newValue)) {
                RequirementModificationEventPublisherAspect.ajc$inlineAccessMethod$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$raiseSimplePropertyEvent(ajc$aspectInstance, req, propertyName, oldValue, newValue);
            }
        } else {
            Object[] objectArray = new Object[]{req, newValue};
            ProceedingJoinPoint proceedingJoinPoint = joinPoint;
            RequirementVersion.setStatus_aroundBody10((RequirementVersion)objectArray[0], (RequirementStatus)objectArray[1], (JoinPoint)proceedingJoinPoint);
        }
    }

    private static final /* synthetic */ void setVersionNumber_aroundBody13$advice(RequirementVersion ajc$this, int versionNumber, JoinPoint thisJoinPoint, RequirementModificationEventPublisherAspect ajc$aspectInstance, ProceedingJoinPoint joinPoint, RequirementVersion req, Object newValue) {
        if (RequirementModificationEventPublisherAspect.ajc$inlineAccessMethod$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$eventsAreEnabled(ajc$aspectInstance, req)) {
            String propertyName = RequirementModificationEventPublisherAspect.ajc$inlineAccessMethod$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$extractModifiedPropertyName(ajc$aspectInstance, (JoinPoint)joinPoint);
            Object oldValue = RequirementModificationEventPublisherAspect.ajc$inlineAccessMethod$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$readOldValue(ajc$aspectInstance, req, propertyName);
            Object[] objectArray = new Object[]{req, newValue};
            ProceedingJoinPoint proceedingJoinPoint = joinPoint;
            ((RequirementVersion)objectArray[0]).versionNumber = Conversions.intValue((Object)objectArray[1]);
            if (RequirementModificationEventPublisherAspect.ajc$inlineAccessMethod$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$requirementWasModified(ajc$aspectInstance, oldValue, newValue)) {
                RequirementModificationEventPublisherAspect.ajc$inlineAccessMethod$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$org_squashtest_tm_domain_event_RequirementModificationEventPublisherAspect$raiseSimplePropertyEvent(ajc$aspectInstance, req, propertyName, oldValue, newValue);
            }
        } else {
            Object[] objectArray = new Object[]{req, newValue};
            ProceedingJoinPoint proceedingJoinPoint = joinPoint;
            ((RequirementVersion)objectArray[0]).versionNumber = Conversions.intValue((Object)objectArray[1]);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("RequirementVersion.java", RequirementVersion.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setName", "org.squashtest.tm.domain.requirement.RequirementVersion", "java.lang.String", "name", "", "void"), 126);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setDescription", "org.squashtest.tm.domain.requirement.RequirementVersion", "java.lang.String", "description", "", "void"), 136);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setReference", "org.squashtest.tm.domain.requirement.RequirementVersion", "java.lang.String", "reference", "", "void"), 173);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setCriticality", "org.squashtest.tm.domain.requirement.RequirementVersion", "org.squashtest.tm.domain.requirement.RequirementCriticality", "criticality", "", "void"), 202);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setCategory", "org.squashtest.tm.domain.requirement.RequirementVersion", "org.squashtest.tm.domain.infolist.InfoListItem", "category", "", "void"), 219);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setStatus", "org.squashtest.tm.domain.requirement.RequirementVersion", "org.squashtest.tm.domain.requirement.RequirementStatus", "status", "", "void"), 233);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setVersionNumber", "org.squashtest.tm.domain.requirement.RequirementVersion", "int", "versionNumber", "", "void"), 290);
    }

    public class PropertiesSetter {
        public void setName(String name) {
            RequirementVersion.super.setName(name);
        }

        public void setDescription(String description) {
            RequirementVersion.super.setDescription(description);
        }

        public void setReference(String reference) {
            RequirementVersion.this.reference = reference;
        }

        public void setCriticality(RequirementCriticality criticality) {
            RequirementVersion.this.criticality = criticality;
        }

        public void setCategory(InfoListItem category) {
            RequirementVersion.this.category = category;
        }

        public void setStatus(RequirementStatus status) {
            RequirementVersion.this.status = status;
        }

        public void setVersionNumber(int versionNumber) {
            RequirementVersion.this.versionNumber = versionNumber;
        }

        public void setCreatedBy(String createdBy) {
            RequirementVersion audit = RequirementVersion.this;
            audit.setCreatedBy(createdBy);
        }

        public void setCreatedOn(Date createdOn) {
            RequirementVersion audit = RequirementVersion.this;
            audit.setCreatedOn(createdOn);
        }

        public void setLastModifiedBy(String lastModifiedBy) {
            RequirementVersion audit = RequirementVersion.this;
            audit.setLastModifiedBy(lastModifiedBy);
        }

        public void setLastModifiedOn(Date lastModifiedOn) {
            RequirementVersion audit = RequirementVersion.this;
            audit.setLastModifiedOn(lastModifiedOn);
        }
    }
}

