/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.requirement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderColumn;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.core.foundation.exception.NullArgumentException;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.library.Folder;
import org.squashtest.tm.domain.library.FolderSupport;
import org.squashtest.tm.domain.library.NodeContainerVisitor;
import org.squashtest.tm.domain.library.NodeVisitor;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.RequirementFolderSyncExtender;
import org.squashtest.tm.domain.requirement.RequirementLibraryNode;
import org.squashtest.tm.domain.requirement.RequirementLibraryNodeVisitor;
import org.squashtest.tm.domain.resource.SimpleResource;

@Entity
@PrimaryKeyJoinColumn(name="RLN_ID")
public class RequirementFolder
extends RequirementLibraryNode<SimpleResource>
implements Folder<RequirementLibraryNode> {
    @Transient
    private final FolderSupport<RequirementLibraryNode, RequirementFolder> folderSupport = new FolderSupport(this);
    @OneToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @OrderColumn(name="CONTENT_ORDER")
    @JoinTable(name="RLN_RELATIONSHIP", joinColumns={@JoinColumn(name="ANCESTOR_ID")}, inverseJoinColumns={@JoinColumn(name="DESCENDANT_ID")})
    private List<RequirementLibraryNode> content = new ArrayList<RequirementLibraryNode>();
    @OneToOne(cascade={CascadeType.ALL})
    @NotNull
    @JoinColumn(name="RES_ID", updatable=false)
    private SimpleResource resource;
    @OneToOne(mappedBy="requirementFolder", cascade={CascadeType.ALL}, optional=true)
    private RequirementFolderSyncExtender requirementFolderSyncExtender;

    public RequirementFolder() {
        this.resource = new SimpleResource();
    }

    public RequirementFolder(Date createdOn, String createdBy) {
        RequirementFolder audit = this;
        audit.setCreatedOn(createdOn);
        audit.setCreatedBy(createdBy);
        this.resource = new SimpleResource();
    }

    @Override
    public List<RequirementLibraryNode> getContent() {
        return this.content;
    }

    @Override
    public void accept(RequirementLibraryNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(NodeContainerVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void removeContent(RequirementLibraryNode contentToRemove) throws NullArgumentException {
        this.content.remove(contentToRemove);
        this.content = new ArrayList<RequirementLibraryNode>(this.content);
    }

    @Override
    public void addContent(RequirementLibraryNode node) {
        RequirementLibraryNode requirementLibraryNode = node;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)requirementLibraryNode);
        this.folderSupport.addContent(node);
    }

    @Override
    public void addContent(RequirementLibraryNode node, int position) {
        RequirementLibraryNode requirementLibraryNode = node;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)requirementLibraryNode);
        this.folderSupport.addContent(node, position);
        this.content = new ArrayList<RequirementLibraryNode>(this.content);
    }

    @Override
    public boolean isContentNameAvailable(String name) {
        return this.folderSupport.isContentNameAvailable(name);
    }

    @Override
    public RequirementFolder createCopy() {
        return this.folderSupport.createCopy(new RequirementFolder());
    }

    @Override
    public void notifyAssociatedWithProject(Project project) {
        GenericProject former = this.getProject();
        super.notifyAssociatedWithProject(project);
        this.folderSupport.notifyAssociatedProjectWasSet((Project)former, project);
    }

    @Override
    public boolean hasContent() {
        return this.folderSupport.hasContent();
    }

    @Override
    public void setName(String name) {
        this.resource.setName(name);
    }

    @Override
    public void setDescription(String description) {
        this.resource.setDescription(description);
    }

    @Override
    public String getName() {
        return this.resource.getName();
    }

    @Override
    public String getDescription() {
        return this.resource.getDescription();
    }

    @Override
    public SimpleResource getResource() {
        return this.resource;
    }

    public void emptyContent() {
        this.content.clear();
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public List<String> getContentNames() {
        return this.folderSupport.getContentNames();
    }

    @Override
    public Collection<RequirementLibraryNode> getOrderedContent() {
        return this.content;
    }

    @Override
    public boolean allowContentWithIdenticalName() {
        return true;
    }

    public RequirementFolderSyncExtender getRequirementFolderSyncExtender() {
        return this.requirementFolderSyncExtender;
    }

    public void setRequirementFolderSyncExtender(RequirementFolderSyncExtender requirementFolderSyncExtender) {
        this.requirementFolderSyncExtender = requirementFolderSyncExtender;
    }

    public boolean isSynchronized() {
        return this.requirementFolderSyncExtender != null;
    }

    @Override
    public Long getBoundEntityId() {
        return this.getId();
    }

    @Override
    public BindableEntity getBoundEntityType() {
        return BindableEntity.REQUIREMENT_FOLDER;
    }

    @Override
    public EntityReference toEntityReference() {
        return new EntityReference(EntityType.REQUIREMENT_FOLDER, this.getId());
    }
}

