/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.query;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.query.DataType;
import org.squashtest.tm.domain.query.Operation;
import org.squashtest.tm.domain.query.QueryColumnPrototype;
import org.squashtest.tm.domain.query.QueryColumnPrototypeInstance;
import org.squashtest.tm.domain.query.SpecializedEntityType;

@Entity
@Table(name="QUERY_FILTER_COLUMN")
public class QueryFilterColumn
implements QueryColumnPrototypeInstance {
    @Id
    @Column(name="QUERY_FILTER_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="query_filter_column_query_filter_id")
    @SequenceGenerator(name="query_filter_column_query_filter_id", sequenceName="query_filter_column_query_filter_id")
    private Long id;
    @ManyToOne
    @JoinColumn(name="QUERY_COLUMN_ID", nullable=false)
    private QueryColumnPrototype column;
    @Enumerated(value=EnumType.STRING)
    @Column(name="FILTER_OPERATION")
    private Operation operation;
    private Long cufId;
    @ElementCollection
    @CollectionTable(name="QUERY_FILTER_VALUES", joinColumns={@JoinColumn(name="QUERY_FILTER_ID")})
    @Column(name="FILTER_VALUE")
    private List<String> values = new ArrayList<String>();

    @Override
    public QueryColumnPrototype getColumn() {
        return this.column;
    }

    @Override
    public EntityType getEntityType() {
        return this.column.getEntityType();
    }

    @Override
    public SpecializedEntityType getSpecializedType() {
        return this.column.getSpecializedType();
    }

    @Override
    public DataType getDataType() {
        return this.column.getDataType();
    }

    @Override
    public Operation getOperation() {
        return this.operation;
    }

    @Override
    public Long getCufId() {
        return this.cufId;
    }

    public void setColumn(QueryColumnPrototype column) {
        this.column = column;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public void setCufId(Long cufId) {
        this.cufId = cufId;
    }

    public List<String> getValues() {
        return this.values;
    }

    public void addValues(List<String> values) {
        this.values.addAll(values);
    }

    public void removeValues(List<String> values) {
        this.values.removeAll(values);
    }
}

