/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.project;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.Where;
import org.squashtest.csp.core.bugtracker.domain.BugTracker;
import org.squashtest.tm.domain.AclPrimaryObject;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.actionword.ActionWordLibrary;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.attachment.AttachmentList;
import org.squashtest.tm.domain.audit.Auditable;
import org.squashtest.tm.domain.audit.BaseAuditableEntity;
import org.squashtest.tm.domain.bdd.BddImplementationTechnology;
import org.squashtest.tm.domain.bdd.BddScriptLanguage;
import org.squashtest.tm.domain.bugtracker.BugTrackerBinding;
import org.squashtest.tm.domain.campaign.CampaignLibrary;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.customreport.CustomReportLibrary;
import org.squashtest.tm.domain.environmenttag.AutomationEnvironmentTag;
import org.squashtest.tm.domain.infolist.InfoList;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.project.AutomationWorkflowType;
import org.squashtest.tm.domain.project.GenericLibrary;
import org.squashtest.tm.domain.project.ProjectTemplate;
import org.squashtest.tm.domain.project.ProjectVisitor;
import org.squashtest.tm.domain.requirement.RequirementLibrary;
import org.squashtest.tm.domain.scm.ScmRepository;
import org.squashtest.tm.domain.testautomation.TestAutomationProject;
import org.squashtest.tm.domain.testautomation.TestAutomationServer;
import org.squashtest.tm.domain.testautomation.TestAutomationServerKind;
import org.squashtest.tm.domain.testcase.TestCaseLibrary;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequestLibrary;
import org.squashtest.tm.exception.NoBugTrackerBindingException;

@Auditable
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="PROJECT_TYPE", discriminatorType=DiscriminatorType.STRING)
@Entity
@Table(name="PROJECT")
public abstract class GenericProject
extends BaseAuditableEntity
implements AttachmentHolder,
BoundEntity,
AclPrimaryObject {
    @Id
    @Column(name="PROJECT_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="project_project_id_seq")
    @SequenceGenerator(name="project_project_id_seq", sequenceName="project_project_id_seq", allocationSize=1)
    private Long id;
    @Lob
    @Type(type="org.hibernate.type.TextType")
    private String description;
    @Size(max=255)
    private @Size(max=255) String label;
    @NotBlank
    @Size(max=255)
    private @NotBlank @Size(max=255) String name;
    private boolean active = true;
    @JoinColumn(name="TEMPLATE_ID")
    @ManyToOne(fetch=FetchType.LAZY)
    private ProjectTemplate template;
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="TCL_ID")
    private TestCaseLibrary testCaseLibrary;
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="RL_ID")
    private RequirementLibrary requirementLibrary;
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="CL_ID")
    private CampaignLibrary campaignLibrary;
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="CRL_ID")
    private CustomReportLibrary customReportLibrary;
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="ARL_ID")
    private AutomationRequestLibrary automationRequestLibrary;
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="AWL_ID")
    private ActionWordLibrary actionWordLibrary;
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="project")
    private BugTrackerBinding bugtrackerBinding;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="tmProject")
    private Set<TestAutomationProject> testAutomationProjects = new HashSet<TestAutomationProject>();
    @JoinColumn(name="TA_SERVER_ID")
    @ManyToOne(fetch=FetchType.LAZY)
    private TestAutomationServer testAutomationServer;
    @JoinColumn(name="SCM_REPOSITORY_ID")
    @ManyToOne(fetch=FetchType.LAZY)
    private ScmRepository scmRepository;
    @OneToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE}, fetch=FetchType.LAZY)
    @JoinColumn(name="ATTACHMENT_LIST_ID", updatable=false)
    private final AttachmentList attachmentList = new AttachmentList();
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="REQ_CATEGORIES_LIST")
    private InfoList requirementCategories;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="TC_NATURES_LIST")
    private InfoList testCaseNatures;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="TC_TYPES_LIST")
    private InfoList testCaseTypes;
    @ManyToMany(mappedBy="projects")
    private Set<Milestone> milestones = new HashSet<Milestone>();
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private BddImplementationTechnology bddImplementationTechnology = BddImplementationTechnology.CUCUMBER_5_PLUS;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private BddScriptLanguage bddScriptLanguage = BddScriptLanguage.ENGLISH;
    private boolean allowTcModifDuringExec = false;
    private boolean allowAutomationWorkflow = false;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private AutomationWorkflowType automationWorkflowType = AutomationWorkflowType.NONE;
    private boolean useTreeStructureInScmRepo = true;
    private Integer automatedSuitesLifetime;
    private boolean inheritsEnvironmentTags = true;
    @ElementCollection
    @CollectionTable(name="AUTOMATION_ENVIRONMENT_TAG", joinColumns={@JoinColumn(name="ENTITY_ID")})
    @Where(clause="ENTITY_TYPE = 'PROJECT'")
    private List<AutomationEnvironmentTag> environmentTags = new ArrayList<AutomationEnvironmentTag>();

    public List<Milestone> getMilestones() {
        return new ArrayList<Milestone>(this.milestones);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @NotBlank
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name.trim();
    }

    public void setActive(boolean isActive) {
        this.active = isActive;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isBugtrackerConnected() {
        return this.bugtrackerBinding != null;
    }

    public TestCaseLibrary getTestCaseLibrary() {
        return this.testCaseLibrary;
    }

    public void setTestCaseLibrary(TestCaseLibrary testCaseLibrary) {
        this.testCaseLibrary = testCaseLibrary;
        this.notifyLibraryAssociation(testCaseLibrary);
    }

    public RequirementLibrary getRequirementLibrary() {
        return this.requirementLibrary;
    }

    public void setRequirementLibrary(RequirementLibrary requirementLibrary) {
        this.requirementLibrary = requirementLibrary;
        this.notifyLibraryAssociation(requirementLibrary);
    }

    public CampaignLibrary getCampaignLibrary() {
        return this.campaignLibrary;
    }

    public void setCampaignLibrary(CampaignLibrary campaignLibrary) {
        this.campaignLibrary = campaignLibrary;
        this.notifyLibraryAssociation(campaignLibrary);
    }

    public AutomationRequestLibrary getAutomationRequestLibrary() {
        return this.automationRequestLibrary;
    }

    public void setAutomationRequestLibrary(AutomationRequestLibrary automationRequestLibrary) {
        this.automationRequestLibrary = automationRequestLibrary;
        if (automationRequestLibrary != null) {
            automationRequestLibrary.notifyAssociatedWithProject(this);
        }
    }

    public CustomReportLibrary getCustomReportLibrary() {
        return this.customReportLibrary;
    }

    public void setCustomReportLibrary(CustomReportLibrary customReportLibrary) {
        this.customReportLibrary = customReportLibrary;
    }

    public ActionWordLibrary getActionWordLibrary() {
        return this.actionWordLibrary;
    }

    public void setActionWordLibrary(ActionWordLibrary actionWordLibrary) {
        this.actionWordLibrary = actionWordLibrary;
    }

    public BugTrackerBinding getBugtrackerBinding() {
        return this.bugtrackerBinding;
    }

    public void setBugtrackerBinding(BugTrackerBinding bugtrackerBinding) {
        this.bugtrackerBinding = bugtrackerBinding;
    }

    private void notifyLibraryAssociation(GenericLibrary<?> library) {
        if (library != null) {
            library.notifyAssociatedWithProject(this);
        }
    }

    @Override
    public AttachmentList getAttachmentList() {
        return this.attachmentList;
    }

    public void bindTestAutomationProject(TestAutomationProject project) {
        for (TestAutomationProject proj : this.testAutomationProjects) {
            if (!proj.getId().equals(project.getId())) continue;
            return;
        }
        this.testAutomationProjects.add(project);
    }

    public void unbindTestAutomationProject(TestAutomationProject project) {
        Iterator<TestAutomationProject> iter = this.testAutomationProjects.iterator();
        while (iter.hasNext()) {
            TestAutomationProject proj = iter.next();
            if (!proj.getId().equals(project.getId())) continue;
            iter.remove();
            break;
        }
    }

    public void unbindTestAutomationProject(long taProjectId) {
        Iterator<TestAutomationProject> iter = this.testAutomationProjects.iterator();
        while (iter.hasNext()) {
            TestAutomationProject proj = iter.next();
            if (!proj.getId().equals(taProjectId)) continue;
            iter.remove();
            break;
        }
    }

    public boolean isTestAutomationEnabled() {
        return this.testAutomationServer != null;
    }

    public boolean isLegacyTestAutomationEnabled() {
        return this.testAutomationServer != null && this.testAutomationServer.getKind().equals((Object)TestAutomationServerKind.jenkins);
    }

    public TestAutomationServer getTestAutomationServer() {
        return this.testAutomationServer;
    }

    public void setTestAutomationServer(TestAutomationServer server) {
        this.testAutomationServer = server;
    }

    public boolean hasTestAutomationProjects() {
        return !this.testAutomationProjects.isEmpty();
    }

    public Collection<TestAutomationProject> getTestAutomationProjects() {
        return this.testAutomationProjects;
    }

    public boolean isBoundToTestAutomationProject(TestAutomationProject p) {
        return this.testAutomationProjects.contains(p);
    }

    public TestAutomationProject findTestAutomationProjectByJob(TestAutomationProject p) {
        for (TestAutomationProject mine : this.testAutomationProjects) {
            if (!mine.referencesSameJob(p)) continue;
            return mine;
        }
        return null;
    }

    public void removeBugTrackerBinding() {
        this.bugtrackerBinding = null;
    }

    public BugTracker findBugTracker() {
        if (this.isBugtrackerConnected()) {
            return this.getBugtrackerBinding().getBugtracker();
        }
        throw new NoBugTrackerBindingException();
    }

    public InfoList getRequirementCategories() {
        return this.requirementCategories;
    }

    public void setRequirementCategories(InfoList requirementCategories) {
        this.requirementCategories = requirementCategories;
    }

    public InfoList getTestCaseNatures() {
        return this.testCaseNatures;
    }

    public void setTestCaseNatures(InfoList testCaseNatures) {
        this.testCaseNatures = testCaseNatures;
    }

    public InfoList getTestCaseTypes() {
        return this.testCaseTypes;
    }

    public void setTestCaseTypes(InfoList testCaseTypes) {
        this.testCaseTypes = testCaseTypes;
    }

    public void setTestAutomationProjects(Set<TestAutomationProject> testAutomationProjects) {
        this.testAutomationProjects = testAutomationProjects;
    }

    public abstract void accept(ProjectVisitor var1);

    public void unbindMilestone(Milestone milestone) {
        this.removeMilestone(milestone);
        milestone.removeProject(this);
    }

    public void removeMilestone(Milestone milestone) {
        Iterator<Milestone> iter = this.milestones.iterator();
        while (iter.hasNext()) {
            Milestone mil = iter.next();
            if (!mil.getId().equals(milestone.getId())) continue;
            iter.remove();
            break;
        }
    }

    public void unbindMilestones(List<Milestone> milestones) {
        for (Milestone milestone : milestones) {
            this.unbindMilestone(milestone);
        }
    }

    public void addMilestone(Milestone milestone) {
        this.milestones.add(milestone);
    }

    public void bindMilestone(Milestone milestone) {
        this.milestones.add(milestone);
        milestone.addProject(this);
    }

    public void bindMilestones(List<Milestone> milestones) {
        for (Milestone milestone : milestones) {
            this.bindMilestone(milestone);
        }
    }

    public boolean isBoundToMilestone(Milestone milestone) {
        return this.milestones.contains(milestone);
    }

    public void setAllowTcModifDuringExec(boolean allowTcModifDuringExec) {
        this.allowTcModifDuringExec = allowTcModifDuringExec;
    }

    public boolean allowTcModifDuringExec() {
        return this.allowTcModifDuringExec;
    }

    public ProjectTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(ProjectTemplate template) {
        this.template = template;
    }

    public boolean isBoundToTemplate() {
        return this.template != null;
    }

    public boolean isAllowAutomationWorkflow() {
        return this.allowAutomationWorkflow;
    }

    public void setAllowAutomationWorkflow(boolean allowAutomationWorkflow) {
        this.allowAutomationWorkflow = allowAutomationWorkflow;
    }

    public ScmRepository getScmRepository() {
        return this.scmRepository;
    }

    public void setScmRepository(ScmRepository scmRepository) {
        this.scmRepository = scmRepository;
    }

    public boolean isUseTreeStructureInScmRepo() {
        return this.useTreeStructureInScmRepo;
    }

    public void setUseTreeStructureInScmRepo(boolean useTreeStructureInScmRepo) {
        this.useTreeStructureInScmRepo = useTreeStructureInScmRepo;
    }

    public AutomationWorkflowType getAutomationWorkflowType() {
        return this.automationWorkflowType;
    }

    public void setAutomationWorkflowType(AutomationWorkflowType automationWorkflowType) {
        this.automationWorkflowType = automationWorkflowType;
    }

    public BddImplementationTechnology getBddImplementationTechnology() {
        return this.bddImplementationTechnology;
    }

    public void setBddImplementationTechnology(BddImplementationTechnology bddImplementationTechnology) {
        this.bddImplementationTechnology = bddImplementationTechnology;
    }

    public BddScriptLanguage getBddScriptLanguage() {
        return this.bddScriptLanguage;
    }

    public void setBddScriptLanguage(BddScriptLanguage bddScriptLanguage) {
        this.bddScriptLanguage = bddScriptLanguage;
    }

    public Integer getAutomatedSuitesLifetime() {
        return this.automatedSuitesLifetime;
    }

    public void setAutomatedSuitesLifetime(Integer automatedSuitesLifetime) {
        this.automatedSuitesLifetime = automatedSuitesLifetime;
    }

    public boolean isInheritsEnvironmentTags() {
        return this.inheritsEnvironmentTags;
    }

    public void setInheritsEnvironmentTags(boolean inheritsEnvironmentTags) {
        this.inheritsEnvironmentTags = inheritsEnvironmentTags;
    }

    public List<AutomationEnvironmentTag> getEnvironmentTags() {
        return this.environmentTags;
    }

    public void setEnvironmentTags(List<AutomationEnvironmentTag> environmentTags) {
        this.environmentTags = environmentTags;
    }

    @Override
    public EntityReference toEntityReference() {
        return new EntityReference(EntityType.PROJECT, this.getId());
    }
}

