/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.milestone;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.hibernate.annotations.Type;
import org.springframework.format.annotation.DateTimeFormat;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.audit.Auditable;
import org.squashtest.tm.domain.audit.BaseAuditableEntity;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.milestone.MilestoneRange;
import org.squashtest.tm.domain.milestone.MilestoneStatus;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.project.ProjectTemplate;
import org.squashtest.tm.domain.project.ProjectVisitor;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.users.User;

@Auditable
@Entity
@Table(name="MILESTONE")
public class Milestone
extends BaseAuditableEntity
implements Identified {
    private static final String MILESTONE_ID = "MILESTONE_ID";
    @Id
    @Column(name="MILESTONE_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="milestone_milestone_id_seq")
    @SequenceGenerator(name="milestone_milestone_id_seq", sequenceName="milestone_milestone_id_seq", allocationSize=1)
    private Long id;
    @Lob
    @Type(type="org.hibernate.type.TextType")
    private String description;
    @NotBlank
    @Pattern(regexp="[^|]*")
    @Size(min=0, max=30)
    private @NotBlank @Pattern(regexp="[^|]*") @Size(min=0, max=30) String label;
    @Enumerated(value=EnumType.STRING)
    private MilestoneStatus status;
    @Enumerated(value=EnumType.STRING)
    @Column(name="M_RANGE")
    private MilestoneRange range;
    @NotNull
    @DateTimeFormat(pattern="yy-MM-dd")
    private Date endDate;
    @ManyToMany(cascade={CascadeType.DETACH})
    @JoinTable(name="MILESTONE_BINDING", joinColumns={@JoinColumn(name="MILESTONE_ID")}, inverseJoinColumns={@JoinColumn(name="PROJECT_ID")})
    private Set<GenericProject> projects = new HashSet<GenericProject>();
    @ManyToMany(cascade={CascadeType.DETACH})
    @JoinTable(name="MILESTONE_BINDING_PERIMETER", joinColumns={@JoinColumn(name="MILESTONE_ID")}, inverseJoinColumns={@JoinColumn(name="PROJECT_ID")})
    private Set<GenericProject> perimeter = new HashSet<GenericProject>();
    @JoinColumn(name="USER_ID")
    @ManyToOne(cascade={CascadeType.DETACH})
    private User owner;
    @Deprecated
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.DETACH})
    @JoinTable(name="MILESTONE_TEST_CASE", joinColumns={@JoinColumn(name="MILESTONE_ID")}, inverseJoinColumns={@JoinColumn(name="TEST_CASE_ID")})
    private Set<TestCase> testCases = new HashSet<TestCase>();
    @Deprecated
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.DETACH})
    @JoinTable(name="MILESTONE_REQ_VERSION", joinColumns={@JoinColumn(name="MILESTONE_ID")}, inverseJoinColumns={@JoinColumn(name="REQ_VERSION_ID")})
    private Set<RequirementVersion> requirementVersions = new HashSet<RequirementVersion>();
    @Deprecated
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.DETACH})
    @JoinTable(name="MILESTONE_CAMPAIGN", joinColumns={@JoinColumn(name="MILESTONE_ID")}, inverseJoinColumns={@JoinColumn(name="CAMPAIGN_ID")})
    private Set<Campaign> campaigns = new HashSet<Campaign>();

    public List<GenericProject> getPerimeter() {
        return new ArrayList<GenericProject>(this.perimeter);
    }

    public User getOwner() {
        return this.owner;
    }

    public void setOwner(User owner) {
        this.owner = owner;
    }

    public int getNbOfBindedProject() {
        return this.projects.size();
    }

    public List<GenericProject> getProjects() {
        return new ArrayList<GenericProject>(this.projects);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public MilestoneStatus getStatus() {
        return this.status;
    }

    public void setStatus(MilestoneStatus status) {
        this.status = status;
    }

    public MilestoneRange getRange() {
        return this.range;
    }

    public void setRange(MilestoneRange range) {
        this.range = range;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public void unbindProject(GenericProject genericProject) {
        this.removeProject(genericProject);
        genericProject.removeMilestone(this);
    }

    public void removeProject(GenericProject project) {
        Iterator<GenericProject> iter = this.projects.iterator();
        while (iter.hasNext()) {
            GenericProject proj = iter.next();
            if (!proj.getId().equals(project.getId())) continue;
            iter.remove();
            break;
        }
    }

    public void unbindProjects(List<GenericProject> projects) {
        for (GenericProject project : projects) {
            this.unbindProject(project);
        }
    }

    public void bindProject(GenericProject project) {
        this.projects.add(project);
        project.addMilestone(this);
    }

    public void addProject(GenericProject genericProject) {
        this.projects.add(genericProject);
    }

    public void bindProjects(List<GenericProject> projects) {
        for (GenericProject project : projects) {
            this.bindProject(project);
        }
    }

    public void addProjectToPerimeter(GenericProject genericProject) {
        if (!this.isInPerimeter(genericProject)) {
            this.perimeter.add(genericProject);
        }
    }

    public boolean isInPerimeter(GenericProject genericProject) {
        for (GenericProject project : this.perimeter) {
            if (!project.getName().equals(genericProject.getName())) continue;
            return true;
        }
        return false;
    }

    public void addProjectsToPerimeter(List<GenericProject> projects) {
        this.perimeter.addAll(projects);
    }

    public void removeProjectsFromPerimeter(List<GenericProject> projects) {
        for (GenericProject project : projects) {
            this.removeProjectFromPerimeter(project);
        }
    }

    public void removeProjectFromPerimeter(GenericProject project) {
        Iterator<GenericProject> iter = this.perimeter.iterator();
        while (iter.hasNext()) {
            GenericProject proj = iter.next();
            if (!proj.getId().equals(project.getId())) continue;
            iter.remove();
            break;
        }
    }

    @Deprecated
    public Set<TestCase> getTestCases() {
        return this.testCases;
    }

    @Deprecated
    public Set<RequirementVersion> getRequirementVersions() {
        return this.requirementVersions;
    }

    @Deprecated
    public Set<Campaign> getCampaigns() {
        return this.campaigns;
    }

    @Deprecated
    public void bindTestCase(TestCase testCase) {
        this.testCases.add(testCase);
    }

    @Deprecated
    public void bindRequirementVersion(RequirementVersion version) {
        if (this.requirementVersions.contains(version)) {
            return;
        }
        if (this.isOneVersionAlreadyBound(version)) {
            throw new IllegalArgumentException("Another version of this requirement is already bound to this milestone");
        }
        this.requirementVersions.add(version);
    }

    public boolean isOneVersionAlreadyBound(RequirementVersion version) {
        ArrayList<RequirementVersion> allVersions = new ArrayList<RequirementVersion>(version.getRequirement().getRequirementVersions());
        CollectionUtils.filter(allVersions, (Predicate)new Predicate(){

            public boolean evaluate(Object reqV) {
                return ((RequirementVersion)reqV).getMilestones().contains(Milestone.this);
            }
        });
        return CollectionUtils.containsAny(this.requirementVersions, allVersions);
    }

    public boolean isBoundToATemplate() {
        final boolean[] boundToTemplate = new boolean[1];
        for (GenericProject proj : this.projects) {
            proj.accept(new ProjectVisitor(){

                @Override
                public void visit(ProjectTemplate projectTemplate) {
                    boundToTemplate[0] = true;
                }

                @Override
                public void visit(Project project) {
                }
            });
            if (!boundToTemplate[0]) continue;
            return true;
        }
        return false;
    }

    public void removeTemplates() {
        this.removeTemplates(this.perimeter);
        this.removeTemplates(this.projects);
    }

    private void removeTemplates(Collection<GenericProject> col) {
        final Iterator<GenericProject> iter = col.iterator();
        while (iter.hasNext()) {
            GenericProject proj = iter.next();
            proj.accept(new ProjectVisitor(){

                @Override
                public void visit(ProjectTemplate projectTemplate) {
                    iter.remove();
                }

                @Override
                public void visit(Project project) {
                }
            });
        }
    }

    public static Boolean allowsEdition(Collection<Milestone> milestones) {
        Boolean allowed = Boolean.TRUE;
        for (Milestone m : milestones) {
            if (m.getStatus().isAllowObjectModification()) continue;
            allowed = Boolean.FALSE;
            break;
        }
        return allowed;
    }

    public static Boolean allowsCreationOrDeletion(Collection<Milestone> milestones) {
        Boolean allowed = Boolean.TRUE;
        for (Milestone m : milestones) {
            if (m.getStatus().isAllowObjectCreateAndDelete()) continue;
            allowed = Boolean.FALSE;
            break;
        }
        return allowed;
    }

    public boolean isLocked() {
        return MilestoneStatus.LOCKED == this.status;
    }

    public boolean isBindableToObject() {
        return this.status.isBindableToObject();
    }

    public void unbindAllProjects() {
        this.projects.clear();
    }

    public void clearPerimeter() {
        this.perimeter.clear();
    }

    public void clearObjects() {
        this.campaigns.clear();
        this.testCases.clear();
        this.requirementVersions.clear();
    }
}

