/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.library;

import java.util.ArrayList;
import java.util.List;
import org.squashtest.tm.domain.attachment.Attachment;
import org.squashtest.tm.domain.library.Folder;
import org.squashtest.tm.domain.library.LibraryNode;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.exception.DuplicateNameException;

public class FolderSupport<NODE extends LibraryNode, FOLDER extends Folder<NODE>> {
    private final FOLDER folder;

    public FolderSupport(FOLDER folder) {
        this.folder = folder;
    }

    public void addContent(NODE node) {
        this.checkContentNameAvailable(node);
        this.folder.getContent().add(node);
        node.notifyAssociatedWithProject(this.folder.getProject());
    }

    public void addContent(NODE node, int position) {
        this.checkContentNameAvailable(node);
        if (position >= this.folder.getContent().size() || position < 0) {
            this.folder.addContent(node);
        } else {
            this.folder.getContent().add(position, node);
        }
        node.notifyAssociatedWithProject(this.folder.getProject());
    }

    private void checkContentNameAvailable(NODE candidateContent) throws DuplicateNameException {
        if (!this.folder.allowContentWithIdenticalName() && !this.isContentNameAvailable(candidateContent.getName())) {
            throw new DuplicateNameException(candidateContent.getName(), candidateContent.getName());
        }
    }

    public boolean isContentNameAvailable(String name) {
        for (LibraryNode folderContent : this.folder.getContent()) {
            if (!folderContent.getName().equals(name)) continue;
            return false;
        }
        return true;
    }

    public void notifyAssociatedProjectWasSet(Project formerProject, Project currentProject) {
        if (this.notSameProject(formerProject, currentProject)) {
            for (LibraryNode node : this.folder.getContent()) {
                node.notifyAssociatedWithProject(currentProject);
            }
        }
    }

    private boolean notSameProject(Project thisProject, Project thatProject) {
        if (thisProject == null && thatProject == null) {
            return false;
        }
        if (thisProject == null) {
            return true;
        }
        return !thisProject.equals(thatProject);
    }

    public boolean hasContent() {
        return !this.folder.getContent().isEmpty();
    }

    public FOLDER createCopy(FOLDER newFolder) {
        newFolder.setName(this.folder.getName());
        newFolder.setDescription(this.folder.getDescription());
        newFolder.notifyAssociatedWithProject(this.folder.getProject());
        this.addCopiesOfAttachments((Folder<NODE>)this.folder, (Folder<NODE>)newFolder);
        return newFolder;
    }

    private void addCopiesOfAttachments(Folder<NODE> source, Folder<NODE> destination) {
        for (Attachment tcAttach : source.getAttachmentList().getAllAttachments()) {
            Attachment atCopy = tcAttach.shallowCopy();
            destination.getAttachmentList().addAttachment(atCopy);
        }
    }

    public List<String> getContentNames() {
        ArrayList<String> contentNames = new ArrayList<String>(this.folder.getContent().size());
        for (LibraryNode node : this.folder.getContent()) {
            contentNames.add(node.getName());
        }
        return contentNames;
    }
}

