/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.library;

import java.util.Date;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.library.Folder;
import org.squashtest.tm.domain.library.LibraryNode;

public abstract class ExportData {
    private Long id;
    private String folderName = "";
    private String project;
    private String name;
    private String description;
    private Date createdOn;
    private String createdBy;
    private Long folderId;
    public static final Long NO_FOLDER = -1L;

    public ExportData() {
    }

    public ExportData(LibraryNode node, Folder folder) {
        this.id = node.getId();
        this.name = node.getName();
        this.doSetDescription(node.getDescription());
        this.project = node.getProject().getName();
        AuditableMixin audit = (AuditableMixin)((Object)node);
        this.createdOn = audit.getCreatedOn();
        this.createdBy = audit.getCreatedBy();
        if (folder == null) {
            this.folderId = NO_FOLDER;
        } else {
            this.folderId = folder.getId();
            this.doSetFolderName(folder.getName());
        }
    }

    public ExportData(LibraryNode node) {
        this.id = node.getId();
        this.name = node.getName();
        this.doSetDescription(node.getDescription());
        this.project = node.getProject().getName();
        AuditableMixin audit = (AuditableMixin)((Object)node);
        this.createdOn = audit.getCreatedOn();
        this.createdBy = audit.getCreatedBy();
        this.folderId = NO_FOLDER;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.doSetDescription(description);
    }

    private void doSetDescription(String description) {
        if (description != null) {
            this.description = description;
        }
    }

    public String getFolderName() {
        return this.folderName;
    }

    public void setFolderName(String folderName) {
        this.doSetFolderName(folderName);
    }

    private void doSetFolderName(String folderName) {
        if (folderName != null) {
            this.folderName = folderName;
        }
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Long getFolderId() {
        return this.folderId;
    }

    public void setFolderId(Long folderId) {
        this.folderId = folderId;
    }
}

